/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.http.oauth;

import java.rmi.RemoteException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.internal.InputAdapterServiceDataHolder;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.oauth.OAuthTokenValidaterStubFactory;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.util.AuthenticationInfo;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.identity.oauth2.stub.OAuth2TokenValidationServiceStub;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO_OAuth2AccessToken;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuthAuthenticator {
    private static String cookie;
    private GenericObjectPool stubs;
    private static final Pattern PATTERN;
    private static final String TOKEN_TYPE = "bearer";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static Log log;

    public OAuthAuthenticator(InputEventAdapterConfiguration eventAdapterConfiguration) {
        this.stubs = new GenericObjectPool((PoolableObjectFactory)new OAuthTokenValidaterStubFactory(eventAdapterConfiguration));
    }

    public AuthenticationInfo authenticate(HttpServletRequest req) {
        AuthenticationInfo authenticationInfo;
        block3: {
            authenticationInfo = new AuthenticationInfo();
            String bearerToken = this.getBearerToken(req);
            if (bearerToken == null) {
                return authenticationInfo;
            }
            try {
                authenticationInfo = this.validateToken(bearerToken);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("checkAuthentication() fail: " + e.getMessage()), (Throwable)e);
            }
        }
        return authenticationInfo;
    }

    private String getBearerToken(HttpServletRequest request) {
        Matcher matcher;
        String authorizationHeader = request.getHeader(AUTHORIZATION_HEADER);
        if (authorizationHeader != null && (matcher = PATTERN.matcher(authorizationHeader)).find()) {
            authorizationHeader = authorizationHeader.substring(matcher.end());
        }
        return authorizationHeader;
    }

    private AuthenticationInfo getAuthenticationInfo(String token, OAuth2TokenValidationServiceStub tokenValidationServiceStub) throws RemoteException, UserStoreException {
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        OAuth2TokenValidationRequestDTO validationRequest = new OAuth2TokenValidationRequestDTO();
        OAuth2TokenValidationRequestDTO_OAuth2AccessToken accessToken = new OAuth2TokenValidationRequestDTO_OAuth2AccessToken();
        accessToken.setTokenType(TOKEN_TYPE);
        accessToken.setIdentifier(token);
        validationRequest.setAccessToken(accessToken);
        OAuth2TokenValidationResponseDTO tokenValidationResponse = tokenValidationServiceStub.validate(validationRequest);
        if (tokenValidationResponse == null) {
            authenticationInfo.setAuthenticated(false);
            return authenticationInfo;
        }
        boolean authenticated = tokenValidationResponse.getValid();
        if (authenticated) {
            String authorizedUser = tokenValidationResponse.getAuthorizedUser();
            String username = MultitenantUtils.getTenantAwareUsername((String)authorizedUser);
            String tenantDomain = MultitenantUtils.getTenantDomain((String)authorizedUser);
            authenticationInfo.setUsername(username);
            authenticationInfo.setTenantDomain(tenantDomain);
            RealmService realmService = InputAdapterServiceDataHolder.getRealmService();
            int tenantId = realmService.getTenantManager().getTenantId(authenticationInfo.getTenantDomain());
            authenticationInfo.setTenantId(tenantId);
            authenticationInfo.setScopes(tokenValidationResponse.getScope());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Token validation failed for token: " + token));
        }
        ServiceContext serviceContext = tokenValidationServiceStub._getServiceClient().getLastOperationContext().getServiceContext();
        cookie = (String)serviceContext.getProperty("Cookie");
        authenticationInfo.setAuthenticated(authenticated);
        return authenticationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationInfo validateToken(String token) {
        OAuth2TokenValidationServiceStub tokenValidationServiceStub = null;
        try {
            Object stub = this.stubs.borrowObject();
            if (stub != null) {
                tokenValidationServiceStub = (OAuth2TokenValidationServiceStub)stub;
                if (cookie != null) {
                    tokenValidationServiceStub._getServiceClient().getOptions().setProperty("Cookie", (Object)cookie);
                }
                AuthenticationInfo authenticationInfo = this.getAuthenticationInfo(token, tokenValidationServiceStub);
                return authenticationInfo;
            }
            log.warn((Object)"Stub initialization failed.");
        }
        catch (RemoteException e) {
            log.error((Object)"Error on connecting with the validation endpoint.", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred in borrowing an validation stub from the pool.", (Throwable)e);
        }
        finally {
            try {
                if (tokenValidationServiceStub != null) {
                    this.stubs.returnObject((Object)tokenValidationServiceStub);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Error occurred while returning the object back to the oauth token validation service stub pool.", (Throwable)e);
            }
        }
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        authenticationInfo.setAuthenticated(false);
        authenticationInfo.setTenantId(-1);
        return authenticationInfo;
    }

    static {
        PATTERN = Pattern.compile("[B|b]earer\\s");
        log = LogFactory.getLog(OAuthAuthenticator.class);
    }
}

