/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.http.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.internal.InputAdapterServiceDataHolder;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.util.AuthenticationInfo;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class JWTAuthenticator {
    private static final Log log = LogFactory.getLog(JWTAuthenticator.class);
    public static final String SIGNED_JWT_AUTH_USERNAME = "Username";
    private static final String JWT_ASSERTION_HEADER = "X-JWT-Assertion";

    public boolean isJWTHeaderExist(HttpServletRequest request) {
        String authorizationHeader = request.getHeader(JWT_ASSERTION_HEADER);
        return authorizationHeader != null && !authorizationHeader.isEmpty();
    }

    public AuthenticationInfo authenticate(HttpServletRequest request) {
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)-1234);
        try {
            keyStoreManager.getDefaultPrimaryCertificate();
            String authorizationHeader = request.getHeader("Authorization");
            String headerData = this.decodeAuthorizationHeader(authorizationHeader);
            RSASSAVerifier verifier = new RSASSAVerifier((RSAPublicKey)keyStoreManager.getDefaultPublicKey());
            SignedJWT jwsObject = SignedJWT.parse((String)headerData);
            if (jwsObject.verify((JWSVerifier)verifier)) {
                String username = jwsObject.getJWTClaimsSet().getStringClaim(SIGNED_JWT_AUTH_USERNAME);
                String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
                username = MultitenantUtils.getTenantAwareUsername((String)username);
                TenantManager tenantManager = InputAdapterServiceDataHolder.getRealmService().getTenantManager();
                int tenantId = tenantManager.getTenantId(tenantDomain);
                if (tenantId == -1) {
                    log.error((Object)("tenantDomain is not valid. username : " + username + ", tenantDomain " + ": " + tenantDomain));
                } else {
                    UserStoreManager userStore = InputAdapterServiceDataHolder.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
                    if (userStore.isExistingUser(username)) {
                        authenticationInfo.setTenantId(tenantId);
                        authenticationInfo.setUsername(username);
                        authenticationInfo.setTenantDomain(tenantDomain);
                        authenticationInfo.setAuthenticated(true);
                    }
                }
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error occurred while obtaining the user.", (Throwable)e);
        }
        catch (ParseException e) {
            log.error((Object)"Error occurred while parsing the JWT header.", (Throwable)e);
        }
        catch (JOSEException e) {
            log.error((Object)"Error occurred while verifying the JWT header.", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while verifying the JWT header.", (Throwable)e);
        }
        return authenticationInfo;
    }

    private String decodeAuthorizationHeader(String authorizationHeader) {
        if (authorizationHeader == null) {
            return null;
        }
        String[] splitValues = authorizationHeader.trim().split(" ");
        byte[] decodedBytes = Base64Utils.decode((String)splitValues[1].trim());
        if (decodedBytes != null) {
            return new String(decodedBytes);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Error decoding authorization header.");
        }
        return null;
    }
}

