/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.http.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.HTTPEventAdapterFactory;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.internal.InputAdapterServiceDataHolder;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.user.core.service.RealmService;

public class InputAdapterServiceComponent {
    private static final Log log = LogFactory.getLog(InputAdapterServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            HTTPEventAdapterFactory httpEventEventAdapterFactory = new HTTPEventAdapterFactory();
            context.getBundleContext().registerService(InputEventAdapterFactory.class.getName(), (Object)httpEventEventAdapterFactory, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the input adapter service");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not create the input adapter service ", (Throwable)e);
        }
    }

    protected void setRealmService(RealmService realmService) {
        InputAdapterServiceDataHolder.registerRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        InputAdapterServiceDataHolder.registerRealmService(null);
    }

    protected void setHttpService(HttpService httpService) {
        InputAdapterServiceDataHolder.registerHTTPService(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        InputAdapterServiceDataHolder.registerHTTPService(null);
    }
}

