/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentInfo;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentTransformer;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.ContentValidator;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.DefaultContentTransformer;
import org.wso2.carbon.device.mgt.iot.input.adapter.extension.DefaultContentValidator;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.HTTPEventAdapter;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.exception.HTTPContentInitializationException;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.jwt.JWTAuthenticator;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.oauth.OAuthAuthenticator;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.util.AuthenticationInfo;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;

public class HTTPMessageServlet
extends HttpServlet {
    private static final String AUTH_MESSAGE_STORE_AUTHENTICATION_INFO = "AUTH_MESSAGE_STORE_AUTHENTICATION_INFO";
    private static final String AUTH_FAILURE_RESPONSE = "_AUTH_FAILURE_";
    private static Log log = LogFactory.getLog(HTTPMessageServlet.class);
    private static ContentValidator contentValidator;
    private static ContentTransformer contentTransformer;
    private InputEventAdapterListener eventAdaptorListener;
    private int tenantId;
    private String exposedTransports;
    private static JWTAuthenticator jwtAuthenticator;
    private static OAuthAuthenticator oAuthAuthenticator;

    public HTTPMessageServlet(InputEventAdapterListener eventAdaptorListener, int tenantId, InputEventAdapterConfiguration eventAdapterConfiguration) {
        this.eventAdaptorListener = eventAdaptorListener;
        this.tenantId = tenantId;
        this.exposedTransports = (String)eventAdapterConfiguration.getProperties().get("transports");
        String className = (String)eventAdapterConfiguration.getProperties().get("contentValidator");
        if ("default".equals(className)) {
            contentValidator = new DefaultContentValidator();
        } else {
            try {
                Class<ContentValidator> contentValidatorClass = Class.forName(className).asSubclass(ContentValidator.class);
                contentValidator = contentValidatorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new HTTPContentInitializationException("Unable to find the class validator: " + className, e);
            }
            catch (InstantiationException e) {
                throw new HTTPContentInitializationException("Unable to create an instance of :" + className, e);
            }
            catch (IllegalAccessException e) {
                throw new HTTPContentInitializationException("Access of the instance in not allowed.", e);
            }
        }
        String contentTransformerClassName = (String)eventAdapterConfiguration.getProperties().get("contentTransformer");
        if (contentTransformerClassName != null && contentTransformerClassName.equals("default")) {
            contentTransformer = new DefaultContentTransformer();
        } else if (contentTransformerClassName != null && !contentTransformerClassName.isEmpty()) {
            try {
                Class<ContentTransformer> contentTransformerClass = Class.forName(contentTransformerClassName).asSubclass(ContentTransformer.class);
                contentTransformer = contentTransformerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new HTTPContentInitializationException("Unable to find the class transformer: " + contentTransformerClassName, e);
            }
            catch (InstantiationException e) {
                throw new HTTPContentInitializationException("Unable to create an instance of :" + contentTransformerClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new HTTPContentInitializationException("Access of the instance in not allowed.", e);
            }
        }
        jwtAuthenticator = new JWTAuthenticator();
        oAuthAuthenticator = new OAuthAuthenticator(eventAdapterConfiguration);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        int tenantId;
        String data = this.inputStreamToString((InputStream)req.getInputStream());
        if (data == null) {
            log.warn((Object)"Event Object is empty/null");
            return;
        }
        AuthenticationInfo authenticationInfo = null;
        if (this.exposedTransports.equalsIgnoreCase("https")) {
            if (!req.isSecure()) {
                res.setStatus(403);
                log.error((Object)"Only Secured endpoint is enabled for requests");
                return;
            }
            authenticationInfo = this.checkAuthentication(req);
            int n = tenantId = authenticationInfo != null ? authenticationInfo.getTenantId() : -1;
            if (tenantId == -1) {
                res.getOutputStream().write(AUTH_FAILURE_RESPONSE.getBytes());
                res.setStatus(401);
                log.error((Object)"Authentication failed for the request");
                return;
            }
            if (tenantId != this.tenantId) {
                res.getOutputStream().write(AUTH_FAILURE_RESPONSE.getBytes());
                res.setStatus(401);
                log.error((Object)"Authentication failed for the request");
                return;
            }
        } else if (this.exposedTransports.equalsIgnoreCase("http")) {
            if (req.isSecure()) {
                res.setStatus(403);
                log.error((Object)"Only unsecured endpoint is enabled for requests");
                return;
            }
        } else {
            authenticationInfo = this.checkAuthentication(req);
            int n = tenantId = authenticationInfo != null ? authenticationInfo.getTenantId() : -1;
            if (tenantId == -1) {
                res.getOutputStream().write(AUTH_FAILURE_RESPONSE.getBytes());
                res.setStatus(401);
                log.error((Object)"Authentication failed for the request");
                return;
            }
            if (tenantId != this.tenantId) {
                res.getOutputStream().write(AUTH_FAILURE_RESPONSE.getBytes());
                res.setStatus(401);
                log.error((Object)"Authentication failed for the request");
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message : " + data));
        }
        if (authenticationInfo != null) {
            ContentInfo contentInfo;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            Enumeration reqParameterNames = req.getParameterNames();
            while (reqParameterNames.hasMoreElements()) {
                String paramterName = (String)reqParameterNames.nextElement();
                paramMap.put(paramterName, req.getParameter(paramterName));
            }
            paramMap.put("username", authenticationInfo.getUsername());
            paramMap.put("tenantDomain", authenticationInfo.getTenantDomain());
            paramMap.put("scopes", authenticationInfo.getScopes());
            if (contentValidator != null && contentTransformer != null && (contentInfo = contentValidator.validate((Object)(data = (String)contentTransformer.transform((Object)data, paramMap)), paramMap)) != null && contentInfo.isValidContent()) {
                HTTPEventAdapter.executorService.submit(new HTTPRequestProcessor(this.eventAdaptorListener, (String)contentInfo.getMessage(), this.tenantId));
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.doPost(req, res);
    }

    private AuthenticationInfo checkAuthentication(HttpServletRequest req) {
        boolean success;
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)req.getSession().getAttribute(AUTH_MESSAGE_STORE_AUTHENTICATION_INFO);
        if (authenticationInfo != null) {
            return authenticationInfo;
        }
        authenticationInfo = jwtAuthenticator.isJWTHeaderExist(req) ? jwtAuthenticator.authenticate(req) : oAuthAuthenticator.authenticate(req);
        if (authenticationInfo != null && (success = authenticationInfo.isAuthenticated())) {
            req.getSession().setAttribute(AUTH_MESSAGE_STORE_AUTHENTICATION_INFO, (Object)authenticationInfo);
        }
        return authenticationInfo;
    }

    private String inputStreamToString(InputStream in) throws IOException {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((i = in.read(buff)) > 0) {
            out.write(buff, 0, i);
        }
        out.close();
        return out.toString();
    }

    public class HTTPRequestProcessor
    implements Runnable {
        private InputEventAdapterListener inputEventAdapterListener;
        private String payload;
        private int tenantId;

        public HTTPRequestProcessor(InputEventAdapterListener inputEventAdapterListener, String payload, int tenantId) {
            this.inputEventAdapterListener = inputEventAdapterListener;
            this.payload = payload;
            this.tenantId = tenantId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event received in HTTP Event Adapter - " + this.payload));
                }
                if (this.payload != null) {
                    this.inputEventAdapterListener.onEvent((Object)this.payload);
                } else {
                    log.warn((Object)"Dropping the empty/null event received through http adapter");
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while parsing http request for processing: " + e.getMessage()), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }
}

