/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.device.mgt.iot.input.adapter.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.device.mgt.iot.input.adapter.http.HTTPEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.utils.CarbonUtils;

public class HTTPEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.device.mgt.iot.input.adapter.http.i18n.Resources", Locale.getDefault());
    private int httpPort;
    private int httpsPort;

    public HTTPEventAdapterFactory() {
        int portOffset = this.getPortOffset();
        this.httpPort = 9763 + portOffset;
        this.httpsPort = 9443 + portOffset;
    }

    public String getType() {
        return "oauth-http";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("json");
        supportInputMessageTypes.add("text");
        supportInputMessageTypes.add("xml");
        supportInputMessageTypes.add("wso2event");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property exposedTransportsProperty = new Property("transports");
        exposedTransportsProperty.setRequired(true);
        exposedTransportsProperty.setDisplayName(this.resourceBundle.getString("transports"));
        exposedTransportsProperty.setOptions(new String[]{"https", "http", "local", "all"});
        exposedTransportsProperty.setDefaultValue("all");
        propertyList.add(exposedTransportsProperty);
        Property username = new Property("username");
        username.setRequired(true);
        username.setDisplayName(this.resourceBundle.getString("username"));
        username.setHint(this.resourceBundle.getString("username.hint"));
        propertyList.add(username);
        Property password = new Property("password");
        password.setRequired(true);
        password.setDisplayName(this.resourceBundle.getString("password"));
        password.setHint(this.resourceBundle.getString("password.hint"));
        propertyList.add(password);
        Property tokenValidationEndpoint = new Property("tokenValidationEndpointUrl");
        tokenValidationEndpoint.setRequired(true);
        tokenValidationEndpoint.setDisplayName(this.resourceBundle.getString("tokenValidationEndpointUrl"));
        tokenValidationEndpoint.setHint(this.resourceBundle.getString("tokenValidationEndpointUrl.hint"));
        propertyList.add(tokenValidationEndpoint);
        Property maximumHttpConnectionPerHost = new Property("maximumHttpConnectionPerHost");
        maximumHttpConnectionPerHost.setRequired(true);
        maximumHttpConnectionPerHost.setDisplayName(this.resourceBundle.getString("maximumHttpConnectionPerHost"));
        maximumHttpConnectionPerHost.setHint(this.resourceBundle.getString("maximumHttpConnectionPerHost.hint"));
        maximumHttpConnectionPerHost.setDefaultValue("2");
        propertyList.add(maximumHttpConnectionPerHost);
        Property maxTotalHttpConnection = new Property("maximumTotalHttpConnection");
        maxTotalHttpConnection.setRequired(true);
        maxTotalHttpConnection.setDisplayName(this.resourceBundle.getString("maximumTotalHttpConnection"));
        maxTotalHttpConnection.setHint(this.resourceBundle.getString("maximumTotalHttpConnection.hint"));
        maxTotalHttpConnection.setDefaultValue("100");
        propertyList.add(maxTotalHttpConnection);
        Property contentValidator = new Property("contentValidator");
        contentValidator.setDisplayName(this.resourceBundle.getString("contentValidator"));
        contentValidator.setRequired(false);
        contentValidator.setHint(this.resourceBundle.getString("contentValidator.hint"));
        contentValidator.setDefaultValue("default");
        propertyList.add(contentValidator);
        Property contentTransformer = new Property("contentTransformer");
        contentTransformer.setDisplayName(this.resourceBundle.getString("contentTransformer"));
        contentTransformer.setRequired(false);
        contentTransformer.setHint(this.resourceBundle.getString("contentTransformer.hint"));
        contentTransformer.setDefaultValue("default");
        propertyList.add(contentTransformer);
        return propertyList;
    }

    public String getUsageTips() {
        return this.resourceBundle.getString("http.usage.tips_prefix") + this.httpPort + this.resourceBundle.getString("http.usage.tips_mid1") + this.httpsPort + this.resourceBundle.getString("http.usage.tips_mid2") + this.httpPort + this.resourceBundle.getString("http.usage.tips_mid3") + this.httpsPort + this.resourceBundle.getString("http.usage.tips_postfix");
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new HTTPEventAdapter(eventAdapterConfiguration, globalProperties);
    }

    private int getPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }
}

