/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.deployment.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.dashboard.deployment.internal.ServiceHolder;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class DeploymentUtil {
    public static void createRegistryResource(String url, Object content) throws RegistryException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        UserRegistry registry = ServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
        Resource resource = registry.newResource();
        resource.setContent(content);
        resource.setMediaType("application/json");
        registry.put(url, resource);
    }

    public static void removeRegistryResource(String resourcePath) throws RegistryException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        UserRegistry registry = ServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
        if (registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            registry.delete(resourcePath);
        }
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                DeploymentUtil.copyFolder(srcFile, destFile);
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static String readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        return stringBuilder.toString();
    }
}

