/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.deployment.admin;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.dashboard.deployment.DashboardException;
import org.wso2.carbon.dashboard.deployment.internal.ServiceHolder;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class DashboardAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(DashboardAdminService.class);

    public String[] getDashboardsList() throws DashboardException {
        ArrayList<String> dashboards = new ArrayList<String>();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        UserRegistry registry = null;
        try {
            String[] resourceNames;
            registry = ServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
            Collection dashboardsCollection = (Collection)registry.get("/ues/dashboards/");
            for (String resourceName : resourceNames = dashboardsCollection.getChildren()) {
                String dashboard = resourceName.substring(resourceName.lastIndexOf("/") + 1, resourceName.length());
                dashboards.add(dashboard);
            }
        }
        catch (RegistryException e) {
            String errorMsg = "Error occurred while reading dashboards list.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new DashboardException(errorMsg, e);
        }
        return dashboards.toArray(new String[dashboards.size()]);
    }
}

