/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.authorization.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.dashboard.deployment.internal.ServiceHolder;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AuthorizationUtil {
    private static final Log LOG = LogFactory.getLog(AuthorizationUtils.class);

    public static boolean isUserAuthorized(int tenantId, String username, String permission) throws UserStoreException, RegistryException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId, true);
            RealmService realm = ServiceHolder.getRealmService();
            boolean isAuthorized = realm.getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(MultitenantUtils.getTenantAwareUsername((String)username), permission, "ui.execute");
            PrivilegedCarbonContext.endTenantFlow();
            return isAuthorized;
        }
        catch (UserStoreException e) {
            LOG.error((Object)e);
            throw new UserStoreException("Unable to get user permission information for user [ " + username + " ] due to " + e.getMessage(), (Throwable)e);
        }
    }
}

