/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.deployment.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.Feature;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.dashboard.deployment.DashboardDeployer;
import org.wso2.carbon.dashboard.deployment.internal.DSAxis2ConfigurationObserverImpl;
import org.wso2.carbon.dashboard.deployment.internal.ServiceHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

public class DashboardDeployerDS {
    private static Log log = LogFactory.getLog(DashboardDeployerDS.class);
    private static ServiceRegistration appHandlerRegistration;
    private static Map<String, List<Feature>> requiredFeatures;

    public static Map<String, List<Feature>> getRequiredFeatures() {
        return requiredFeatures;
    }

    protected void activate(ComponentContext ctxt) {
        try {
            appHandlerRegistration = ctxt.getBundleContext().registerService(AppDeploymentHandler.class.getName(), (Object)new DashboardDeployer(), null);
            ctxt.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new DSAxis2ConfigurationObserverImpl(), null);
            URL reqFeaturesResource = ctxt.getBundleContext().getBundle().getResource("required-features.xml");
            if (reqFeaturesResource != null) {
                InputStream xmlStream = reqFeaturesResource.openStream();
                requiredFeatures = AppDeployerUtils.readRequiredFeaturs((OMElement)new StAXOMBuilder(xmlStream).getDocumentElement());
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Dashboard Application Deployer", e);
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        ServiceHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ServiceHolder.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        ServiceHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService registryService) {
        ServiceHolder.setRealmService(null);
    }

    protected void deactivate(ComponentContext ctxt) {
        if (appHandlerRegistration != null) {
            appHandlerRegistration.unregister();
        }
    }
}

