/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.deployment.internal;

import java.io.File;
import java.io.IOException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileManipulator;

public class DSAxis2ConfigurationObserverImpl
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(DSAxis2ConfigurationObserverImpl.class);

    public void createdConfigurationContext(ConfigurationContext configContext) {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String tenantDir = this.getTenantDirPath(tenantDomain);
        String layoutDir = tenantDir + "layout";
        String gadgetDir = tenantDir + "gadget";
        this.createTenantDirectory(tenantDir);
        if (!this.isDSTenantIArtifactInitialized(layoutDir)) {
            this.copyResources("layout", layoutDir);
        }
        if (!this.isDSTenantIArtifactInitialized(gadgetDir)) {
            this.copyResources("gadget", gadgetDir);
        }
    }

    private void createTenantDirectory(String tenantDirectory) {
        File file = new File(tenantDirectory);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private boolean isDSTenantIArtifactInitialized(String tenantArtifactDirectory) {
        File file = new File(tenantArtifactDirectory);
        return file.exists();
    }

    private void copyResources(String artifactType, String destinationLocation) {
        File sourceResourceFile = new File(CarbonUtils.getCarbonHome() + File.separator + "repository/resources/sharedstore" + File.separator + artifactType);
        File destinationFile = new File(destinationLocation);
        try {
            FileManipulator.copyDir((File)sourceResourceFile, (File)destinationFile);
        }
        catch (IOException e) {
            log.warn((Object)("Error while retrieving the resources from sharedstore " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true) + e.getMessage()));
        }
    }

    private String getTenantDirPath(String tenantDomain) {
        String carbonRepository = CarbonUtils.getCarbonRepository();
        StringBuilder sb = new StringBuilder(carbonRepository);
        sb.append("jaggeryapps").append(File.separator).append("portal").append(File.separator).append("store").append(File.separator).append(tenantDomain).append(File.separator).append("fs").append(File.separator);
        return sb.toString();
    }
}

