/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.deployment;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.ApplicationConfiguration;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.dashboard.deployment.DashboardDeploymentException;
import org.wso2.carbon.dashboard.deployment.util.DeploymentUtil;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.CarbonUtils;

public class DashboardDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(DashboardDeployer.class);

    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) throws DeploymentException {
        this.checkForTenantDirectory();
        ApplicationConfiguration appConfig = carbonApp.getAppConfig();
        List deps = appConfig.getApplicationArtifact().getDependencies();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact.Dependency dep : deps) {
            if (dep.getArtifact() == null) continue;
            artifacts.add(dep.getArtifact());
        }
        this.deploy(artifacts);
    }

    private void checkForTenantDirectory() throws DeploymentException {
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String carbonRepository = CarbonUtils.getCarbonRepository();
        String path = carbonRepository + "jaggeryapps" + File.separator + "portal" + File.separator + "store" + File.separator + tenantDomain;
        File tenantDir = new File(path.toString());
        if (!tenantDir.exists()) {
            tenantDir.mkdir();
            log.info((Object)("Creating directory " + tenantDomain + " for tenant related dashboard artifacts"));
        }
        try {
            File widgetDir;
            File layoutDir;
            String pathToArtifacts;
            File gadgetDir;
            File storeTypeDir = new File(path + File.separator + "fs");
            if (!storeTypeDir.exists()) {
                storeTypeDir.mkdir();
            }
            if (!(gadgetDir = new File((pathToArtifacts = path + File.separator + "fs") + File.separator + "gadget")).exists()) {
                gadgetDir.mkdir();
            }
            if (!(layoutDir = new File(pathToArtifacts + File.separator + "layout")).exists()) {
                layoutDir.mkdir();
            }
            if (!(widgetDir = new File(pathToArtifacts + File.separator + "widget")).exists()) {
                widgetDir.mkdir();
            }
            log.info((Object)("Created gadget,layout and widget directories for tenant [" + tenantDomain + "]"));
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void deploy(List<Artifact> artifacts) throws DashboardDeploymentException {
        for (Artifact artifact : artifacts) {
            List files = artifact.getFiles();
            if (files == null || files.isEmpty()) continue;
            for (CappFile cappFile : files) {
                File destination;
                String storePath;
                String errorMsg;
                String fileName = cappFile.getName();
                String path = artifact.getExtractedPath() + File.separator + fileName;
                File file = new File(path);
                if ("dashboards/dashboard".equals(artifact.getType())) {
                    try {
                        if (!fileName.endsWith(".json")) continue;
                        String dashboardDefn = DeploymentUtil.readFile(file);
                        String resourceName = fileName.substring(0, fileName.lastIndexOf(".json"));
                        DeploymentUtil.createRegistryResource("/ues/dashboards/" + resourceName, dashboardDefn);
                        log.info((Object)("Dashboard definition [" + resourceName + "] has been created."));
                        continue;
                    }
                    catch (IOException e) {
                        errorMsg = "Error while reading from the file : " + file.getAbsolutePath();
                        log.error((Object)errorMsg, (Throwable)e);
                        throw new DashboardDeploymentException(errorMsg, e);
                    }
                    catch (RegistryException e) {
                        errorMsg = "Error while creating registry resource for dashboard";
                        log.error((Object)errorMsg, (Throwable)e);
                        throw new DashboardDeploymentException(errorMsg, e);
                    }
                }
                if ("dashboards/gadget".equals(artifact.getType())) {
                    try {
                        if (!file.isDirectory()) continue;
                        storePath = this.getArtifactPath("gadget");
                        destination = new File(storePath + file.getName());
                        DeploymentUtil.copyFolder(file, destination);
                        log.info((Object)("Gadget directory [" + file.getName() + "] has been copied to path " + destination.getAbsolutePath()));
                        continue;
                    }
                    catch (IOException e) {
                        errorMsg = "Error while reading from the file : " + file.getAbsolutePath();
                        log.error((Object)errorMsg, (Throwable)e);
                        throw new DashboardDeploymentException(errorMsg, e);
                    }
                }
                if ("dashboards/layout".equals(artifact.getType())) {
                    try {
                        if (!file.isDirectory()) continue;
                        storePath = this.getArtifactPath("layout");
                        destination = new File(storePath + file.getName());
                        DeploymentUtil.copyFolder(file, destination);
                        log.info((Object)("Layout directory [" + file.getName() + "] has been copied to path " + destination.getAbsolutePath()));
                        continue;
                    }
                    catch (IOException e) {
                        errorMsg = "Error while reading from the file : " + file.getAbsolutePath();
                        log.error((Object)errorMsg, (Throwable)e);
                        throw new DashboardDeploymentException(errorMsg, e);
                    }
                }
                if (!"dashboards/theme".equals(artifact.getType())) continue;
                try {
                    File destination2;
                    if (!file.isDirectory()) continue;
                    String themeName = file.getName();
                    String storePath2 = this.getArtifactPath("theme");
                    File themeFolder = new File(storePath2);
                    if (!themeFolder.exists()) {
                        themeFolder.mkdir();
                    }
                    if ((destination2 = new File(storePath2 + themeName)).exists() || themeName.equalsIgnoreCase("Default Theme")) {
                        String errorMsg2 = "A theme already exists with the name " + themeName;
                        log.error((Object)errorMsg2);
                        continue;
                    }
                    DeploymentUtil.copyFolder(file, destination2);
                    log.info((Object)("Theme directory [" + file.getName() + "] has been copied to path " + destination2.getAbsolutePath()));
                }
                catch (IOException e) {
                    errorMsg = "Error while reading from the file : " + file.getAbsolutePath();
                    log.error((Object)errorMsg, (Throwable)e);
                    throw new DashboardDeploymentException(errorMsg, e);
                }
            }
        }
    }

    public void undeployArtifacts(CarbonApplication carbonApplication, AxisConfiguration axisConfiguration) throws DeploymentException {
        List deps = carbonApplication.getAppConfig().getApplicationArtifact().getDependencies();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact.Dependency dep : deps) {
            if (dep.getArtifact() == null) continue;
            artifacts.add(dep.getArtifact());
        }
        this.undeploy(artifacts);
    }

    private void undeploy(List<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            List files = artifact.getFiles();
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            File file = new File(artifactPath);
            if ("dashboards/dashboard".equals(artifact.getType())) {
                try {
                    if (!fileName.endsWith(".json")) continue;
                    String resourcePath = "/ues/dashboards/" + fileName.substring(0, fileName.lastIndexOf(".json"));
                    try {
                        DeploymentUtil.removeRegistryResource(resourcePath);
                        continue;
                    }
                    catch (RegistryException e) {
                        String errorMsg = "Error deleting registry resource " + resourcePath;
                        log.error((Object)errorMsg, (Throwable)e);
                        throw new DashboardDeploymentException(errorMsg, e);
                    }
                }
                catch (DeploymentException e) {
                    log.error((Object)("Error occurred while trying to undeploy : " + artifact.getName()));
                    continue;
                }
            }
            if ("dashboards/gadget".equals(artifact.getType())) {
                this.deleteFile(file);
                log.info((Object)("Artifact [" + file.getName() + "] has been deleted from gadgets directory."));
                continue;
            }
            if ("dashboards/layout".equals(artifact.getType())) {
                this.deleteFile(file);
                log.info((Object)("Artifact [" + file.getName() + "] has been deleted from layouts directory."));
                continue;
            }
            if (!"dashboards/theme".equals(artifact.getType())) continue;
            String storePath = this.getArtifactPath("theme");
            File storedPath = new File(storePath + file.getName());
            this.deleteFile(storedPath);
            log.info((Object)("Artifact [" + file.getName() + "] has been deleted from theme directory."));
        }
    }

    protected String getArtifactPath(String artifactName) {
        String carbonRepository = CarbonUtils.getCarbonRepository();
        StringBuilder sb = new StringBuilder(carbonRepository);
        sb.append("jaggeryapps").append(File.separator).append("portal").append(File.separator).append("store").append(File.separator).append(CarbonContext.getThreadLocalCarbonContext().getTenantDomain()).append(File.separator).append("fs").append(File.separator).append(artifactName).append(File.separator);
        return sb.toString();
    }

    private void deleteFile(File file) {
        File[] files;
        if (file.isDirectory() && file.exists() && (files = file.listFiles()) != null) {
            for (File file1 : files) {
                if (file1.isDirectory()) {
                    this.deleteFile(file1);
                    continue;
                }
                file1.delete();
            }
        }
        if (file.exists()) {
            file.delete();
        }
    }
}

