/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.subversion;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.repository.CarbonRepositoryUtils;
import org.wso2.carbon.deployment.synchronizer.subversion.DefaultSVNConflictResolver;
import org.wso2.carbon.deployment.synchronizer.subversion.SVNNotifyListener;
import org.wso2.carbon.deployment.synchronizer.subversion.TenantSVNRepositoryContext;
import org.wso2.carbon.deployment.synchronizer.subversion.util.SVNDataHolder;
import org.wso2.carbon.deployment.synchronizer.util.DeploymentSynchronizerConfiguration;
import org.wso2.carbon.deployment.synchronizer.util.RepositoryConfigParameter;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.utils.CarbonUtils;

public class SVNBasedArtifactRepository
implements ArtifactRepository {
    private static final Log log = LogFactory.getLog(SVNBasedArtifactRepository.class);
    private static final int UNVERSIONED = SVNStatusKind.UNVERSIONED.toInt();
    private static final int MISSING = SVNStatusKind.MISSING.toInt();
    private static final boolean RECURSIVE = true;
    private static final boolean NO_SET_DEPTH = false;
    private Map<Integer, TenantSVNRepositoryContext> tenantSVNRepositories = new HashMap<Integer, TenantSVNRepositoryContext>();
    private List<RepositoryConfigParameter> parameters;
    private List<String> baseDirs;

    public SVNBasedArtifactRepository() {
        this.populateParameters();
    }

    public void init(int tenantId) throws DeploymentSynchronizerException {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        DeploymentSynchronizerConfiguration conf = CarbonRepositoryUtils.getActiveSynchronizerConfiguration((int)tenantId);
        this.baseDirs = this.getBaseDirs();
        String url = null;
        boolean appendTenantId = true;
        boolean ignoreExternals = false;
        boolean forceUpdate = true;
        String user = null;
        String password = null;
        RepositoryConfigParameter[] configParameters = conf.getRepositoryConfigParameters();
        if (configParameters == null || configParameters.length == 0) {
            this.handleException("SVN configuration parameters must be specified for the SVN based deployment synchronizer");
        }
        for (RepositoryConfigParameter parameter : configParameters) {
            if ("DeploymentSynchronizer.SvnUrl".equals(parameter.getName())) {
                url = parameter.getValue();
                continue;
            }
            if ("DeploymentSynchronizer.SvnUser".equals(parameter.getName())) {
                user = parameter.getValue();
                continue;
            }
            if ("DeploymentSynchronizer.SvnPassword".equals(parameter.getName())) {
                password = parameter.getValue();
                continue;
            }
            if ("DeploymentSynchronizer.SvnUrlAppendTenantId".equals(parameter.getName())) {
                appendTenantId = Boolean.valueOf(parameter.getValue());
                continue;
            }
            if ("DeploymentSynchronizer.SvnIgnoreExternals".equals(parameter.getName())) {
                ignoreExternals = Boolean.valueOf(parameter.getValue());
                continue;
            }
            if (!"DeploymentSynchronizer.SvnForceUpdate".equals(parameter.getName())) continue;
            forceUpdate = Boolean.valueOf(parameter.getValue());
        }
        if (url == null) {
            this.handleException("SVN URL must be specified for the SVN based deployment synchronizer");
            return;
        }
        if (appendTenantId) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + tenantId;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering SVN URL: " + url + " for tenant: " + tenantId));
        }
        SVNUrl svnUrl = null;
        try {
            svnUrl = new SVNUrl(url);
        }
        catch (MalformedURLException e) {
            this.handleException("Provided SVN URL is malformed: " + url, e);
        }
        String clientType = serverConfig.getFirstProperty("DeploymentSynchronizer.SvnClient");
        if (clientType == null) {
            try {
                clientType = SVNClientAdapterFactory.getPreferredSVNClientType();
            }
            catch (SVNClientException e) {
                this.handleException("Error while retrieving the preferred SVN client type", (Exception)((Object)e));
            }
        }
        ISVNClientAdapter svnClient = SVNClientAdapterFactory.createSVNClient((String)clientType);
        if (user != null) {
            svnClient.setUsername(user);
            svnClient.setPassword(password);
        }
        SVNNotifyListener notifyListener = new SVNNotifyListener();
        svnClient.addNotifyListener((ISVNNotifyListener)notifyListener);
        svnClient.setProgressListener((ISVNProgressListener)notifyListener);
        svnClient.addConflictResolutionCallback((ISVNConflictResolver)new DefaultSVNConflictResolver());
        TenantSVNRepositoryContext tenantRepositoryContext = new TenantSVNRepositoryContext();
        tenantRepositoryContext.setSvnUrl(svnUrl);
        tenantRepositoryContext.setSvnClient(svnClient);
        tenantRepositoryContext.setConf(conf);
        tenantRepositoryContext.setIgnoreExternals(ignoreExternals);
        tenantRepositoryContext.setForceUpdate(forceUpdate);
        this.tenantSVNRepositories.put(tenantId, tenantRepositoryContext);
        this.checkRemoteDirectory(tenantId);
    }

    private void populateParameters() {
        this.parameters = new ArrayList<RepositoryConfigParameter>();
        RepositoryConfigParameter parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnUrl");
        parameter.setType("string");
        parameter.setRequired(true);
        parameter.setMaxlength(50);
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnUser");
        parameter.setType("string");
        parameter.setRequired(true);
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnPassword");
        parameter.setType("string");
        parameter.setRequired(true);
        parameter.setMasked(true);
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnIgnoreExternals");
        parameter.setType("boolean");
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnForceUpdate");
        parameter.setType("boolean");
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnUrlAppendTenantId");
        parameter.setType("boolean");
        this.parameters.add(parameter);
    }

    private void checkRemoteDirectory(int tenantId) throws DeploymentSynchronizerException {
        TenantSVNRepositoryContext repoContext = this.tenantSVNRepositories.get(tenantId);
        if (repoContext == null) {
            log.warn((Object)("TenantSVNRepositoryContext not initialized for " + tenantId));
            return;
        }
        SVNUrl svnUrl = repoContext.getSvnUrl();
        ISVNClientAdapter svnClient = repoContext.getSvnClient();
        try {
            ISVNInfo info = svnClient.getInfo(svnUrl);
            if (info != null && log.isDebugEnabled()) {
                log.debug((Object)("Remote directory: " + svnUrl + " exists"));
            }
        }
        catch (SVNClientException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while retrieving information from the directory: " + svnUrl), (Throwable)ex);
                log.debug((Object)("Attempting to create the directory: " + svnUrl));
            }
            try {
                svnClient.mkdir(svnUrl, true, "Directory creation by deployment synchronizer");
            }
            catch (SVNClientException e) {
                this.handleException("Error while attempting to create the directory: " + svnUrl, (Exception)((Object)e));
            }
        }
    }

    private void svnAddFiles(int tenantId, File root, ISVNStatus[] checkStatus) throws SVNClientException {
        TenantSVNRepositoryContext repoContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)("SVN adding files in " + root));
        }
        if ((repoContext = this.tenantSVNRepositories.get(tenantId)) == null) {
            log.warn((Object)("TenantSVNRepositoryContext not initialized for " + tenantId));
            return;
        }
        ISVNClientAdapter svnClient = repoContext.getSvnClient();
        List<String> dirListToAddSVN = this.processUnversionedWebappActions(checkStatus);
        for (ISVNStatus s : checkStatus) {
            File[] children;
            File file;
            String fileName;
            if (s.getTextStatus().toInt() != UNVERSIONED || (fileName = (file = s.getFile()).getName()).startsWith(".") || fileName.startsWith("~") || fileName.endsWith(".bk")) continue;
            String filePath = file.getPath();
            if (file.isFile()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" SVN ADD : " + filePath));
                }
                svnClient.addFile(file);
                continue;
            }
            svnClient.addDirectory(file, false);
            for (File child : children = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.getName().equals(".svn");
                }
            })) {
                ISVNStatus[] statusChild = svnClient.getStatus(child, true, false);
                this.svnAddFiles(tenantId, child, statusChild);
            }
        }
    }

    public boolean commit(int tenantId, String filePath) throws DeploymentSynchronizerException {
        TenantSVNRepositoryContext repoContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)("SVN committing " + filePath));
        }
        if ((repoContext = this.tenantSVNRepositories.get(tenantId)) == null) {
            log.warn((Object)("TenantSVNRepositoryContext not initialized for " + tenantId));
            return false;
        }
        ISVNClientAdapter svnClient = repoContext.getSvnClient();
        File root = new File(filePath);
        try {
            svnClient.cleanup(root);
            ISVNStatus[] checkStatus = svnClient.getStatus(root, true, false);
            if (checkStatus != null && checkStatus.length > 0) {
                this.svnAddFiles(tenantId, root, checkStatus);
                this.cleanupDeletedFiles(tenantId, root, checkStatus);
                ISVNStatus[] status = svnClient.getStatus(root, true, false);
                if (status != null && status.length > 0 && !this.isAllUnversioned(status)) {
                    boolean var12 = true;
                    for (ISVNStatus statu : status) {
                        if (statu.getTextStatus() == SVNStatusKind.IGNORED) continue;
                        var12 = false;
                    }
                    if (var12) {
                        return false;
                    }
                    File[] files = new File[]{root};
                    svnClient.commit(files, "Commit initiated by deployment synchronizer", true);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Updating the working copy after the commit.");
                    }
                    this.checkout(tenantId, filePath);
                    return true;
                }
                log.debug((Object)"No changes in the local working copy");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No changes in the local working copy to  commit " + filePath));
            }
        }
        catch (SVNClientException e) {
            String message = e.getMessage();
            String pattern = System.getProperty("line.separator");
            message = message.replaceAll(pattern, " ");
            boolean isOutOfDate = message.matches(".*svn: Commit failed.* is out of date");
            if (isOutOfDate) {
                log.warn((Object)("Working copy is out of date. Forcing a svn update. Tenant: " + tenantId), (Throwable)e);
                boolean updated = this.checkout(tenantId, filePath);
                if (!updated) {
                    log.error((Object)"Failed to update the working copy even though the previous commit failed due to out of date content.");
                }
            }
            this.handleException("Error while committing artifacts to the SVN repository", (Exception)((Object)e));
        }
        return false;
    }

    private boolean isAllUnversioned(ISVNStatus[] status) {
        for (ISVNStatus s : status) {
            if (s.getTextStatus().toInt() == UNVERSIONED) continue;
            return false;
        }
        return true;
    }

    public boolean checkout(int tenantId, String filePath) throws DeploymentSynchronizerException {
        TenantSVNRepositoryContext repoContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)("SVN checking out " + filePath));
        }
        if ((repoContext = this.tenantSVNRepositories.get(tenantId)) == null) {
            log.warn((Object)("TenantSVNRepositoryContext not initialized for " + tenantId));
            return false;
        }
        SVNUrl svnUrl = repoContext.getSvnUrl();
        ISVNClientAdapter svnClient = repoContext.getSvnClient();
        DeploymentSynchronizerConfiguration conf = repoContext.getConf();
        boolean ignoreExternals = repoContext.isIgnoreExternals();
        boolean forceUpdate = repoContext.isForceUpdate();
        File root = new File(filePath);
        try {
            ISVNStatus singleStatus = svnClient.getSingleStatus(root);
            if (singleStatus != null && singleStatus.getTextStatus().toInt() != UNVERSIONED) {
                svnClient.cleanup(root);
            }
            ISVNStatus[] svnStatus = svnClient.getStatus(root, true, false);
            if (conf.isAutoCommit() && svnStatus != null) {
                this.cleanupDeletedFiles(tenantId, root, svnStatus);
            }
            if (CarbonUtils.isWorkerNode()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("reverting " + root));
                }
                if (singleStatus != null && singleStatus.getTextStatus().toInt() != UNVERSIONED) {
                    svnClient.revert(root, true);
                }
            }
            if (singleStatus != null && singleStatus.getTextStatus().toInt() == UNVERSIONED) {
                this.cleanupUnversionedFiles(tenantId, svnUrl, root);
                if (svnClient instanceof CmdLineClientAdapter) {
                    svnClient.checkout(svnUrl, root, SVNRevision.HEAD, true);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Checked out using CmdLineClientAdapter");
                    }
                } else {
                    svnClient.checkout(svnUrl, root, SVNRevision.HEAD, 5, ignoreExternals, true);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Checked out using SVN Kit");
                    }
                }
                return true;
            }
            long lastRevisionNumber = -1L;
            long newRevisionNumber = -1L;
            int tries = 0;
            while (true) {
                try {
                    ++tries;
                    lastRevisionNumber = svnClient.getSingleStatus(root).getLastChangedRevision().getNumber();
                    if (svnClient instanceof CmdLineClientAdapter) {
                        newRevisionNumber = svnClient.update(root, SVNRevision.HEAD, true);
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)(" files were updated to revision number: " + newRevisionNumber + " using CmdLineClientAdapter"));
                        break;
                    }
                    newRevisionNumber = svnClient.update(root, SVNRevision.HEAD, 5, false, ignoreExternals, forceUpdate);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("files were updated to revision number: " + newRevisionNumber + " using SVN Kit"));
                }
                catch (SVNClientException e) {
                    if (tries < 10 && (e.getMessage().contains("an unversioned file of the same name already exists") || e.getMessage().contains("an unversioned directory of the same name already exists"))) {
                        log.info((Object)("Unversioned file problem. Retrying " + tries));
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } else {
                        throw e;
                    }
                    this.cleanupUnversionedFiles(tenantId, svnUrl, root);
                    if (tries < 10) continue;
                }
                break;
            }
            return newRevisionNumber > lastRevisionNumber;
        }
        catch (SVNClientException e) {
            this.handleException("Error while checking out or updating artifacts from the SVN repository", (Exception)((Object)e));
            return false;
        }
    }

    private void cleanupUnversionedFiles(int tenantId, SVNUrl svnURL, File root) throws SVNClientException {
        ISVNDirEntry[] entries;
        TenantSVNRepositoryContext repoContext = this.tenantSVNRepositories.get(tenantId);
        if (repoContext == null) {
            log.warn((Object)("TenantSVNRepositoryContext not initialized for " + tenantId));
            return;
        }
        ISVNClientAdapter svnClient = repoContext.getSvnClient();
        DeploymentSynchronizerConfiguration conf = repoContext.getConf();
        for (ISVNDirEntry entry : entries = svnClient.getList(svnURL, SVNRevision.HEAD, false)) {
            String fileName = entry.getPath();
            SVNNodeKind nodeType = entry.getNodeKind();
            File localFile = new File(root, fileName);
            if (!localFile.exists()) continue;
            ISVNStatus status = svnClient.getSingleStatus(localFile);
            if (status != null && status.getTextStatus().toInt() != UNVERSIONED) {
                if (localFile.isDirectory()) {
                    String appendPath = "/" + localFile.getName();
                    this.cleanupUnversionedFiles(tenantId, svnURL.appendPath(appendPath), localFile);
                    continue;
                }
                if (localFile.isFile()) continue;
            }
            if (localFile.isFile() && SVNNodeKind.FILE.equals((Object)nodeType)) {
                log.info((Object)("Unversioned file: " + localFile.getPath() + " will be deleted"));
                if (localFile.delete()) continue;
                log.error((Object)("Unable to delete the file: " + localFile.getPath()));
                continue;
            }
            if (!localFile.isDirectory() || !SVNNodeKind.DIR.equals((Object)nodeType)) continue;
            log.info((Object)("Unversioned directory: " + localFile.getPath() + " will be deleted"));
            try {
                FileUtils.deleteDirectory((File)localFile);
            }
            catch (IOException e) {
                log.error((Object)("Error while deleting the directory: " + localFile.getPath()), (Throwable)e);
            }
        }
    }

    private void cleanupDeletedFiles(int tenantId, File root, ISVNStatus[] status) throws SVNClientException {
        TenantSVNRepositoryContext repoContext = this.tenantSVNRepositories.get(tenantId);
        if (repoContext == null) {
            log.warn((Object)("TenantSVNRepositoryContext not initialized for " + tenantId));
            return;
        }
        ISVNClientAdapter svnClient = repoContext.getSvnClient();
        ArrayList<File> deletableFiles = new ArrayList<File>();
        for (ISVNStatus s : status) {
            int statusCode = s.getTextStatus().toInt();
            if (statusCode != MISSING) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scheduling the file: " + s.getPath() + " for SVN delete"));
            }
            deletableFiles.add(s.getFile());
        }
        if (deletableFiles.size() > 0) {
            svnClient.remove(deletableFiles.toArray(new File[deletableFiles.size()]), true);
        }
    }

    public void initAutoCheckout(boolean useEventing) throws DeploymentSynchronizerException {
    }

    public void cleanupAutoCheckout() {
    }

    public String getRepositoryType() {
        return "svn";
    }

    public List<RepositoryConfigParameter> getParameters() {
        return this.parameters;
    }

    @Deprecated
    public boolean checkout(int tenantId, String filePath, int depth) throws DeploymentSynchronizerException {
        log.info((Object)("SVN checking out " + filePath));
        TenantSVNRepositoryContext repoContext = this.tenantSVNRepositories.get(tenantId);
        if (repoContext == null) {
            log.warn((Object)("TenantSVNRepositoryContext not initialized for " + tenantId));
            return false;
        }
        SVNUrl svnUrl = repoContext.getSvnUrl();
        ISVNClientAdapter svnClient = repoContext.getSvnClient();
        DeploymentSynchronizerConfiguration conf = repoContext.getConf();
        boolean ignoreExternals = repoContext.isIgnoreExternals();
        boolean forceUpdate = repoContext.isForceUpdate();
        File root = new File(filePath);
        try {
            ISVNStatus status;
            ISVNStatus[] svnStatus = svnClient.getStatus(root, true, false);
            if (conf.isAutoCommit() && svnStatus != null) {
                this.cleanupDeletedFiles(tenantId, root, svnStatus);
            }
            if ((status = svnClient.getSingleStatus(root)) != null && status.getTextStatus().toInt() == UNVERSIONED) {
                this.cleanupUnversionedFiles(tenantId, svnUrl, root);
                if (svnClient instanceof CmdLineClientAdapter) {
                    svnClient.checkout(svnUrl, root, SVNRevision.HEAD, true);
                    log.info((Object)"Checked out using CmdLineClientAdapter");
                } else {
                    svnClient.checkout(svnUrl, root, SVNRevision.HEAD, depth, ignoreExternals, forceUpdate);
                    log.info((Object)"Checked out using SVN Kit");
                }
                return true;
            }
            long lastRevisionNumber = -1L;
            long newRevisionNumber = -1L;
            svnClient.cleanup(root);
            int tries = 0;
            while (true) {
                try {
                    ++tries;
                    lastRevisionNumber = svnClient.getSingleStatus(root).getLastChangedRevision().getNumber();
                    if (svnClient instanceof CmdLineClientAdapter) {
                        newRevisionNumber = svnClient.update(root, SVNRevision.HEAD, true);
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)("files were updated to revision number: " + newRevisionNumber + " using CmdLineClientAdapter"));
                        break;
                    }
                    newRevisionNumber = svnClient.update(root, SVNRevision.HEAD, depth, false, ignoreExternals, forceUpdate);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("files were updated to revision number: " + newRevisionNumber + " using SVN Kit"));
                }
                catch (SVNClientException e) {
                    if (tries < 10 && (e.getMessage().contains("an unversioned file of the same name already exists") || e.getMessage().contains("an unversioned directory of the same name already exists"))) {
                        log.info((Object)("Unversioned file problem. Retrying " + tries));
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } else {
                        throw e;
                    }
                    this.cleanupUnversionedFiles(tenantId, svnUrl, root);
                    if (tries < 10) continue;
                }
                break;
            }
            return newRevisionNumber > lastRevisionNumber;
        }
        catch (SVNClientException e) {
            this.handleException("Error while checking out or updating artifacts from the SVN repository", (Exception)((Object)e));
            return false;
        }
    }

    @Deprecated
    public boolean update(int tenantId, String rootPath, String filePathToUpdate, int depth) throws DeploymentSynchronizerException {
        throw new UnsupportedOperationException();
    }

    public void cleanupTenantContext(int tenantId) {
        this.tenantSVNRepositories.remove(tenantId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SVNBasedArtifactRepository that = (SVNBasedArtifactRepository)o;
        return this.getRepositoryType().equals(that.getRepositoryType());
    }

    public int hashCode() {
        return this.getRepositoryType().hashCode();
    }

    private void handleException(String msg) throws DeploymentSynchronizerException {
        log.error((Object)msg);
        throw new DeploymentSynchronizerException(msg);
    }

    private void handleException(String msg, Exception e) throws DeploymentSynchronizerException {
        log.error((Object)msg, (Throwable)e);
        throw new DeploymentSynchronizerException(msg, (Throwable)e);
    }

    public List<String> processUnversionedWebappActions(ISVNStatus[] status) {
        ArrayList<String> addToSvn = new ArrayList<String>();
        for (ISVNStatus st : status) {
            File appBase;
            String simpleName;
            String path = st.getPath();
            if (path == null || !this.isWebApp(path)) continue;
            int lastIdx = path.lastIndexOf(File.separator);
            String string = simpleName = lastIdx > 0 ? path.substring(lastIdx + 1) : null;
            if (simpleName == null || simpleName.endsWith(".war") || (appBase = new File(path.concat(".war"))).exists()) continue;
            addToSvn.add(simpleName);
        }
        return addToSvn;
    }

    private String getSimpleFileName(String filePath) {
        int lastIdx = filePath.lastIndexOf(File.separator);
        return lastIdx > 0 ? filePath.substring(lastIdx + 1) : null;
    }

    private boolean isWARWebApp(String filePath) {
        return this.isWebApp(filePath) && filePath.endsWith(".war");
    }

    private boolean isWebApp(String filePath) {
        if (filePath.contains(File.separator + "repository" + File.separator)) {
            for (String dir : this.baseDirs) {
                if (!filePath.contains(File.separator + dir + File.separator)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getBaseDirs() {
        CarbonTomcatService service = SVNDataHolder.getInstance().getCarbonTomcatService();
        ArrayList<String> baseDirs = new ArrayList<String>();
        if (service != null) {
            Container[] virtualHosts;
            Tomcat tomcat = service.getTomcat();
            for (Container container : virtualHosts = tomcat.getEngine().findChildren()) {
                Host host = (Host)container;
                String baseDir = this.getBaseDirectoryName(host.getAppBase());
                baseDirs.add(baseDir);
            }
        }
        return baseDirs;
    }

    private String getBaseDirectoryName(String appBase) {
        String baseDir = (appBase = appBase.replace("/", File.separator)).endsWith(File.separator) ? appBase.substring(0, appBase.lastIndexOf(File.separator)) : appBase;
        return baseDir.substring(baseDir.lastIndexOf(File.separator) + 1, baseDir.length());
    }

    private String getWebAppsDirPath(String path) {
        int start = path.indexOf("repository");
        int end = path.lastIndexOf(File.separator);
        return path.substring(start, end);
    }
}

