/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.parser.core.appcreator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.siddhi.parser.core.appcreator.AbstractSiddhiAppCreator;
import org.wso2.siddhi.parser.core.appcreator.SiddhiQuery;
import org.wso2.siddhi.parser.core.topology.InputStreamDataHolder;
import org.wso2.siddhi.parser.core.topology.OutputStreamDataHolder;
import org.wso2.siddhi.parser.core.topology.PublishingStrategyDataHolder;
import org.wso2.siddhi.parser.core.topology.SiddhiQueryGroup;
import org.wso2.siddhi.parser.core.topology.SubscriptionStrategyDataHolder;
import org.wso2.siddhi.parser.core.util.TransportStrategy;
import org.wso2.siddhi.parser.service.model.MessagingSystem;

public class NatsSiddhiAppCreator
extends AbstractSiddhiAppCreator {
    private static final Logger log = LoggerFactory.getLogger(NatsSiddhiAppCreator.class);
    public static final String APP_NAME = "appName";
    public static final String TOPIC_LIST = "topicList";
    public static final String CONSUMER_GROUP_ID = "groupID";
    public static final String BOOTSTRAP_SERVER_URL = "bootstrapServerURL";
    public static final String PARTITION_LIST = "partitionList";
    public static final String PARTITION_KEY = "partitionKey";
    public static final String DESTINATIONS = "destinations";
    public static final String PARTITION_NO = "partitionNo";
    public static final String MAPPING = "text";
    public static final String PARTITION_TOPIC = "partitionTopic";
    public static final String DESTINATION_TOPIC = "@destination(destination = '${partitionTopic}')";
    public static final String CLUSTER_ID = "clusterid";
    public static final String NATS_SERVER_URL = "natsserverurl";
    public static final String PARTITIONED_NATS_SINK_TEMPLATE = "@sink(type='nats',cluster.id='${clusterid}',@distribution(strategy='partitioned', partitionKey='${partitionKey}',${destinations}), bootstrap.servers='${natsserverurl}',@map(type='text'))";
    public static final String DEFAULT_NATS_SINK_TEMPLATE = "@sink(type='nats',cluster.id='${clusterid}',destination = '${topicList}', bootstrap.servers='${natsserverurl}',@map(type='text'))";
    public static final String DEFAULT_NATS_SOURCE_TEMPLATE = "@source(type='nats',cluster.id='${clusterid}',destination = '${topicList}', bootstrap.servers='${natsserverurl}',@map(type='text'))";
    public static final String QUEUE_GROUP_NAME = "queueGroupName";
    public static final String RR_NATS_SOURCE_TEMPLATE = "@source(type='nats',cluster.id='${clusterid}',queue.group.name='${queueGroupName}',destination = '${topicList}', bootstrap.servers='${natsserverurl}',@map(type='text'))";
    private String clusterId = "";
    private String natsServerUrl = "";

    @Override
    protected List<SiddhiQuery> createApps(String siddhiAppName, SiddhiQueryGroup queryGroup, MessagingSystem messagingSystem) {
        String groupName = queryGroup.getName();
        String queryTemplate = queryGroup.getSiddhiApp();
        List<SiddhiQuery> queryList = this.generateQueryList(queryTemplate, groupName, queryGroup.getParallelism());
        if (messagingSystem != null && messagingSystem.getConfig() != null) {
            this.natsServerUrl = messagingSystem.getConfig().getBootstrapServerURLs();
            this.clusterId = messagingSystem.getConfig().getClusterId();
        }
        this.processInputStreams(siddhiAppName, groupName, queryList, queryGroup.getInputStreams().values());
        this.processOutputStreams(siddhiAppName, queryList, queryGroup.getOutputStreams().values());
        if (log.isDebugEnabled()) {
            log.debug("Following parse list is created for the Siddhi Query Group " + queryGroup.getName() + " representing Siddhi App " + siddhiAppName + ".");
            for (SiddhiQuery siddhiQuery : queryList) {
                log.debug(siddhiQuery.getApp());
            }
        }
        return queryList;
    }

    private void processOutputStreams(String siddhiAppName, List<SiddhiQuery> queryList, Collection<OutputStreamDataHolder> outputStreams) {
        HashMap<String, String> sinkValuesMap = new HashMap<String, String>();
        sinkValuesMap.put(CLUSTER_ID, this.clusterId);
        sinkValuesMap.put(NATS_SERVER_URL, this.natsServerUrl);
        for (OutputStreamDataHolder outputStream : outputStreams) {
            HashMap<String, String> sinkList = new HashMap<String, String>();
            HashMap<String, Integer> partitionKeys = new HashMap<String, Integer>();
            for (PublishingStrategyDataHolder holder : outputStream.getPublishingStrategyList()) {
                sinkValuesMap.put(TOPIC_LIST, siddhiAppName + "_" + outputStream.getStreamName() + (holder.getGroupingField() == null ? "" : "_" + holder.getGroupingField()));
                if (holder.getStrategy() == TransportStrategy.FIELD_GROUPING) {
                    if (partitionKeys.get(holder.getGroupingField()) != null && (Integer)partitionKeys.get(holder.getGroupingField()) > holder.getParallelism()) continue;
                    partitionKeys.put(holder.getGroupingField(), holder.getParallelism());
                    sinkValuesMap.put(PARTITION_KEY, holder.getGroupingField());
                    ArrayList<String> destinations = new ArrayList<String>(holder.getParallelism());
                    for (int i = 0; i < holder.getParallelism(); ++i) {
                        HashMap<String, String> destinationMap = new HashMap<String, String>(holder.getParallelism());
                        destinationMap.put(PARTITION_TOPIC, (String)sinkValuesMap.get(TOPIC_LIST) + "_" + String.valueOf(i));
                        destinations.add(this.getUpdatedQuery(DESTINATION_TOPIC, destinationMap));
                    }
                    sinkValuesMap.put(DESTINATIONS, StringUtils.join(destinations, (String)","));
                    String sinkString = this.getUpdatedQuery(PARTITIONED_NATS_SINK_TEMPLATE, sinkValuesMap);
                    sinkList.put((String)sinkValuesMap.get(TOPIC_LIST), sinkString);
                    continue;
                }
                String sinkString = this.getUpdatedQuery(DEFAULT_NATS_SINK_TEMPLATE, sinkValuesMap);
                sinkList.put((String)sinkValuesMap.get(TOPIC_LIST), sinkString);
            }
            HashMap<String, String> queryValuesMap = new HashMap<String, String>(1);
            queryValuesMap.put(outputStream.getStreamName(), StringUtils.join(sinkList.values(), (String)"\n"));
            this.updateQueryList(queryList, queryValuesMap);
        }
    }

    private void processInputStreams(String siddhiAppName, String groupName, List<SiddhiQuery> queryList, Collection<InputStreamDataHolder> inputStreams) {
        HashMap<String, String> sourceValuesMap = new HashMap<String, String>();
        for (InputStreamDataHolder inputStream : inputStreams) {
            SubscriptionStrategyDataHolder subscriptionStrategy = inputStream.getSubscriptionStrategy();
            sourceValuesMap.put(CLUSTER_ID, this.clusterId);
            sourceValuesMap.put(NATS_SERVER_URL, this.natsServerUrl);
            if (inputStream.isUserGiven()) continue;
            if (subscriptionStrategy.getStrategy() == TransportStrategy.FIELD_GROUPING) {
                sourceValuesMap.put(TOPIC_LIST, this.getTopicName(siddhiAppName, inputStream.getStreamName(), inputStream.getSubscriptionStrategy().getPartitionKey()));
                for (int i = 0; i < queryList.size(); ++i) {
                    ArrayList<String> sourceQueries = new ArrayList<String>();
                    List<Integer> partitionNumbers = this.getPartitionNumbers(queryList.size(), subscriptionStrategy.getOfferedParallelism(), i);
                    for (int topicCount : partitionNumbers) {
                        String topicName = this.getTopicName(siddhiAppName, inputStream.getStreamName(), inputStream.getSubscriptionStrategy().getPartitionKey()) + "_" + Integer.toString(topicCount);
                        sourceValuesMap.put(TOPIC_LIST, topicName);
                        String sourceQuery = this.getUpdatedQuery(DEFAULT_NATS_SOURCE_TEMPLATE, sourceValuesMap);
                        sourceQueries.add(sourceQuery);
                    }
                    String combinedQueryHeader = StringUtils.join(sourceQueries, (String)System.lineSeparator());
                    HashMap<String, String> queryValuesMap = new HashMap<String, String>(1);
                    queryValuesMap.put(inputStream.getStreamName(), combinedQueryHeader);
                    String updatedQuery = this.getUpdatedQuery(queryList.get(i).getApp(), queryValuesMap);
                    queryList.get(i).setApp(updatedQuery);
                }
                continue;
            }
            if (subscriptionStrategy.getStrategy() == TransportStrategy.ROUND_ROBIN) {
                sourceValuesMap.put(TOPIC_LIST, this.getTopicName(siddhiAppName, inputStream.getStreamName(), null));
                sourceValuesMap.put(QUEUE_GROUP_NAME, groupName);
                String sourceString = this.getUpdatedQuery(RR_NATS_SOURCE_TEMPLATE, sourceValuesMap);
                HashMap<String, String> queryValuesMap = new HashMap<String, String>(1);
                queryValuesMap.put(inputStream.getStreamName(), sourceString);
                this.updateQueryList(queryList, queryValuesMap);
                continue;
            }
            if (subscriptionStrategy.getStrategy() != TransportStrategy.ALL) continue;
            sourceValuesMap.put(TOPIC_LIST, this.getTopicName(siddhiAppName, inputStream.getStreamName(), null));
            for (SiddhiQuery aQueryList : queryList) {
                String sourceString = this.getUpdatedQuery(DEFAULT_NATS_SOURCE_TEMPLATE, sourceValuesMap);
                HashMap<String, String> queryValuesMap = new HashMap<String, String>(1);
                queryValuesMap.put(inputStream.getStreamName(), sourceString);
                String updatedQuery = this.getUpdatedQuery(aQueryList.getApp(), queryValuesMap);
                aQueryList.setApp(updatedQuery);
            }
        }
    }
}

