/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.parser.core.appcreator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.wso2.siddhi.parser.core.SiddhiAppCreator;
import org.wso2.siddhi.parser.core.appcreator.DeployableSiddhiQueryGroup;
import org.wso2.siddhi.parser.core.appcreator.SiddhiQuery;
import org.wso2.siddhi.parser.core.topology.SiddhiQueryGroup;
import org.wso2.siddhi.parser.core.topology.SiddhiTopology;
import org.wso2.siddhi.parser.service.model.MessagingSystem;

public abstract class AbstractSiddhiAppCreator
implements SiddhiAppCreator {
    @Override
    public List<DeployableSiddhiQueryGroup> createApps(SiddhiTopology topology, MessagingSystem messagingSystem) {
        ArrayList<DeployableSiddhiQueryGroup> deployableSiddhiQueryGroupList = new ArrayList<DeployableSiddhiQueryGroup>(topology.getQueryGroupList().size());
        for (SiddhiQueryGroup queryGroup : topology.getQueryGroupList()) {
            DeployableSiddhiQueryGroup deployableQueryGroup = new DeployableSiddhiQueryGroup(queryGroup.getName(), queryGroup.isReceiverQueryGroup(), queryGroup.getParallelism());
            deployableQueryGroup.setSiddhiQueries(this.createApps(topology.getName(), queryGroup, messagingSystem));
            deployableSiddhiQueryGroupList.add(deployableQueryGroup);
        }
        return deployableSiddhiQueryGroupList;
    }

    protected abstract List<SiddhiQuery> createApps(String var1, SiddhiQueryGroup var2, MessagingSystem var3);

    protected List<Integer> getPartitionNumbers(int appParallelism, int availablePartitionCount, int currentAppNum) {
        ArrayList<Integer> partitionNumbers = new ArrayList<Integer>();
        if (availablePartitionCount == appParallelism) {
            partitionNumbers.add(currentAppNum);
            return partitionNumbers;
        }
        int partitionsPerNode = availablePartitionCount / appParallelism;
        if (currentAppNum + 1 == appParallelism) {
            int remainingPartitions = availablePartitionCount - (appParallelism - 1) * partitionsPerNode;
            for (int j = 0; j < remainingPartitions; ++j) {
                partitionNumbers.add(currentAppNum * partitionsPerNode + j);
            }
            return partitionNumbers;
        }
        for (int j = 0; j < partitionsPerNode; ++j) {
            partitionNumbers.add(currentAppNum * partitionsPerNode + j);
        }
        return partitionNumbers;
    }

    protected List<SiddhiQuery> generateQueryList(String queryTemplate, String queryGroupName, int parallelism) {
        ArrayList<SiddhiQuery> queries = new ArrayList<SiddhiQuery>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            HashMap<String, String> valuesMap = new HashMap<String, String>(1);
            String appName = queryGroupName + "-" + (i + 1);
            valuesMap.put("appName", appName);
            StrSubstitutor substitutor = new StrSubstitutor(valuesMap);
            queries.add(new SiddhiQuery(appName, substitutor.replace(queryTemplate), false));
        }
        return queries;
    }

    protected void updateQueryList(List<SiddhiQuery> queryList, Map<String, String> valuesMap) {
        StrSubstitutor substitutor = new StrSubstitutor(valuesMap);
        for (SiddhiQuery query : queryList) {
            String updatedQuery = substitutor.replace(query.getApp());
            query.setApp(updatedQuery);
        }
    }

    protected String getUpdatedQuery(String query, Map<String, String> valuesMap) {
        StrSubstitutor substitutor = new StrSubstitutor(valuesMap);
        return substitutor.replace(query);
    }

    protected String getTopicName(String siddhiAppName, String streamName, String groupingField) {
        return siddhiAppName + "_" + streamName + (groupingField == null ? "" : "_" + groupingField);
    }
}

