/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.internal;

import com.google.gson.JsonElement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.msf4j.interceptor.common.AnalyticsResponseInterceptor;
import org.wso2.carbon.analytics.msf4j.interceptor.common.AuthenticationInterceptor;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.exception.DataProviderException;
import org.wso2.carbon.data.provider.utils.DataProviderValueHolder;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.interceptor.annotation.RequestInterceptor;
import org.wso2.msf4j.interceptor.annotation.ResponseInterceptor;

@RequestInterceptor(value={AuthenticationInterceptor.class})
@ResponseInterceptor(value={AnalyticsResponseInterceptor.class})
public class DataProviderAPI
implements Microservice {
    public static final String API_CONTEXT_PATH = "/apis/data-provider";
    private static final Logger log = LoggerFactory.getLogger(DataProviderAPI.class);

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Response dataProviderList() {
        try {
            return Response.ok().entity(DataProviderValueHolder.getDataProviderHelper().getDataProviderNameSet()).type("application/json").build();
        }
        catch (Exception e) {
            log.error("Cannot list data providers.", (Throwable)e);
            return Response.serverError().entity((Object)"Server error occurred when listing data providers.").build();
        }
    }

    @GET
    @Path(value="/{providerName}/config")
    @Produces(value={"application/json"})
    public Response dataProviderConfig(@PathParam(value="providerName") String providerName) {
        try {
            return Response.ok().entity((Object)DataProviderValueHolder.getDataProviderHelper().getDataProvider(providerName).providerConfig()).type("application/json").build();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cannot retrieve configuration of data provider '{}'.", (Object)this.replaceCRLFCharacters(providerName), (Object)e);
            return Response.serverError().entity((Object)("Server error occurred when when retrieving configuration of data provider '" + providerName + "'. ")).build();
        }
    }

    @POST
    @Path(value="/{providerName}/validate")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response validateProviderConfig(JsonElement dataProviderConfig, @PathParam(value="providerName") String providerName) {
        try {
            DataProvider dataProvider = DataProviderValueHolder.getDataProviderHelper().getDataProvider(providerName);
            dataProvider.init("mock_topic", "mock_session", dataProviderConfig);
            return Response.ok().entity((Object)dataProvider.dataSetMetadata()).type("application/json").build();
        }
        catch (IllegalAccessException | InstantiationException | DataProviderException e) {
            log.error("Cannot validate configurations '{}' for data provider '{}'.", new Object[]{dataProviderConfig, this.replaceCRLFCharacters(providerName), e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private String replaceCRLFCharacters(String str) {
        if (str != null) {
            str = str.replace('\n', '_').replace('\r', '_');
        }
        return str;
    }
}

