/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.bean.DataSetMetadata;
import org.wso2.carbon.data.provider.rdbms.AbstractRDBMSDataProvider;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

@Component(service={DataProvider.class}, immediate=true)
public class RDBMSStreamingDataProvider
extends AbstractRDBMSDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDBMSStreamingDataProvider.class);
    private double lastRecordValue = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String topic, String sessionId) {
        block19: {
            String customQuery = this.getRecordLimitQuery();
            DataSetMetadata metadata = this.getMetadata();
            int columnCount = this.getColumnCount();
            if (customQuery != null) {
                try {
                    ResultSet resultSet;
                    PreparedStatement statement;
                    Connection connection;
                    block18: {
                        connection = RDBMSStreamingDataProvider.getConnection(this.getRdbmsProviderConfig().getDatasourceName());
                        statement = null;
                        resultSet = null;
                        try {
                            if (this.lastRecordValue > 0.0) {
                                String greaterThanWhereQuery = this.getGreaterThanWhereSQLQuery().replace("{{LAST_RECORD_VALUE}}", Double.toString(this.lastRecordValue));
                                statement = connection.prepareStatement(greaterThanWhereQuery);
                            } else {
                                statement = connection.prepareStatement(customQuery);
                            }
                            resultSet = statement.executeQuery();
                            ArrayList<Object[]> data = new ArrayList<Object[]>();
                            while (resultSet.next()) {
                                Object[] rowData = new Object[columnCount];
                                for (int i = 0; i < columnCount; ++i) {
                                    double value;
                                    if (metadata.getTypes()[i].equals((Object)DataSetMetadata.Types.LINEAR)) {
                                        rowData[i] = resultSet.getDouble(i + 1);
                                    } else if (metadata.getTypes()[i].equals((Object)DataSetMetadata.Types.ORDINAL)) {
                                        rowData[i] = resultSet.getString(i + 1);
                                    } else if (metadata.getTypes()[i].equals((Object)DataSetMetadata.Types.TIME)) {
                                        rowData[i] = resultSet.getTimestamp(i + 1);
                                    } else {
                                        if (LOGGER.isDebugEnabled()) {
                                            LOGGER.debug("Meta Data type not defined, added value of the given column as a java object.");
                                        }
                                        rowData[i] = resultSet.getObject(i + 1);
                                    }
                                    if (!metadata.getNames()[i].equalsIgnoreCase(this.getRdbmsProviderConfig().getIncrementalColumn()) || metadata.getTypes()[i].equals((Object)DataSetMetadata.Types.TIME) || !(this.lastRecordValue < (value = rowData[i] instanceof Integer ? (double)((Integer)rowData[i]).intValue() : (Double)rowData[i]))) continue;
                                    this.lastRecordValue = value;
                                }
                                data.add(rowData);
                            }
                            if (data.isEmpty() && this.lastRecordValue != 0.0) break block18;
                            this.publishToEndPoint(data, sessionId, topic);
                        }
                        catch (SQLException e) {
                            try {
                                LOGGER.error("SQL exception occurred " + e.getMessage(), (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                RDBMSStreamingDataProvider.cleanupConnection(resultSet, statement, connection);
                                throw throwable;
                            }
                            RDBMSStreamingDataProvider.cleanupConnection(resultSet, statement, connection);
                            break block19;
                        }
                    }
                    RDBMSStreamingDataProvider.cleanupConnection(resultSet, statement, connection);
                }
                catch (SQLException | DataSourceException e) {
                    LOGGER.error("Failed to create a connection to the database " + e.getMessage(), e);
                }
            }
        }
    }
}

