/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.bean.DataSetMetadata;
import org.wso2.carbon.data.provider.rdbms.AbstractRDBMSDataProvider;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

@Component(service={DataProvider.class}, immediate=true)
public class RDBMSBatchDataProvider
extends AbstractRDBMSDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDBMSBatchDataProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String topic, String sessionId) {
        block13: {
            String customQuery = this.getRecordLimitQuery();
            DataSetMetadata metadata = this.getMetadata();
            int columnCount = this.getColumnCount();
            if (customQuery != null) {
                try {
                    Connection connection = RDBMSBatchDataProvider.getConnection(this.getRdbmsProviderConfig().getDatasourceName());
                    PreparedStatement statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = connection.prepareStatement(customQuery);
                        resultSet = statement.executeQuery();
                        ArrayList<Object[]> data = new ArrayList<Object[]>();
                        while (resultSet.next()) {
                            Object[] rowData = new Object[columnCount];
                            for (int i = 0; i < columnCount; ++i) {
                                if (metadata.getTypes()[i].equals((Object)DataSetMetadata.Types.LINEAR)) {
                                    rowData[i] = resultSet.getDouble(i + 1);
                                    continue;
                                }
                                if (metadata.getTypes()[i].equals((Object)DataSetMetadata.Types.ORDINAL)) {
                                    rowData[i] = resultSet.getString(i + 1);
                                    continue;
                                }
                                if (metadata.getTypes()[i].equals((Object)DataSetMetadata.Types.TIME)) {
                                    rowData[i] = resultSet.getDouble(i + 1);
                                    continue;
                                }
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Meta Data type not defined, added value of the given column as a java object.");
                                }
                                rowData[i] = resultSet.getObject(i + 1);
                            }
                            data.add(rowData);
                        }
                        this.publishToEndPoint(data, sessionId, topic);
                    }
                    catch (SQLException e) {
                        try {
                            LOGGER.error("SQL exception occurred " + e.getMessage(), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            RDBMSBatchDataProvider.cleanupConnection(resultSet, statement, connection);
                            throw throwable;
                        }
                        RDBMSBatchDataProvider.cleanupConnection(resultSet, statement, connection);
                        break block13;
                    }
                    RDBMSBatchDataProvider.cleanupConnection(resultSet, statement, connection);
                }
                catch (SQLException | DataSourceException e) {
                    LOGGER.error("Failed to create a connection to the database " + e.getMessage(), e);
                }
            }
        }
    }
}

