/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.data.provider.internal;

import java.util.Collections;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.data.provider.DataProvider;
import org.wso2.carbon.data.provider.internal.DataProviderAPI;
import org.wso2.carbon.data.provider.utils.DataProviderValueHolder;
import org.wso2.carbon.uiserver.api.App;
import org.wso2.carbon.uiserver.spi.RestApiProvider;
import org.wso2.msf4j.Microservice;

@Component(service={RestApiProvider.class}, immediate=true)
public class DashboardRestApiProvider
implements RestApiProvider {
    public static final String DASHBOARD_PORTAL_APP_NAME = "analytics-dashboard";
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardRestApiProvider.class);

    @Activate
    protected void activate(BundleContext bundleContext) {
        LOGGER.debug("{} activated.", (Object)this.getClass().getName());
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        LOGGER.debug("{} deactivated.", (Object)this.getClass().getName());
    }

    @Reference(service=DataProvider.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetDataProvider")
    protected void setDataProvider(DataProvider dataProvider) {
        DataProviderValueHolder.getDataProviderHelper().setDataProvider(dataProvider.providerName(), dataProvider);
    }

    protected void unsetDataProvider(DataProvider dataProvider) {
        DataProviderValueHolder.getDataProviderHelper().removeDataProviderClass(dataProvider.providerName());
    }

    public String getAppName() {
        return DASHBOARD_PORTAL_APP_NAME;
    }

    public Map<String, Microservice> getMicroservices(App app) {
        return Collections.singletonMap("/apis/data-provider", new DataProviderAPI());
    }
}

