/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.auth.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.analytics.auth.rest.api.LoginApiService;
import org.wso2.carbon.analytics.auth.rest.api.NotFoundException;
import org.wso2.carbon.analytics.auth.rest.api.dto.UserDTO;
import org.wso2.carbon.analytics.auth.rest.api.factories.LoginApiServiceFactory;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.formparam.FormDataParam;

@Path(value="/login")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationPath(value="/login")
@Api(description="the login API")
@Component(name="LoginApi", service={Microservice.class}, immediate=true)
public class LoginApi
implements Microservice {
    private final LoginApiService delegate = LoginApiServiceFactory.getLoginApi();

    @POST
    @Path(value="/{appName:(.*)}")
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Login Request to Streaming Integrator.", response=UserDTO.class, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Authorization Request Successful.", response=UserDTO.class), @ApiResponse(code=302, message="Redirection for OAuth2 authorization grant type.", response=UserDTO.class), @ApiResponse(code=401, message="Invalid Authorization Header", response=UserDTO.class), @ApiResponse(code=500, message="An unexpected error occurred.", response=UserDTO.class)})
    public Response loginAppNamePost(@ApiParam(value="AppName", required=true) @PathParam(value="appName") String appName, @ApiParam(value="") @FormDataParam(value="username") String username, @ApiParam(value="") @FormDataParam(value="password") String password, @ApiParam(value="") @FormDataParam(value="grantType") String grantType, @ApiParam(value="", defaultValue="false") @FormDataParam(value="rememberMe") Boolean rememberMe, @ApiParam(value="") @FormDataParam(value="appId") String appId, @Context Request request) throws NotFoundException {
        return this.delegate.loginAppNamePost(appName, username, password, grantType, rememberMe, appId, request);
    }

    @GET
    @Path(value="/callback/{appName:(.*)}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Login Request callback for Authorization Code grant type.", response=UserDTO.class, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Authorization Request Successful.", response=UserDTO.class), @ApiResponse(code=401, message="Invalid Authorization Header", response=UserDTO.class), @ApiResponse(code=500, message="An unexpected error occurred.", response=UserDTO.class)})
    public Response loginCallbackAppNameGet(@ApiParam(value="AppName", required=true) @PathParam(value="appName") String appName, @QueryParam(value="code") String authorizationCode, @Context Request request) throws NotFoundException {
        Response response = this.delegate.loginCallbackAppNameGet(appName, authorizationCode, request);
        return response;
    }

    @GET
    @Path(value="/auth-type")
    @ApiOperation(value="", notes="Login type check Request to Streaming Integrator.", response=UserDTO.class, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Type Check Request Successful.", response=UserDTO.class), @ApiResponse(code=401, message="Invalid Authorization Header", response=UserDTO.class), @ApiResponse(code=500, message="An unexpected error occurred.", response=UserDTO.class)})
    public Response getAuthType() {
        return this.delegate.getAuthType();
    }
}

