/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.auth.rest.api.util;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import org.wso2.msf4j.Request;

public class AuthUtil {
    private static final String COOKIE_PATH_SEPERATOR = "; path=";
    private static final String COOKIE_VALUE_SEPERATOR = "; ";

    public static String extractTokenFromHeaders(HttpHeaders headers, String cookieHeader) {
        String httpONLYCookieValue;
        String authHeader = headers.getHeaderString("Authorization");
        String token = "";
        if (authHeader != null) {
            String[] authHeaderParts = (authHeader = authHeader.trim()).split(" ");
            if (authHeaderParts.length == 2) {
                token = authHeaderParts[1];
            } else if (authHeaderParts.length < 2) {
                return null;
            }
        } else {
            return null;
        }
        if ((httpONLYCookieValue = AuthUtil.getHttpONLYCookieValue(headers, cookieHeader)) == null) {
            return null;
        }
        token = token + httpONLYCookieValue;
        return token;
    }

    public static String extractIdTokenFromHeaders(HttpHeaders headers, String cookieHeader) {
        String authHeader = headers.getHeaderString("Fid");
        if (authHeader == null) {
            return null;
        }
        String httpONLYCookieValue = AuthUtil.getHttpONLYCookieValue(headers, cookieHeader);
        if (httpONLYCookieValue == null) {
            return null;
        }
        String token = authHeader + httpONLYCookieValue;
        return token;
    }

    private static String getHttpONLYCookieValue(HttpHeaders headers, String cookieHeader) {
        String[] cookies;
        String tokenFromCookie;
        String[] tokenParts;
        String cookie = headers.getHeaderString("Cookie");
        if (cookie != null && (tokenParts = (tokenFromCookie = Arrays.stream(cookies = (cookie = cookie.trim()).split(";")).filter(name -> name.contains(cookieHeader)).findFirst().orElse("")).split("=")).length == 2) {
            return tokenParts[1];
        }
        return null;
    }

    public static NewCookie cookieBuilder(String name, String value, String path, boolean isSecure, boolean isHttpOnly, int expiresIn) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(value).append(COOKIE_PATH_SEPERATOR).append(path).append(COOKIE_VALUE_SEPERATOR);
        if (isHttpOnly) {
            stringBuilder.append("HttpOnly").append(COOKIE_VALUE_SEPERATOR);
        }
        if (isSecure) {
            stringBuilder.append("Secure");
        }
        if (expiresIn > 0) {
            stringBuilder.append(COOKIE_VALUE_SEPERATOR).append("Expires=").append(ZonedDateTime.now().plusSeconds(expiresIn).format(DateTimeFormatter.RFC_1123_DATE_TIME)).append(COOKIE_VALUE_SEPERATOR);
        } else if (expiresIn == 0) {
            stringBuilder.append(COOKIE_VALUE_SEPERATOR).append("Expires=").append("Thu, 01 Jan 1970 00:00:01 GMT").append(COOKIE_VALUE_SEPERATOR);
        }
        return new NewCookie(name, stringBuilder.toString());
    }

    public static String getDomainFromHeader(Request request) {
        String tenantDomain = request.getHeader("X-WSO2-Tenant");
        if (tenantDomain == null) {
            tenantDomain = "carbon.super";
        }
        return tenantDomain;
    }
}

