/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.auth.rest.api.impl;

import com.google.gson.Gson;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.auth.rest.api.LoginApiService;
import org.wso2.carbon.analytics.auth.rest.api.NotFoundException;
import org.wso2.carbon.analytics.auth.rest.api.dto.ErrorDTO;
import org.wso2.carbon.analytics.auth.rest.api.dto.RedirectionDTO;
import org.wso2.carbon.analytics.auth.rest.api.dto.UserDTO;
import org.wso2.carbon.analytics.auth.rest.api.internal.DataHolder;
import org.wso2.carbon.analytics.auth.rest.api.internal.ServiceComponent;
import org.wso2.carbon.analytics.auth.rest.api.util.AuthUtil;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.core.utils.config.IdPClientConfiguration;
import org.wso2.carbon.analytics.idp.client.external.ExternalIdPClient;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.msf4j.Request;

public class LoginApiServiceImpl
extends LoginApiService {
    private static final Logger LOG = LoggerFactory.getLogger(LoginApiServiceImpl.class);

    @Reference(service=ServiceComponent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterServiceComponet")
    public void registerServiceComponet(ServiceComponent serviceComponent) {
        LOG.debug("@Reference(bind) ServiceComponent which sets IdP Client");
    }

    public void unRegisterServiceComponet(ServiceComponent serviceComponent) {
        LOG.debug("@Reference(bind) ServiceComponent which sets IdP Client was removed");
    }

    @Activate
    protected void start(BundleContext bundleContext) {
        LOG.debug("Login API started");
    }

    @Deactivate
    protected void stop() {
        LOG.debug("Login API stopped");
    }

    @Override
    public Response loginAppNamePost(String appName, String username, String password, String grantType, Boolean rememberMe, String appId, Request request) throws NotFoundException {
        try {
            String loginStatus;
            if (rememberMe == null) {
                rememberMe = false;
            }
            IdPClient idPClient = DataHolder.getInstance().getIdPClient();
            HashMap<String, String> idPClientProperties = new HashMap<String, String>();
            String trimmedAppName = appName.split("/\\|?")[0];
            String appContext = "/" + trimmedAppName;
            idPClientProperties.put("App_Name", trimmedAppName);
            idPClientProperties.put("Grant_Type", grantType);
            idPClientProperties.put("Remember_Me", rememberMe.toString());
            idPClientProperties.put("Domain", AuthUtil.getDomainFromHeader(request));
            if ("refresh_token".equals(grantType)) {
                String refToken = AuthUtil.extractTokenFromHeaders(request.getHeaders(), "ASID");
                if (refToken == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unable to extract refresh token from the header for the request '{}'.", (Object)LoginApiServiceImpl.removeCRLFCharacters(appName));
                    }
                    ErrorDTO errorDTO = new ErrorDTO();
                    errorDTO.setError("Invalid_Credentials");
                    errorDTO.setDescription("Invalid Authorization header. Please provide the Authorization header to proceed.");
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorDTO).build();
                }
                idPClientProperties.put("Refresh_Token", refToken);
            } else if ("password".equals(grantType)) {
                idPClientProperties.put("App_Id", appId);
                idPClientProperties.put("Username", username);
                idPClientProperties.put("Password", password);
            } else if ("authorization_code".equalsIgnoreCase(grantType)) {
                idPClientProperties.put("Grant_Type", "authorization_code");
                idPClientProperties.put("Callback_Url", appName);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Grant type '{}' is not supported.", (Object)LoginApiServiceImpl.removeCRLFCharacters(grantType));
                }
                ErrorDTO errorDTO = new ErrorDTO();
                errorDTO.setError("Grant_Type_Not_Supported");
                errorDTO.setDescription("Grant type '" + grantType + "' is not supported.");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorDTO).build();
            }
            Map loginResponse = idPClient.login(idPClientProperties);
            switch (loginStatus = (String)loginResponse.get("Status")) {
                case "success": {
                    int validityPeriod;
                    UserDTO userDTO = new UserDTO();
                    userDTO.authUser((String)loginResponse.get("Username"));
                    try {
                        validityPeriod = Integer.parseInt((String)loginResponse.get("Validity_Period"));
                    }
                    catch (NumberFormatException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Error in login to the uri '{}' in getting validity period of the session", (Object)LoginApiServiceImpl.removeCRLFCharacters(appName), (Object)e);
                        }
                        ErrorDTO errorDTO = new ErrorDTO();
                        errorDTO.setError("Internal_Server_Error");
                        errorDTO.setDescription("Error in login to the uri '" + appName + "'. Error: " + e.getMessage());
                        return Response.serverError().entity((Object)errorDTO).build();
                    }
                    userDTO.validityPeriod(validityPeriod);
                    String accessToken = (String)loginResponse.get("Access_Token");
                    String refreshToken = (String)loginResponse.get("Refresh_Token");
                    String accessTokenFirstHalf = accessToken.substring(0, accessToken.length() / 2);
                    String accessTokenSecondHalf = accessToken.substring(accessToken.length() / 2);
                    userDTO.setpID(accessTokenFirstHalf);
                    NewCookie accessTokenhttpOnlyCookie = AuthUtil.cookieBuilder("HID", accessTokenSecondHalf, appContext, true, true, -1);
                    NewCookie accessTokenhttpOnlyCookieDP = AuthUtil.cookieBuilder("DID", accessTokenSecondHalf, "/data-provider", true, true, -1);
                    IdPClientConfiguration authConfigurations = (IdPClientConfiguration)DataHolder.getInstance().getConfigProvider().getConfigurationObject(IdPClientConfiguration.class);
                    NewCookie logoutContextAccessToken = authConfigurations.isSsoEnabled() ? AuthUtil.cookieBuilder("JID", accessTokenSecondHalf, "/logout/slo" + appContext, true, true, -1) : AuthUtil.cookieBuilder("JID", accessTokenSecondHalf, "/logout" + appContext, true, true, -1);
                    if (refreshToken != null) {
                        int refTokenValidityPeriod = -1;
                        if (rememberMe.booleanValue()) {
                            refTokenValidityPeriod = 604800;
                        }
                        String refTokenPart1 = refreshToken.substring(0, refreshToken.length() / 2);
                        String refTokenPart2 = refreshToken.substring(refreshToken.length() / 2);
                        userDTO.setlID(refTokenPart1);
                        NewCookie loginContextRefreshTokenCookie = AuthUtil.cookieBuilder("ASID", refTokenPart2, "/login" + appContext, true, true, refTokenValidityPeriod);
                        if ("refresh_token".equals(grantType) && loginResponse.get("ID_Token") != null) {
                            String idToken = (String)loginResponse.get("ID_Token");
                            NewCookie logoutContextIdToken = this.getLogoutContextIdTokenCookie(idToken, userDTO, appContext);
                            return Response.ok((Object)userDTO, (String)"application/json").cookie(new NewCookie[]{accessTokenhttpOnlyCookie, accessTokenhttpOnlyCookieDP, logoutContextAccessToken, loginContextRefreshTokenCookie, logoutContextIdToken}).build();
                        }
                        return Response.ok((Object)userDTO, (String)"application/json").cookie(new NewCookie[]{accessTokenhttpOnlyCookie, accessTokenhttpOnlyCookieDP, logoutContextAccessToken, loginContextRefreshTokenCookie}).build();
                    }
                    return Response.ok((Object)userDTO, (String)"application/json").cookie(new NewCookie[]{accessTokenhttpOnlyCookie, accessTokenhttpOnlyCookieDP, logoutContextAccessToken}).build();
                }
                case "failure": {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Authentication failure for user '{}' when accessing uri '{}'.", (Object)LoginApiServiceImpl.removeCRLFCharacters(username), (Object)LoginApiServiceImpl.removeCRLFCharacters(appName));
                    }
                    ErrorDTO errorDTO = new ErrorDTO();
                    errorDTO.setError("Invalid_Credentials");
                    errorDTO.setDescription("Username or Password is invalid. Please check again.");
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errorDTO).build();
                }
                case "redirection": {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Authentication redirection for the uri '{}'.", (Object)LoginApiServiceImpl.removeCRLFCharacters(appName));
                    }
                    RedirectionDTO redirectionDTO = new RedirectionDTO();
                    redirectionDTO.setClientId((String)loginResponse.get("Client_Id"));
                    redirectionDTO.setCallbackUrl((String)loginResponse.get("Callback_Url"));
                    redirectionDTO.setRedirectUrl((String)loginResponse.get("Redirect_Url"));
                    if (loginResponse.get("Scope") != null) {
                        redirectionDTO.setScope((String)loginResponse.get("Scope"));
                    }
                    return Response.status((Response.Status)Response.Status.FOUND).entity((Object)redirectionDTO).build();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error in login to the uri '{}'.", (Object)LoginApiServiceImpl.removeCRLFCharacters(appName));
            }
            ErrorDTO errorDTOServerError = new ErrorDTO();
            errorDTOServerError.setError("Internal_Server_Error");
            errorDTOServerError.setDescription("Error in login to the uri '" + appName + "'. Error: 'Invalid Login Status.");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errorDTOServerError).build();
        }
        catch (IdPClientException e) {
            LOG.debug("Error in login to the uri '{}'", (Object)appName, (Object)e);
            ErrorDTO errorDTO = new ErrorDTO();
            errorDTO.setError("Internal_Server_Error");
            errorDTO.setDescription("Error in login to the uri '" + appName + "'. Error: " + e.getMessage());
            return Response.serverError().entity((Object)errorDTO).build();
        }
        catch (ConfigurationException e) {
            LOG.error("Error occurred while reading configs from deployment.yaml. " + e.getMessage());
            ErrorDTO errorDTO = new ErrorDTO();
            errorDTO.setError("Internal_Server_Error");
            errorDTO.setDescription("Error occurred while reading configs from deployment.yaml. " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorDTO).build();
        }
    }

    @Override
    public Response loginCallbackAppNameGet(String appName, String authentication, Request request) throws NotFoundException {
        IdPClient idPClient = DataHolder.getInstance().getIdPClient();
        if (idPClient instanceof ExternalIdPClient) {
            String trimmedAppName = appName.split("/\\|?")[0];
            String appContext = "/" + trimmedAppName;
            String requestUrl = request.getUri();
            String requestCode = requestUrl.substring(requestUrl.lastIndexOf("?code=") + 6);
            try {
                Map authCodeloginResponse;
                ExternalIdPClient oAuth2IdPClient = (ExternalIdPClient)idPClient;
                if (request.getHeader("X-WSO2-Tenant") != null) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("Domain", AuthUtil.getDomainFromHeader(request));
                    authCodeloginResponse = oAuth2IdPClient.authCodeLogin(appName, requestCode, properties);
                } else {
                    authCodeloginResponse = oAuth2IdPClient.authCodeLogin(appName, requestCode);
                }
                String loginStatus = (String)authCodeloginResponse.get("Status");
                if (loginStatus.equals("success")) {
                    int validityPeriod;
                    UserDTO userDTO = new UserDTO();
                    userDTO.authUser((String)authCodeloginResponse.get("Username"));
                    try {
                        validityPeriod = Integer.parseInt((String)authCodeloginResponse.get("Validity_Period"));
                    }
                    catch (NumberFormatException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Error in login to the uri '{}' in getting validity period of the session from Identity Provider.", (Object)LoginApiServiceImpl.removeCRLFCharacters(appName), (Object)e);
                        }
                        ErrorDTO errorDTO = new ErrorDTO();
                        errorDTO.setError("Internal_Server_Error");
                        errorDTO.setDescription("Error in login to the uri '" + appName + "'. Error: " + e.getMessage());
                        return Response.serverError().entity((Object)errorDTO).build();
                    }
                    userDTO.validityPeriod(validityPeriod);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Login callback uri '{}' is redirected to '{}'.", (Object)LoginApiServiceImpl.removeCRLFCharacters(appName), (Object)LoginApiServiceImpl.removeCRLFCharacters((String)authCodeloginResponse.get("Redirect_Url")));
                    }
                    URI targetURIForRedirection = new URI((String)authCodeloginResponse.get("Redirect_Url"));
                    String accessToken = (String)authCodeloginResponse.get("Access_Token");
                    String refreshToken = (String)authCodeloginResponse.get("Refresh_Token");
                    String idToken = (String)authCodeloginResponse.get("ID_Token");
                    NewCookie logoutContextIdToken = this.getLogoutContextIdTokenCookie(idToken, userDTO, appContext);
                    String accessTokenFirstHalf = accessToken.substring(0, accessToken.length() / 2);
                    String accessTokenSecondHalf = accessToken.substring(accessToken.length() / 2);
                    userDTO.setpID(accessTokenFirstHalf);
                    NewCookie accessTokenhttpOnlyCookie = AuthUtil.cookieBuilder("HID", accessTokenSecondHalf, appContext, true, true, -1);
                    NewCookie accessTokenhttpOnlyCookieForDP = AuthUtil.cookieBuilder("DID", accessTokenSecondHalf, "/data-provider", true, true, -1);
                    NewCookie logoutContextAccessToken = AuthUtil.cookieBuilder("JID", accessTokenSecondHalf, "/logout/slo" + appContext, true, true, -1);
                    if (refreshToken != null) {
                        String refTokenPart1 = refreshToken.substring(0, refreshToken.length() / 2);
                        String refTokenPart2 = refreshToken.substring(refreshToken.length() / 2);
                        userDTO.setlID(refTokenPart1);
                        NewCookie loginContextRefreshTokenCookie = AuthUtil.cookieBuilder("ASID", refTokenPart2, "/login" + appContext, true, true, 604800);
                        NewCookie userAuthenticate = AuthUtil.cookieBuilder("USER_DTO", new Gson().toJson((Object)userDTO), appContext, true, false, -1);
                        return Response.status((Response.Status)Response.Status.FOUND).header("Location", (Object)targetURIForRedirection).entity((Object)userDTO).cookie(new NewCookie[]{accessTokenhttpOnlyCookie, accessTokenhttpOnlyCookieForDP, logoutContextAccessToken, loginContextRefreshTokenCookie, userAuthenticate, logoutContextIdToken}).build();
                    }
                    return Response.status((Response.Status)Response.Status.FOUND).header("Location", (Object)targetURIForRedirection).entity((Object)userDTO).cookie(new NewCookie[]{accessTokenhttpOnlyCookie, accessTokenhttpOnlyCookieForDP, logoutContextAccessToken, logoutContextIdToken}).build();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to get the token from the returned code '{}', for callback uri '{}'.", (Object)LoginApiServiceImpl.removeCRLFCharacters(requestCode), (Object)LoginApiServiceImpl.removeCRLFCharacters(appName));
                }
                ErrorDTO errorDTO = new ErrorDTO();
                errorDTO.setError("Invalid_Credentials");
                errorDTO.setDescription("Unable to get the token from the returned code '" + requestCode + "'");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errorDTO).build();
            }
            catch (URISyntaxException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error in redirecting uri '{}' for auth code grant type login.", (Object)LoginApiServiceImpl.removeCRLFCharacters(appName), (Object)e);
                }
                ErrorDTO errorDTO = new ErrorDTO();
                errorDTO.setError("Internal_Server_Error");
                errorDTO.setDescription("Error in redirecting uri for auth code grant type login. Error: '" + e.getMessage() + "'.");
                return Response.serverError().entity((Object)errorDTO).build();
            }
            catch (IdPClientException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error in accessing token from the code '{}', for uri '{}'.", new Object[]{LoginApiServiceImpl.removeCRLFCharacters(requestCode), LoginApiServiceImpl.removeCRLFCharacters(appName), e});
                }
                ErrorDTO errorDTO = new ErrorDTO();
                errorDTO.setError("Internal_Server_Error");
                errorDTO.setDescription("Error in accessing token from the code for uri '" + appName + "'. Error : '" + e.getMessage() + "'");
                return Response.serverError().entity((Object)errorDTO).build();
            }
            catch (Throwable t) {
                LOG.error("Error occurred: " + t.getMessage(), t);
                ErrorDTO errorDTO = new ErrorDTO();
                errorDTO.setError("Internal_Server_Error");
                errorDTO.setDescription("Error occurred '" + appName + "'. Error : '" + t.getMessage() + "'");
                return Response.serverError().entity((Object)errorDTO).build();
            }
        }
        String errorMsg = "This API is only supported for External IS integration with OAuth2 support. IdPClient found is '" + LoginApiServiceImpl.removeCRLFCharacters(idPClient.getClass().getName());
        LOG.debug(errorMsg);
        ErrorDTO errorDTO = new ErrorDTO();
        errorDTO.setError("Internal_Server_Error");
        errorDTO.setDescription(errorMsg);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorDTO).build();
    }

    @Override
    public Response getAuthType() {
        try {
            IdPClientConfiguration authConfigurations = (IdPClientConfiguration)DataHolder.getInstance().getConfigProvider().getConfigurationObject(IdPClientConfiguration.class);
            HashMap<String, String> responseMap = new HashMap<String, String>();
            responseMap.put("authType", authConfigurations.isSsoEnabled() ? "sso" : "default");
            return Response.ok().entity(responseMap).build();
        }
        catch (ConfigurationException e) {
            ErrorDTO errorDTO = new ErrorDTO();
            errorDTO.setError("Internal_Server_Error");
            errorDTO.setDescription("Error occurred while reading configs from deployment.yaml. " + e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorDTO).build();
        }
    }

    private NewCookie getLogoutContextIdTokenCookie(String idToken, UserDTO userDTO, String appContext) {
        String idTokenFirstHalf = idToken.substring(0, idToken.length() / 2);
        String idTokenSecondHalf = idToken.substring(idToken.length() / 2);
        userDTO.setiID(idTokenFirstHalf);
        return AuthUtil.cookieBuilder("FID", idTokenSecondHalf, "/logout/slo" + appContext, true, true, -1);
    }

    private static String removeCRLFCharacters(String str) {
        if (str != null) {
            str = str.replace('\n', '_').replace('\r', '_');
        }
        return str;
    }
}

