/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.auth.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.analytics.auth.rest.api.LogoutApiService;
import org.wso2.carbon.analytics.auth.rest.api.NotFoundException;
import org.wso2.carbon.analytics.auth.rest.api.dto.ErrorDTO;
import org.wso2.carbon.analytics.auth.rest.api.factories.LogoutApiServiceFactory;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.Request;

@Path(value="/logout")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationPath(value="/logout")
@Api(description="the logout API")
@Component(name="LogoutApi", service={Microservice.class}, immediate=true)
public class LogoutApi
implements Microservice {
    private final LogoutApiService delegate = LogoutApiServiceFactory.getLogoutApi();

    @POST
    @Path(value="/{appName:(.*)}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Logout Request to Streaming Integrator", response=void.class, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Authorization Request Successful.", response=void.class), @ApiResponse(code=500, message="An unexpected error occured.", response=void.class)})
    public Response logoutAppNamePost(@ApiParam(value="AppName", required=true) @PathParam(value="appName") String appName, @Context Request request) throws NotFoundException {
        return this.delegate.logoutAppNamePost(appName, request);
    }

    @GET
    @Path(value="/slo/{appName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Login type check Request to Streaming Integrator.", response=HashMap.class, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="SSO logout Request to Stream processor", response=HashMap.class), @ApiResponse(code=401, message="Invalid Authorization Header", response=ErrorDTO.class), @ApiResponse(code=500, message="An unexpected error occurred.", response=ErrorDTO.class)})
    public Response singleLogoutAppNamePost(@ApiParam(value="AppName", required=true) @PathParam(value="appName") String appName, @Context Request request) throws NotFoundException {
        return this.delegate.ssoLogout(appName, request);
    }
}

