/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.jms.internal.util;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;

public class JMSMessageListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(JMSMessageListener.class);
    private InputEventAdapterListener eventAdaptorListener = null;
    private final int tenantId;
    private final String tenantDomain;

    public JMSMessageListener(InputEventAdapterListener eventAdaptorListener) {
        this.eventAdaptorListener = eventAdaptorListener;
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        this.tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block25: {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(this.tenantDomain);
                if (message != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Event received in JMS Event Adaptor - " + message));
                    }
                    if (message instanceof TextMessage) {
                        TextMessage textMessage = (TextMessage)message;
                        try {
                            String msgText = textMessage.getText();
                            this.eventAdaptorListener.onEvent((Object)msgText);
                        }
                        catch (JMSException e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)("Failed to get text from " + textMessage), (Throwable)e);
                            }
                            break block25;
                        }
                        catch (InputEventAdapterRuntimeException e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)e);
                            }
                            break block25;
                        }
                    }
                    if (message instanceof MapMessage) {
                        MapMessage mapMessage = (MapMessage)message;
                        HashMap event = new HashMap();
                        try {
                            Enumeration names = mapMessage.getMapNames();
                            while (names.hasMoreElements()) {
                                Object name = names.nextElement();
                                event.put(name, mapMessage.getObject((String)name));
                            }
                            this.eventAdaptorListener.onEvent(event);
                        }
                        catch (JMSException e) {
                            log.error((Object)"Can not read the map message ", (Throwable)e);
                        }
                        catch (InputEventAdapterRuntimeException e) {
                            log.error((Object)"Can not send the message to broker ", (Throwable)e);
                        }
                    } else if (message instanceof BytesMessage) {
                        BytesMessage bytesMessage = (BytesMessage)message;
                        byte[] bytes = new byte[(int)bytesMessage.getBodyLength()];
                        bytesMessage.readBytes(bytes);
                        this.eventAdaptorListener.onEvent((Object)new String(bytes, "UTF-8"));
                    } else {
                        log.warn((Object)"Event dropped due to unsupported message type");
                    }
                    break block25;
                }
                log.warn((Object)"Dropping the empty/null event received through jms adaptor");
            }
            catch (JMSException e) {
                log.error((Object)e);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
            }
            catch (Throwable t) {
                log.error((Object)t);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }
}

