/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.jms;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.jms.JMSEventAdapter;

public class JMSEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.jms.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "jms";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("xml");
        supportInputMessageTypes.add("json");
        supportInputMessageTypes.add("map");
        supportInputMessageTypes.add("text");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property topicProperty = new Property("transport.jms.Destination");
        topicProperty.setDisplayName(this.resourceBundle.getString("transport.jms.Destination"));
        topicProperty.setRequired(true);
        topicProperty.setHint(this.resourceBundle.getString("transport.jms.Destination.hint"));
        propertyList.add(topicProperty);
        Property initialContextProperty = new Property("java.naming.factory.initial");
        initialContextProperty.setDisplayName(this.resourceBundle.getString("java.naming.factory.initial"));
        initialContextProperty.setRequired(true);
        initialContextProperty.setHint(this.resourceBundle.getString("java.naming.factory.initial.hint"));
        propertyList.add(initialContextProperty);
        Property javaNamingProviderUrlProperty = new Property("java.naming.provider.url");
        javaNamingProviderUrlProperty.setDisplayName(this.resourceBundle.getString("java.naming.provider.url"));
        javaNamingProviderUrlProperty.setRequired(true);
        javaNamingProviderUrlProperty.setHint(this.resourceBundle.getString("java.naming.provider.url.hint"));
        propertyList.add(javaNamingProviderUrlProperty);
        Property userNameProperty = new Property("transport.jms.UserName");
        userNameProperty.setDisplayName(this.resourceBundle.getString("transport.jms.UserName"));
        propertyList.add(userNameProperty);
        Property passwordProperty = new Property("transport.jms.Password");
        passwordProperty.setSecured(true);
        passwordProperty.setEncrypted(true);
        passwordProperty.setDisplayName(this.resourceBundle.getString("transport.jms.Password"));
        propertyList.add(passwordProperty);
        Property connectionFactoryNameProperty = new Property("transport.jms.ConnectionFactoryJNDIName");
        connectionFactoryNameProperty.setRequired(true);
        connectionFactoryNameProperty.setDisplayName(this.resourceBundle.getString("transport.jms.ConnectionFactoryJNDIName"));
        connectionFactoryNameProperty.setHint(this.resourceBundle.getString("transport.jms.ConnectionFactoryJNDIName.hint"));
        propertyList.add(connectionFactoryNameProperty);
        Property destinationTypeProperty = new Property("transport.jms.DestinationType");
        destinationTypeProperty.setRequired(true);
        destinationTypeProperty.setDisplayName(this.resourceBundle.getString("transport.jms.DestinationType"));
        destinationTypeProperty.setOptions(new String[]{"topic", "queue"});
        destinationTypeProperty.setDefaultValue("topic");
        destinationTypeProperty.setHint(this.resourceBundle.getString("transport.jms.DestinationType.hint"));
        propertyList.add(destinationTypeProperty);
        Property isDurableSubscriptionProperty = new Property("transport.jms.SubscriptionDurable");
        isDurableSubscriptionProperty.setRequired(false);
        isDurableSubscriptionProperty.setDisplayName(this.resourceBundle.getString("transport.jms.SubscriptionDurable"));
        isDurableSubscriptionProperty.setHint(this.resourceBundle.getString("transport.jms.SubscriptionDurable.hint"));
        isDurableSubscriptionProperty.setOptions(new String[]{"true", "false"});
        isDurableSubscriptionProperty.setDefaultValue("false");
        propertyList.add(isDurableSubscriptionProperty);
        Property subscriberNameProperty = new Property("transport.jms.DurableSubscriberClientID");
        subscriberNameProperty.setRequired(false);
        subscriberNameProperty.setDisplayName(this.resourceBundle.getString("transport.jms.DurableSubscriberClientID"));
        subscriberNameProperty.setHint(this.resourceBundle.getString("transport.jms.DurableSubscriberClientID.hint"));
        propertyList.add(subscriberNameProperty);
        Property jmsProperties = new Property("jms.properties");
        jmsProperties.setDisplayName(this.resourceBundle.getString("jms.properties"));
        jmsProperties.setHint(this.resourceBundle.getString("jms.properties.hint"));
        jmsProperties.setRequired(false);
        propertyList.add(jmsProperties);
        Property jmsSecuredProperties = new Property("jms.secured.properties");
        jmsSecuredProperties.setDisplayName(this.resourceBundle.getString("jms.secured.properties"));
        jmsSecuredProperties.setHint(this.resourceBundle.getString("jms.secured.properties.hint"));
        jmsSecuredProperties.setRequired(false);
        jmsSecuredProperties.setEncrypted(true);
        jmsSecuredProperties.setSecured(true);
        propertyList.add(jmsSecuredProperties);
        return propertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new JMSEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

