/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.jms;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import org.apache.axis2.transport.base.threads.NativeWorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.input.adapter.jms.internal.util.JMSConnectionFactory;
import org.wso2.carbon.event.input.adapter.jms.internal.util.JMSListener;
import org.wso2.carbon.event.input.adapter.jms.internal.util.JMSMessageListener;
import org.wso2.carbon.event.input.adapter.jms.internal.util.JMSTaskManager;
import org.wso2.carbon.event.input.adapter.jms.internal.util.JMSTaskManagerFactory;

public class JMSEventAdapter
implements InputEventAdapter {
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private final String id = UUID.randomUUID().toString();
    private InputEventAdapterListener eventAdapterListener;
    private JMSConnectionFactory jmsConnectionFactory;
    private JMSListener jmsListener;
    private Log log = LogFactory.getLog(JMSEventAdapter.class);
    private String destination;
    private int minThreadPoolSize;
    private int maxThreadPoolSize;
    private int KeepAliveTimeInMillis;
    private int jobQueueSize;
    private int waitingTime = 0;

    public JMSEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.KeepAliveTimeInMillis = globalProperties.get("keepAliveTimeInMillis") != null ? Integer.parseInt(globalProperties.get("keepAliveTimeInMillis")) : 1000;
        this.jobQueueSize = globalProperties.get("jobQueueSize") != null ? Integer.parseInt(globalProperties.get("jobQueueSize")) : 1000;
        if (globalProperties.get("listenerWaitingTimeInMillis") != null) {
            this.waitingTime = Integer.parseInt(globalProperties.get("listenerWaitingTimeInMillis"));
        }
        this.minThreadPoolSize = 4;
        this.maxThreadPoolSize = 4;
    }

    public void init(InputEventAdapterListener eventAdapterListener) throws InputEventAdapterException {
        this.eventAdapterListener = eventAdapterListener;
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        this.createJMSAdaptorListener(this.eventAdapterListener);
    }

    public void disconnect() {
        if (this.jmsListener != null) {
            this.jmsListener.stopListener();
        }
        if (this.jmsConnectionFactory != null) {
            this.jmsConnectionFactory.stop();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("JMS consumer " + this.eventAdapterConfiguration.getName() + " disconnected from destination : " + this.destination));
        }
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JMSEventAdapter)) {
            return false;
        }
        JMSEventAdapter that = (JMSEventAdapter)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private void createJMSAdaptorListener(InputEventAdapterListener inputEventAdaptorListener) {
        HashMap<String, String> adapterProperties = new HashMap<String, String>();
        adapterProperties.putAll(this.eventAdapterConfiguration.getProperties());
        Map<String, String> jmsProperties = this.extractProperties((String)this.eventAdapterConfiguration.getProperties().get("jms.properties"));
        Map<String, String> jmsSecuredProperties = this.extractProperties((String)this.eventAdapterConfiguration.getProperties().get("jms.secured.properties"));
        if (jmsProperties != null) {
            adapterProperties.remove("jms.properties");
            adapterProperties.putAll(jmsProperties);
            if (adapterProperties.containsKey("transport.jms.ConcurrentConsumers")) {
                try {
                    this.minThreadPoolSize = Integer.parseInt((String)adapterProperties.get("transport.jms.ConcurrentConsumers"));
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)"Invalid JMS Property: transport.jms.ConcurrentConsumers, ignoring configuration and using default for JMS output event adaptor...");
                }
            }
            if (adapterProperties.containsKey("transport.jms.MaxConcurrentConsumers")) {
                try {
                    this.maxThreadPoolSize = Integer.parseInt((String)adapterProperties.get("transport.jms.MaxConcurrentConsumers"));
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)"Invalid JMS Property: transport.jms.MaxConcurrentConsumers, ignoring configuration and using default for JMS output event adaptor...");
                }
            }
        }
        if (jmsSecuredProperties != null) {
            adapterProperties.remove("jms.secured.properties");
            adapterProperties.putAll(jmsSecuredProperties);
        }
        this.destination = (String)this.eventAdapterConfiguration.getProperties().get("transport.jms.Destination");
        this.jmsConnectionFactory = new JMSConnectionFactory(this.convertMapToHashTable(adapterProperties), this.eventAdapterConfiguration.getName());
        HashMap<String, String> messageConfig = new HashMap<String, String>();
        messageConfig.put("transport.jms.Destination", this.destination);
        JMSTaskManager jmsTaskManager = JMSTaskManagerFactory.createTaskManagerForService(this.jmsConnectionFactory, this.eventAdapterConfiguration.getName(), (WorkerPool)new NativeWorkerPool(this.minThreadPoolSize, this.maxThreadPoolSize, this.KeepAliveTimeInMillis, this.jobQueueSize, "JMS Threads", "JMSThreads" + UUID.randomUUID().toString()), messageConfig);
        jmsTaskManager.setJmsMessageListener(new JMSMessageListener(inputEventAdaptorListener));
        this.jmsListener = new JMSListener(this.eventAdapterConfiguration.getName() + "#" + this.destination, jmsTaskManager);
        this.jmsListener.startListener(this.waitingTime);
    }

    private Hashtable<String, String> convertMapToHashTable(Map<String, String> map) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (Map.Entry<String, String> stringStringEntry : map.entrySet()) {
            Map.Entry<String, String> pair = stringStringEntry;
            if (pair.getValue() == null) continue;
            table.put(pair.getKey().toString(), pair.getValue().toString());
        }
        return table;
    }

    private Map<String, String> extractProperties(String properties) {
        if (properties == null || properties.trim().length() == 0) {
            return null;
        }
        String[] entries = properties.split(",");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String property : entries) {
            try {
                String[] keyValue = property.split(":", 2);
                result.put(keyValue[0].trim(), keyValue[1].trim());
            }
            catch (Exception e) {
                this.log.warn((Object)("JMS property '" + property + "' is not defined in the correct format."), (Throwable)e);
            }
        }
        return result;
    }

    public boolean isEventDuplicatedInCluster() {
        String destinationType = (String)this.eventAdapterConfiguration.getProperties().get("transport.jms.DestinationType");
        return destinationType.equalsIgnoreCase("topic");
    }

    public boolean isPolling() {
        return true;
    }
}

