/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.binary.internal;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.databridge.commons.ServerEventListener;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.receiver.binary.conf.BinaryDataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.binary.internal.BinaryDataReceiver;
import org.wso2.carbon.kernel.CarbonRuntime;

@Component(name="binary-receiver-component-service", immediate=true)
public class BinaryDataReceiverServiceComponent {
    private static final Logger log = LogManager.getLogger(BinaryDataReceiverServiceComponent.class);
    private DataBridgeReceiverService dataBridgeReceiverService;
    private static CarbonRuntime carbonRuntime;
    private BinaryDataReceiver binaryDataReceiver;

    protected void activate(ComponentContext context) {
        log.info("org.wso2.carbon.databridge.receiver.binary.internal.Service Component is activated");
        this.binaryDataReceiver = new BinaryDataReceiver(new BinaryDataReceiverConfiguration(this.dataBridgeReceiverService.getInitialConfig()), this.dataBridgeReceiverService);
        context.getBundleContext().registerService(ServerEventListener.class.getName(), (Object)this.binaryDataReceiver, null);
    }

    protected void deactivate(ComponentContext context) {
        log.info("Binary Data Receiver server shutting down...");
        this.binaryDataReceiver.stop();
    }

    @Reference(name="databridge.receiver.service", service=DataBridgeReceiverService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetDatabridgeReceiverService")
    protected void setDataBridgeReceiverService(DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
    }

    protected void unsetDatabridgeReceiverService(DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = null;
    }

    @Reference(name="carbon.runtime.service", service=CarbonRuntime.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonRuntime")
    protected void setCarbonRuntime(CarbonRuntime carbonRuntime) {
        BinaryDataReceiverServiceComponent.carbonRuntime = carbonRuntime;
    }

    protected void unsetCarbonRuntime(CarbonRuntime carbonRuntime) {
        BinaryDataReceiverServiceComponent.carbonRuntime = null;
    }

    public static CarbonRuntime getCarbonRuntime() {
        return carbonRuntime;
    }
}

