/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.binary.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.concurrent.ExecutorService;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.carbon.databridge.commons.ServerEventListener;
import org.wso2.carbon.databridge.commons.binary.BinaryMessageConverterUtil;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.exception.DataBridgeException;
import org.wso2.carbon.databridge.receiver.binary.BinaryEventConverter;
import org.wso2.carbon.databridge.receiver.binary.conf.BinaryDataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.binary.internal.BinaryDataReceiverThreadPoolExecutor;
import org.wso2.carbon.utils.Utils;

public class BinaryDataReceiver
implements ServerEventListener {
    private static final Logger log = LogManager.getLogger(BinaryDataReceiver.class);
    private DataBridgeReceiverService dataBridgeReceiverService;
    private BinaryDataReceiverConfiguration binaryDataReceiverConfiguration;
    private ExecutorService sslReceiverExecutorService;
    private ExecutorService tcpReceiverExecutorService;
    private static final String DISABLE_RECEIVER = "disable.receiver";
    private boolean isStarted = false;
    private SSLServerSocket sslserversocket;
    private ServerSocket serversocket;

    public BinaryDataReceiver(BinaryDataReceiverConfiguration binaryDataReceiverConfiguration, DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
        this.binaryDataReceiverConfiguration = binaryDataReceiverConfiguration;
        this.sslReceiverExecutorService = new BinaryDataReceiverThreadPoolExecutor(binaryDataReceiverConfiguration.getSizeOfSSLThreadPool(), "Receiver-Binary-SSL");
        this.tcpReceiverExecutorService = new BinaryDataReceiverThreadPoolExecutor(binaryDataReceiverConfiguration.getSizeOfTCPThreadPool(), "Receiver-Binary-TCP");
    }

    public void start() {
        String disableReceiver = System.getProperty(DISABLE_RECEIVER);
        if (Boolean.parseBoolean(disableReceiver)) {
            log.info("Receiver disabled.");
            return;
        }
        try {
            this.startSecureTransmission();
            this.startEventTransmission();
            this.isStarted = true;
        }
        catch (IOException e) {
            log.error("Error while starting binary data receiver ", (Throwable)e);
        }
        catch (DataBridgeException e) {
            log.error("Error while starting binary data receiver ", (Throwable)e);
        }
    }

    public void stop() {
        if (this.isStarted) {
            log.info("Stopping Binary Server..");
            this.sslReceiverExecutorService.shutdown();
            this.tcpReceiverExecutorService.shutdown();
            if (this.sslserversocket != null) {
                try {
                    this.sslserversocket.close();
                }
                catch (IOException e) {
                    log.error("Error occurs when closing the SSL server socket ", (Throwable)e);
                }
            }
            if (this.serversocket != null) {
                try {
                    this.serversocket.close();
                }
                catch (IOException e) {
                    log.error("Error occurs when closing the server socket ", (Throwable)e);
                }
            }
            while (!this.dataBridgeReceiverService.isQueueEmpty().booleanValue()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.warn("Error in waiting for queue to become empty " + e.getMessage());
                }
            }
            log.info("Successfully stopped Binary server");
        } else {
            log.info("Binary server not started in order to stop");
        }
    }

    private void startSecureTransmission() throws IOException, DataBridgeException {
        try {
            String ciphers;
            KeyStore ks;
            String keyStorePassword;
            String keyStore = this.dataBridgeReceiverService.getInitialConfig().getKeyStoreLocation();
            if (keyStore == null && (keyStore = System.getProperty("Security.KeyStore.Location")) == null) {
                String defaultKeyStore = Utils.getCarbonHome() + File.separator + "resources" + File.separator + "security" + File.separator + "wso2carbon.jks";
                Path defaultKeyStoreFilePath = Paths.get(defaultKeyStore, new String[0]);
                if (Files.exists(defaultKeyStoreFilePath, new LinkOption[0])) {
                    keyStore = defaultKeyStore;
                } else {
                    throw new DataBridgeException("Cannot start binary agent server,  Security.KeyStore.Location is null");
                }
            }
            if ((keyStorePassword = this.dataBridgeReceiverService.getInitialConfig().getKeyStorePassword()) == null && (keyStorePassword = System.getProperty("Security.KeyStore.Password")) == null) {
                throw new DataBridgeException("Cannot start binary agent server, not valid Security.KeyStore. Password is null ");
            }
            System.setProperty("javax.net.ssl.keyStore", keyStore);
            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
            SSLServerSocketFactory sslServerSocketFactory = null;
            try (InputStream inputStream = null;){
                ks = KeyStore.getInstance("JKS");
                inputStream = new FileInputStream(keyStore);
                ks.load(inputStream, keyStorePassword.toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyStorePassword.toCharArray());
            SSLContext sslContext = SSLContext.getInstance(this.binaryDataReceiverConfiguration.getChannelEncryptionProtocol());
            sslContext.init(kmf.getKeyManagers(), null, null);
            sslServerSocketFactory = sslContext.getServerSocketFactory();
            this.sslserversocket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(this.binaryDataReceiverConfiguration.getSSLPort());
            String sslProtocols = this.binaryDataReceiverConfiguration.getSslProtocols();
            if (sslProtocols != null && sslProtocols.length() != 0) {
                String[] sslProtocolsArray = sslProtocols.split(",");
                this.sslserversocket.setEnabledProtocols(sslProtocolsArray);
            }
            if ((ciphers = this.binaryDataReceiverConfiguration.getCiphers()) != null && ciphers.length() != 0) {
                String[] ciphersArray = ciphers.split(",");
                this.sslserversocket.setEnabledCipherSuites(ciphersArray);
            } else {
                this.sslserversocket.setEnabledCipherSuites(this.sslserversocket.getSupportedCipherSuites());
            }
            Thread thread = new Thread(new BinarySecureEventServerAcceptor(this.sslserversocket));
            thread.start();
            log.info("Started Binary SSL Transport on port : " + this.binaryDataReceiverConfiguration.getSSLPort());
        }
        catch (KeyManagementException e) {
            throw new DataBridgeException("Cannot start binary agent server, Error occurred when initiating SSL context", (Throwable)e);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new DataBridgeException("Cannot start binary agent server, Error occurred when initiating KeyManagerFactory using keystore", (Throwable)e);
        }
    }

    private void startEventTransmission() throws IOException {
        ServerSocketFactory serversocketfactory = ServerSocketFactory.getDefault();
        this.serversocket = serversocketfactory.createServerSocket(this.binaryDataReceiverConfiguration.getTCPPort());
        Thread thread = new Thread(new BinaryEventServerAcceptor(this.serversocket));
        thread.start();
        log.info("Started Binary TCP Transport on port : " + this.binaryDataReceiverConfiguration.getTCPPort());
    }

    private String processMessage(int messageType, byte[] message, OutputStream outputStream) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(message);
        switch (messageType) {
            case 0: {
                int userNameLength = byteBuffer.getInt();
                int passwordLength = byteBuffer.getInt();
                String userName = new String(message, 8, userNameLength);
                String password = new String(message, 8 + userNameLength, passwordLength);
                try {
                    String sessionId = this.dataBridgeReceiverService.login(userName, password);
                    ByteBuffer buffer = ByteBuffer.allocate(5 + sessionId.length());
                    buffer.put((byte)2);
                    buffer.putInt(sessionId.length());
                    buffer.put(sessionId.getBytes("UTF-8"));
                    outputStream.write(buffer.array());
                    outputStream.flush();
                }
                catch (Exception e) {
                    try {
                        this.sendError(e, outputStream);
                    }
                    catch (IOException e1) {
                        log.error("Error while sending response for login message: " + e1.getMessage(), (Throwable)e1);
                    }
                }
                break;
            }
            case 1: {
                int sessionIdLength = byteBuffer.getInt();
                String sessionId = new String(message, 4, sessionIdLength);
                try {
                    this.dataBridgeReceiverService.logout(sessionId);
                    outputStream.write(0);
                    outputStream.flush();
                }
                catch (Exception e) {
                    try {
                        this.sendError(e, outputStream);
                    }
                    catch (IOException e1) {
                        log.error("Error while sending response for login message: " + e1.getMessage(), (Throwable)e1);
                    }
                }
                break;
            }
            case 2: {
                int sessionIdLength = byteBuffer.getInt();
                String sessionId = new String(message, 4, sessionIdLength);
                try {
                    this.dataBridgeReceiverService.publish((Object)message, sessionId, (EventConverter)BinaryEventConverter.getConverter());
                    outputStream.write(0);
                    outputStream.flush();
                }
                catch (Exception e) {
                    try {
                        this.sendError(e, outputStream);
                    }
                    catch (IOException e1) {
                        log.error("Error while sending response for login message: " + e1.getMessage(), (Throwable)e1);
                    }
                }
                break;
            }
            default: {
                log.error("Message Type " + messageType + " is not supported!");
            }
        }
        return null;
    }

    private void sendError(Exception e, OutputStream outputStream) throws IOException {
        int errorClassNameLength = e.getClass().getCanonicalName().length();
        int errorMsgLength = e.getMessage().length();
        ByteBuffer bbuf = ByteBuffer.wrap(new byte[8]);
        bbuf.putInt(errorClassNameLength);
        bbuf.putInt(errorMsgLength);
        outputStream.write(1);
        outputStream.write(bbuf.array());
        outputStream.write(e.getClass().getCanonicalName().getBytes("UTF-8"));
        outputStream.write(e.getMessage().getBytes("UTF-8"));
        outputStream.flush();
    }

    public class BinaryTransportReceiver
    implements Runnable {
        private Socket socket;

        public BinaryTransportReceiver(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                BufferedInputStream inputstream = new BufferedInputStream(this.socket.getInputStream());
                BufferedOutputStream outputStream = new BufferedOutputStream(this.socket.getOutputStream());
                int messageType = ((InputStream)inputstream).read();
                while (messageType != -1) {
                    int messageSize = ByteBuffer.wrap(BinaryMessageConverterUtil.loadData((InputStream)inputstream, (byte[])new byte[4])).getInt();
                    byte[] message = BinaryMessageConverterUtil.loadData((InputStream)inputstream, (byte[])new byte[messageSize]);
                    BinaryDataReceiver.this.processMessage(messageType, message, outputStream);
                    messageType = ((InputStream)inputstream).read();
                }
            }
            catch (IOException ex) {
                log.error("Error while reading from the socket. ", (Throwable)ex);
            }
        }
    }

    public class BinaryEventServerAcceptor
    implements Runnable {
        private ServerSocket serverSocket;

        public BinaryEventServerAcceptor(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket socket = this.serverSocket.accept();
                    BinaryDataReceiver.this.tcpReceiverExecutorService.submit(new BinaryTransportReceiver(socket));
                }
                catch (SocketException e) {
                    log.warn("Error while accepting TCP connection from " + this.serverSocket + " for binary transport receiver.");
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Error while accepting TCP connection from " + this.serverSocket + " for binary transport receiver. ", (Throwable)e);
                }
                catch (IOException e) {
                    log.error("Error while accepting the connection. ", (Throwable)e);
                }
            }
        }
    }

    public class BinarySecureEventServerAcceptor
    implements Runnable {
        private ServerSocket serverSocket;

        public BinarySecureEventServerAcceptor(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket socket = this.serverSocket.accept();
                    BinaryDataReceiver.this.sslReceiverExecutorService.submit(new BinaryTransportReceiver(socket));
                }
                catch (SocketException e) {
                    log.warn("Error while accepting TCP connection from " + this.serverSocket + " for binary transport receiver.");
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Error while accepting TCP connection from " + this.serverSocket + " for binary transport receiver.", (Throwable)e);
                }
                catch (IOException e) {
                    log.error("Error while accepting the connection. ", (Throwable)e);
                }
            }
        }
    }
}

