/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.binary.conf;

import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.conf.DataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.binary.internal.BinaryDataReceiverServiceComponent;

public class BinaryDataReceiverConfiguration {
    private int sslPort;
    private int tcpPort;
    private int sizeOfSSLThreadPool;
    private int sizeOfTCPThreadPool;
    private String sslProtocols;
    private String ciphers;
    private String channelEncryptionProtocol;

    public BinaryDataReceiverConfiguration(int sslPort, int tcpPort) {
        this.sslPort = sslPort;
        this.tcpPort = tcpPort;
        this.sizeOfSSLThreadPool = 100;
        this.sizeOfTCPThreadPool = 100;
        this.channelEncryptionProtocol = "TLSv1.2";
    }

    public BinaryDataReceiverConfiguration(DataBridgeConfiguration dataBridgeConfiguration) {
        DataReceiverConfiguration dataReceiverConfiguration = dataBridgeConfiguration.getDataReceiver("Binary");
        String sslPortConfiguration = (String)dataReceiverConfiguration.getProperties().get("sslPort");
        String tcpPortConfiguration = (String)dataReceiverConfiguration.getProperties().get("tcpPort");
        String sslThreadPoolSize = (String)dataReceiverConfiguration.getProperties().get("sslReceiverThreadPoolSize");
        String tcpThreadPoolSize = (String)dataReceiverConfiguration.getProperties().get("tcpReceiverThreadPoolSize");
        String sslProtocols = (String)dataReceiverConfiguration.getProperties().get("sslEnabledProtocols");
        String ciphers = (String)dataReceiverConfiguration.getProperties().get("ciphers");
        String channelEncryptionProtocol = (String)dataReceiverConfiguration.getProperties().get("channelEncryptionProtocol");
        this.sslPort = sslPortConfiguration != null && !sslPortConfiguration.trim().isEmpty() ? Integer.parseInt(sslPortConfiguration.trim()) + BinaryDataReceiverConfiguration.getPortOffset() : 9611 + BinaryDataReceiverConfiguration.getPortOffset();
        this.tcpPort = tcpPortConfiguration != null && !tcpPortConfiguration.trim().isEmpty() ? Integer.parseInt(tcpPortConfiguration.trim()) + BinaryDataReceiverConfiguration.getPortOffset() : 9711 + BinaryDataReceiverConfiguration.getPortOffset();
        this.sizeOfSSLThreadPool = sslThreadPoolSize != null && !sslThreadPoolSize.trim().isEmpty() ? Integer.parseInt(sslThreadPoolSize.trim()) : 100;
        this.sizeOfTCPThreadPool = tcpThreadPoolSize != null && !tcpThreadPoolSize.trim().isEmpty() ? Integer.parseInt(tcpThreadPoolSize.trim()) : 100;
        if (sslProtocols != null && !sslProtocols.trim().isEmpty()) {
            this.sslProtocols = sslProtocols;
        }
        if (ciphers != null && !ciphers.trim().isEmpty()) {
            this.ciphers = ciphers;
        }
        this.channelEncryptionProtocol = channelEncryptionProtocol != null && !channelEncryptionProtocol.trim().isEmpty() ? channelEncryptionProtocol : "TLSv1.2";
    }

    private static int getPortOffset() {
        return BinaryDataReceiverServiceComponent.getCarbonRuntime().getConfiguration().getPortsConfig().getOffset();
    }

    public int getSSLPort() {
        return this.sslPort;
    }

    public int getTCPPort() {
        return this.tcpPort;
    }

    public int getSizeOfTCPThreadPool() {
        return this.sizeOfTCPThreadPool;
    }

    public int getSizeOfSSLThreadPool() {
        return this.sizeOfSSLThreadPool;
    }

    public String getSslProtocols() {
        return this.sslProtocols;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public String getChannelEncryptionProtocol() {
        return this.channelEncryptionProtocol;
    }
}

