/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.local;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.core.models.Role;
import org.wso2.carbon.analytics.idp.client.core.spi.IdPClientFactory;
import org.wso2.carbon.analytics.idp.client.core.utils.SSLConfig;
import org.wso2.carbon.analytics.idp.client.core.utils.config.IdPClientConfiguration;
import org.wso2.carbon.analytics.idp.client.core.utils.config.SSLConfiguration;
import org.wso2.carbon.analytics.idp.client.core.utils.config.UserChildElement;
import org.wso2.carbon.analytics.idp.client.local.LocalIdPClient;
import org.wso2.carbon.analytics.idp.client.local.models.LocalUser;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;

@Component(name="org.wso2.carbon.analytics.idp.client.local.LocalIdPClientFactory", immediate=true)
public class LocalIdPClientFactory
implements IdPClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LocalIdPClientFactory.class);
    private SSLConfig sslConfig;

    @Activate
    protected void activate(BundleContext bundleContext) {
        LOG.debug("Local IDP client factory activated.");
        if (this.sslConfig != null && this.sslConfig.isSSLConfigsExistInConfigProvider()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Overriding keystore and truststore configurations in carbon.sh with configuration values included in deployment.yaml");
            }
            this.sslConfig.exportSSLConfigsExistInConfigProvider();
        }
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        LOG.debug("Local IDP client factory deactivated.");
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        try {
            SSLConfiguration sslConfiguration = (SSLConfiguration)configProvider.getConfigurationObject(SSLConfiguration.class);
            this.sslConfig = new SSLConfig(sslConfiguration);
        }
        catch (ConfigurationException e) {
            LOG.error("Error occurred while initializing Local IDP client factory : " + e.getMessage(), (Throwable)e);
        }
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
    }

    @Override
    public String getType() {
        return "local";
    }

    @Override
    public IdPClient getIdPClient(IdPClientConfiguration idPClientConfiguration) throws IdPClientException {
        int refreshTimeout;
        int sessionTimeout;
        Map<String, String> properties = idPClientConfiguration.getProperties();
        try {
            sessionTimeout = Integer.parseInt(properties.getOrDefault("sessionTimeout", "3600"));
        }
        catch (NumberFormatException e) {
            throw new IdPClientException("Session timeout overriding property '" + properties.get("sessionTimeout") + "' is invalid.");
        }
        try {
            refreshTimeout = Integer.parseInt(properties.getOrDefault("refreshSessionTimeout", "86400"));
        }
        catch (NumberFormatException e) {
            throw new IdPClientException("Refresh session timeout overriding property '" + properties.get("refreshSessionTimeout") + "' is invalid.");
        }
        List<Role> roles = idPClientConfiguration.getUserManager().getUserStore().getRoles().stream().map(roleElement -> new Role(roleElement.getRole().getId(), roleElement.getRole().getDisplayName())).collect(Collectors.toList());
        String adminRoleDisplayName = idPClientConfiguration.getUserManager().getAdminRole();
        Role adminRole = roles.stream().filter(role -> role.getDisplayName().equalsIgnoreCase(adminRoleDisplayName)).findFirst().orElseThrow(() -> new IdPClientException("Admin role '" + adminRoleDisplayName + "' is not available in the User Store."));
        List<LocalUser> users = idPClientConfiguration.getUserManager().getUserStore().getUsers().stream().map(userElement -> {
            UserChildElement user = userElement.getUser();
            List<String> roleIdList = Arrays.asList(user.getRoles().replaceAll("\\s*", "").split(","));
            List<Role> userRolesFromId = roles.stream().filter(role -> roleIdList.contains(role.getId())).collect(Collectors.toList());
            return new LocalUser(user.getUsername(), user.getPassword().toCharArray(), user.getProperties(), userRolesFromId);
        }).collect(Collectors.toList());
        return new LocalIdPClient(sessionTimeout, refreshTimeout, users, roles, adminRole);
    }
}

