/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.external;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import feign.Response;
import feign.gson.GsonDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.AuthenticationException;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.core.models.Role;
import org.wso2.carbon.analytics.idp.client.core.models.User;
import org.wso2.carbon.analytics.idp.client.external.dao.OAuthAppDAO;
import org.wso2.carbon.analytics.idp.client.external.dto.DCRClientInfo;
import org.wso2.carbon.analytics.idp.client.external.dto.DCRError;
import org.wso2.carbon.analytics.idp.client.external.dto.OAuth2IntrospectionResponse;
import org.wso2.carbon.analytics.idp.client.external.dto.OAuth2TokenInfo;
import org.wso2.carbon.analytics.idp.client.external.dto.SCIMGroupList;
import org.wso2.carbon.analytics.idp.client.external.impl.DCRMServiceStub;
import org.wso2.carbon.analytics.idp.client.external.impl.OAuth2ServiceStubs;
import org.wso2.carbon.analytics.idp.client.external.impl.SCIM2ServiceStub;
import org.wso2.carbon.analytics.idp.client.external.models.ExternalSession;
import org.wso2.carbon.analytics.idp.client.external.models.OAuthApplicationInfo;
import org.wso2.carbon.analytics.idp.client.external.util.ExternalIdPClientUtil;
import org.wso2.carbon.utils.StringUtils;

public class ExternalIdPClient
implements IdPClient {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalIdPClient.class);
    private DCRMServiceStub dcrmServiceStub;
    private OAuth2ServiceStubs oAuth2ServiceStubs;
    private SCIM2ServiceStub scimServiceStub;
    private String baseUrl;
    private String authorizeEndpoint;
    private String grantType;
    private String signingAlgo;
    private String adminRoleDisplayName;
    private OAuthAppDAO oAuthAppDAO;
    private String defaultUserStore;
    private Cache<String, ExternalSession> tokenCache;
    private boolean isSSOEnabled;
    private String ssoLogoutURL;
    private String scope;
    private String jwksUrl;
    private boolean isFilteredGroupsEnabled = false;
    private Map<String, OAuthApplicationInfo> oAuthAppInfoMap;

    public ExternalIdPClient(String baseUrl, String authorizeEndpoint, String grantType, String signinAlgo, String adminRoleDisplayName, Map<String, OAuthApplicationInfo> oAuthAppInfoMap, int cacheTimeout, OAuthAppDAO oAuthAppDAO, DCRMServiceStub dcrmServiceStub, OAuth2ServiceStubs oAuth2ServiceStubs, SCIM2ServiceStub scimServiceStub, String defaultUserStore, boolean isSSOEnabled, String ssoLogoutURL, String scope, String jwksUrl) {
        this.baseUrl = baseUrl;
        this.authorizeEndpoint = authorizeEndpoint;
        this.grantType = grantType;
        this.signingAlgo = signinAlgo;
        this.oAuthAppInfoMap = oAuthAppInfoMap;
        this.adminRoleDisplayName = adminRoleDisplayName.contains("/") ? adminRoleDisplayName : defaultUserStore + "/" + adminRoleDisplayName;
        this.oAuthAppDAO = oAuthAppDAO;
        this.dcrmServiceStub = dcrmServiceStub;
        this.oAuth2ServiceStubs = oAuth2ServiceStubs;
        this.scimServiceStub = scimServiceStub;
        this.tokenCache = CacheBuilder.newBuilder().expireAfterWrite((long)cacheTimeout, TimeUnit.SECONDS).build();
        this.defaultUserStore = defaultUserStore;
        this.isSSOEnabled = isSSOEnabled;
        this.ssoLogoutURL = ssoLogoutURL;
        this.scope = scope;
        this.jwksUrl = jwksUrl;
    }

    public ExternalIdPClient(String baseUrl, String authorizeEndpoint, String grantType, String signinAlgo, String adminRoleDisplayName, Map<String, OAuthApplicationInfo> oAuthAppInfoMap, int cacheTimeout, OAuthAppDAO oAuthAppDAO, DCRMServiceStub dcrmServiceStub, OAuth2ServiceStubs oAuth2ServiceStubs, SCIM2ServiceStub scimServiceStub, String defaultUserStore, boolean isSSOEnabled, String ssoLogoutURL, String scope, String jwksUrl, boolean isFilteredGroupsEnabled) {
        this(baseUrl, authorizeEndpoint, grantType, signinAlgo, adminRoleDisplayName, oAuthAppInfoMap, cacheTimeout, oAuthAppDAO, dcrmServiceStub, oAuth2ServiceStubs, scimServiceStub, defaultUserStore, isSSOEnabled, ssoLogoutURL, scope, jwksUrl);
        this.isFilteredGroupsEnabled = isFilteredGroupsEnabled;
    }

    private static String removeCRLFCharacters(String str) {
        if (str != null) {
            str = str.replace('\n', '_').replace('\r', '_');
        }
        return str;
    }

    public void init(String kmUserName) throws IdPClientException {
        this.oAuthAppDAO.init();
        if (!this.oAuthAppDAO.tableExists()) {
            this.oAuthAppDAO.createTable();
        }
        for (Map.Entry<String, OAuthApplicationInfo> entry : this.oAuthAppInfoMap.entrySet()) {
            String appContext = entry.getKey();
            OAuthApplicationInfo oAuthApp = entry.getValue();
            String clientId = oAuthApp.getClientId();
            String clientSecret = oAuthApp.getClientSecret();
            String clientName = oAuthApp.getClientName();
            OAuthApplicationInfo persistedOAuthApp = this.oAuthAppDAO.getOAuthApp(clientName);
            if (persistedOAuthApp != null) {
                if (clientId != null || clientSecret != null) {
                    if (clientId != null) {
                        persistedOAuthApp.setClientId(clientId);
                    }
                    if (clientSecret != null) {
                        persistedOAuthApp.setClientSecret(clientSecret);
                    }
                    this.oAuthAppDAO.updateOAuthApp(persistedOAuthApp);
                }
                this.oAuthAppInfoMap.replace(appContext, persistedOAuthApp);
                continue;
            }
            if (clientId != null && clientSecret != null) {
                OAuthApplicationInfo newOAuthApp = new OAuthApplicationInfo(clientName, clientId, clientSecret);
                this.oAuthAppDAO.addOAuthApp(newOAuthApp);
                this.oAuthAppInfoMap.replace(appContext, newOAuthApp);
                continue;
            }
            this.registerApplication(appContext, clientName, kmUserName);
        }
    }

    @Override
    public List<Role> getAllRoles() throws IdPClientException {
        String selectedDomainsString = ExternalIdPClientUtil.getClientConfigurationProperty("kmUserStoreDomains");
        if (!StringUtils.isNullOrEmpty((String)selectedDomainsString)) {
            return this.getRolesByDomain(selectedDomainsString);
        }
        Response response = this.scimServiceStub.getAllGroups();
        return this.getRolesFromResponse(response);
    }

    private List<Role> getRolesByDomain(String selectedDomainsString) throws IdPClientException {
        HashSet<Role> rolesSet = new HashSet<Role>();
        String[] selectedDomains = selectedDomainsString.split("\\s*,\\s*");
        ArrayList<Role> allRolesList = new ArrayList<Role>();
        for (String domainName : selectedDomains) {
            Response response = this.scimServiceStub.getAllDomainGroups(domainName);
            List<Role> rolesListByDomain = this.getRolesFromResponse(response);
            rolesSet.addAll(rolesListByDomain);
        }
        allRolesList.addAll(rolesSet);
        return allRolesList;
    }

    private List<Role> getRolesFromResponse(Response response) throws IdPClientException {
        if (response == null) {
            String errorMessage = "Error occurred while retrieving groups. Error : Response is null.";
            LOG.error(errorMessage);
            throw new IdPClientException(errorMessage);
        }
        if (response.status() == 200) {
            try {
                SCIMGroupList scimGroups = (SCIMGroupList)new GsonDecoder().decode(response, (Type)((Object)SCIMGroupList.class));
                List<SCIMGroupList.SCIMGroupResources> resources = scimGroups.getResources();
                if (resources != null) {
                    return resources.stream().map(resource -> new Role(resource.getId(), resource.getDisplayName())).collect(Collectors.toList());
                }
                return new ArrayList<Role>();
            }
            catch (IOException e) {
                String errorMessage = "Error occurred while parsing the response when retrieving groups. Response: '" + response.body().toString();
                LOG.error(errorMessage, (Throwable)e);
                throw new IdPClientException(errorMessage, e);
            }
        }
        String errorMessage = "Error occurred while retrieving groups. HTTP error code: '" + response.status() + "'. Error Response: '" + response.body().toString() + "'.";
        LOG.error(errorMessage);
        throw new IdPClientException(errorMessage);
    }

    @Override
    public List<Role> getAllRolesOfTenant(String username) throws IdPClientException {
        return this.getAllRoles();
    }

    @Override
    public Role getAdminRole() throws IdPClientException {
        Response response = this.isFilteredGroupsEnabled ? this.scimServiceStub.getFilteredGroups("displayName Eq " + this.adminRoleDisplayName) : this.scimServiceStub.getAllGroups();
        if (response == null) {
            String errorMessage = "Error occurred while retrieving admin group '" + this.adminRoleDisplayName + "'. Error : Response is null.";
            LOG.error(errorMessage);
            throw new IdPClientException(errorMessage);
        }
        if (response.status() == 200) {
            try {
                SCIMGroupList scimGroups = (SCIMGroupList)new GsonDecoder().decode(response, (Type)((Object)SCIMGroupList.class));
                List<SCIMGroupList.SCIMGroupResources> resources = scimGroups.getResources();
                if (resources != null) {
                    for (SCIMGroupList.SCIMGroupResources resource : resources) {
                        if (!resource.getDisplayName().equalsIgnoreCase(this.adminRoleDisplayName)) continue;
                        return new Role(resource.getId(), resource.getDisplayName());
                    }
                }
                String errorMessage = "Error occurred while retrieving admin group '" + this.adminRoleDisplayName + "'. Admin role not found in the user store.";
                LOG.error(errorMessage);
                throw new IdPClientException(errorMessage);
            }
            catch (IOException e) {
                String errorMessage = "Error occurred while parsing the response when retrieving admin group '" + this.adminRoleDisplayName + "'. Response: '" + response.body().toString();
                LOG.error(errorMessage, (Throwable)e);
                throw new IdPClientException(errorMessage, e);
            }
        }
        String errorMessage = "Error occurred while retrieving admin group '" + this.adminRoleDisplayName + "'. HTTP error code: " + response.status() + " Error Response: " + response.body().toString();
        LOG.error(errorMessage);
        throw new IdPClientException(errorMessage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User getUser(String name) throws IdPClientException {
        if (name != null) {
            name = name.split("@carbon.super")[0];
        }
        try (Response response = this.scimServiceStub.searchUser("userName Eq " + name);){
            if (response == null) {
                String errorMessage = "Error occurred while retrieving user, '" + name + "'. Error : Response is null.";
                LOG.error(errorMessage);
                throw new IdPClientException(errorMessage);
            }
            JsonParser parser = new JsonParser();
            if (response.status() == 200) {
                JsonArray groups;
                String responseBody;
                BufferedReader bufferedReader;
                try (InputStream inputStream = response.body().asInputStream();){
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    Throwable throwable = null;
                    try {
                        responseBody = bufferedReader.readLine();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bufferedReader != null) {
                            if (throwable != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                bufferedReader.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new IdPClientException("Error occurred while converting response from the scim2 endpoint for user " + name + ".", e);
                }
                JsonObject userObject = parser.parse(responseBody).getAsJsonObject();
                JsonArray users = userObject.get("Resources").getAsJsonArray();
                if (users == null) {
                    bufferedReader = null;
                    return bufferedReader;
                }
                JsonObject user = users.get(0).getAsJsonObject();
                JsonElement groupsElement = user.get("groups");
                if (groupsElement != null) {
                    groups = groupsElement.getAsJsonArray();
                } else {
                    String id = user.get("id").getAsString();
                    Response userResponse = this.scimServiceStub.getUserByID(id);
                    user = parser.parse(userResponse.body().toString()).getAsJsonObject();
                    groups = user.get("groups").getAsJsonArray();
                }
                List<Role> allRolesInUserStore = this.getAllRoles();
                ArrayList groupNameList = new ArrayList();
                groups.forEach(group -> {
                    String groupName = group.getAsJsonObject().get("display").getAsString();
                    if (!groupName.contains("/")) {
                        groupName = this.defaultUserStore + "/" + groupName;
                    }
                    groupNameList.add(groupName);
                });
                List<Role> roles = allRolesInUserStore.stream().filter(role -> groupNameList.contains(role.getDisplayName())).collect(Collectors.toList());
                HashMap<String, String> properties = new HashMap<String, String>();
                Object object = user.entrySet().iterator();
                while (true) {
                    if (!object.hasNext()) {
                        object = new User(name, properties, roles);
                        return object;
                    }
                    Map.Entry entry = (Map.Entry)object.next();
                    if (((String)entry.getKey()).equals("userName") && ((String)entry.getKey()).equals("groups")) continue;
                    properties.put((String)entry.getKey(), ((JsonElement)entry.getValue()).toString());
                }
            }
            String errorMessage = "Error occurred while retrieving user, '" + name + "'. HTTP error code: " + response.status() + " Error Response: " + response.body().toString();
            LOG.error(errorMessage);
            throw new IdPClientException(errorMessage);
        }
        catch (Error e) {
            String errorMessage = "Error occurred while retrieving user, '" + name + "' from scim2 endpoint";
            LOG.error(errorMessage, (Throwable)e);
            throw new IdPClientException(errorMessage, e);
        }
    }

    @Override
    public List<Role> getUserRoles(String name) throws IdPClientException {
        User user;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving user roles by retrieving user '" + name + "'.");
        }
        if ((user = this.getUser(name)) != null) {
            return user.getRoles();
        }
        return new ArrayList<Role>();
    }

    @Override
    public Map<String, String> login(Map<String, String> properties) throws IdPClientException {
        HashMap<String, String> returnProperties = new HashMap<String, String>();
        String grantType = properties.getOrDefault("Grant_Type", this.grantType);
        String oAuthAppContext = properties.get("App_Name");
        if (!this.oAuthAppInfoMap.keySet().contains(oAuthAppContext)) {
            oAuthAppContext = "sp";
        }
        String username = properties.get("Username");
        if ("authorization_code".equals(grantType)) {
            String callbackUrl = properties.get("Callback_Url");
            returnProperties.put("Status", "redirection");
            returnProperties.put("Client_Id", this.oAuthAppInfoMap.get(oAuthAppContext).getClientId());
            returnProperties.put("Redirect_Url", this.authorizeEndpoint);
            returnProperties.put("Callback_Url", this.baseUrl + "/login/callback/" + callbackUrl);
            return returnProperties;
        }
        Response response = "password".equals(grantType) ? this.oAuth2ServiceStubs.getTokenServiceStub().generatePasswordGrantAccessToken(username, properties.get("Password"), this.oAuthAppInfoMap.get(oAuthAppContext).getClientId(), this.oAuthAppInfoMap.get(oAuthAppContext).getClientSecret()) : this.oAuth2ServiceStubs.getTokenServiceStub().generateRefreshGrantAccessToken(properties.get("Refresh_Token"), this.oAuthAppInfoMap.get(oAuthAppContext).getClientId(), this.oAuthAppInfoMap.get(oAuthAppContext).getClientSecret());
        if (response == null) {
            String error = "Error occurred while generating an access token for grant type '" + ExternalIdPClient.removeCRLFCharacters(grantType) + "'. Response is null.";
            LOG.error(error);
            throw new IdPClientException(error);
        }
        if (response.status() == 200) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("A new access token is successfully generated.");
            }
            try {
                OAuth2TokenInfo oAuth2TokenInfo = (OAuth2TokenInfo)new GsonDecoder().decode(response, (Type)((Object)OAuth2TokenInfo.class));
                returnProperties.put("Status", "success");
                returnProperties.put("Username", username);
                returnProperties.put("Access_Token", oAuth2TokenInfo.getAccessToken());
                returnProperties.put("Refresh_Token", oAuth2TokenInfo.getRefreshToken());
                returnProperties.put("Validity_Period", Long.toString(oAuth2TokenInfo.getExpiresIn()));
                if ("password".equals(grantType)) {
                    this.tokenCache.put((Object)oAuth2TokenInfo.getAccessToken(), (Object)new ExternalSession(username, oAuth2TokenInfo.getAccessToken()));
                }
                return returnProperties;
            }
            catch (IOException e) {
                String error = "Error occurred while parsing token response for user. Response: '" + response.body().toString() + "'.";
                LOG.error(error, (Throwable)e);
                throw new IdPClientException(error, e);
            }
        }
        if (response.status() == 401) {
            String invalidResponse = "Unable to get access token for the request with grant type : '" + grantType + "', for the user '" + username + "'.";
            LOG.error(invalidResponse);
            returnProperties.put("Status", "failure");
            returnProperties.put("Error", "Invalid_Credentials");
            returnProperties.put("Error_Description", invalidResponse);
            return returnProperties;
        }
        String errorMessage = "Token generation request failed. HTTP error code: '" + response.status() + "'. Error Response: '" + response.body().toString() + "'.";
        LOG.error(errorMessage);
        throw new IdPClientException(errorMessage);
    }

    public Map<String, String> authCodeLogin(String appContext, String code) throws IdPClientException {
        HashMap<String, String> returnProperties = new HashMap<String, String>();
        String oAuthAppContext = appContext.split("/\\|?")[0];
        if (!this.oAuthAppInfoMap.keySet().contains(oAuthAppContext)) {
            oAuthAppContext = "sp";
        }
        OAuthApplicationInfo oAuthApplicationInfo = this.oAuthAppInfoMap.get(oAuthAppContext);
        Response response = this.oAuth2ServiceStubs.getTokenServiceStub().generateAuthCodeGrantAccessToken(code, this.baseUrl + "/login/callback/" + oAuthAppContext, this.scope, oAuthApplicationInfo.getClientId(), oAuthApplicationInfo.getClientSecret());
        if (response == null) {
            String error = "Error occurred while generating an access token from code '" + code + "'. Response is null.";
            LOG.error(error);
            throw new IdPClientException(error);
        }
        if (response.status() == 200) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("A new accegiss token from code is successfully generated for the code '" + code + "'.");
            }
            try {
                OAuth2TokenInfo oAuth2TokenInfo = (OAuth2TokenInfo)new GsonDecoder().decode(response, (Type)((Object)OAuth2TokenInfo.class));
                returnProperties.put("Status", "success");
                returnProperties.put("Access_Token", oAuth2TokenInfo.getAccessToken());
                returnProperties.put("Refresh_Token", oAuth2TokenInfo.getRefreshToken());
                returnProperties.put("ID_Token", oAuth2TokenInfo.getIdToken());
                returnProperties.put("Validity_Period", Long.toString(oAuth2TokenInfo.getExpiresIn()));
                returnProperties.put("Redirect_Url", this.baseUrl + (this.baseUrl.endsWith("/") ? appContext : "/" + appContext));
                String authUser = null;
                if (this.oAuth2ServiceStubs.isIntrospectAvailable()) {
                    Response introspectTokenResponse = this.oAuth2ServiceStubs.getIntrospectionServiceStub().introspectAccessToken(oAuth2TokenInfo.getAccessToken());
                    if (introspectTokenResponse.status() == 200) {
                        OAuth2IntrospectionResponse introspectResponse = (OAuth2IntrospectionResponse)new GsonDecoder().decode(introspectTokenResponse, (Type)((Object)OAuth2IntrospectionResponse.class));
                        authUser = introspectResponse.getUsername();
                        returnProperties.put("Username", authUser);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Unable to get the username from introspection of the token '" + oAuth2TokenInfo.getAccessToken() + "'. Response : '" + introspectTokenResponse.toString());
                    }
                } else {
                    authUser = this.validateAndGetUserFromJWT(oAuth2TokenInfo.getAccessToken(), this.jwksUrl);
                    returnProperties.put("Username", authUser);
                }
                if (authUser != null) {
                    this.tokenCache.put((Object)oAuth2TokenInfo.getAccessToken(), (Object)new ExternalSession(authUser, oAuth2TokenInfo.getAccessToken()));
                }
                return returnProperties;
            }
            catch (IOException e) {
                String error = "Error occurred while parsing token response. Response : '" + response.body().toString() + "'";
                LOG.error(error, (Throwable)e);
                throw new IdPClientException(error, e);
            }
        }
        if (response.status() == 401) {
            String invalidResponse = "Unauthorized user for accessing token form code '" + code + "'. for the app context, '" + appContext + "'";
            returnProperties.put("Status", "failure");
            returnProperties.put("Error", "Invalid_Credentials");
            returnProperties.put("Error_Description", invalidResponse);
            return returnProperties;
        }
        String error = "Token generation request failed. HTTP error code: '" + response.status() + "'. Error Response Body: '" + response.body().toString() + "'.";
        LOG.error(error);
        throw new IdPClientException(error);
    }

    public Map<String, String> authCodeLogin(String appContext, String code, Map<String, String> properties) throws IdPClientException {
        throw new IdPClientException("Not implemented yet.");
    }

    @Override
    public Map<String, String> logout(Map<String, String> properties) throws IdPClientException {
        String token = properties.get("Access_Token");
        String oAuthAppContext = properties.getOrDefault("App_Name", "sp");
        if (!this.oAuthAppInfoMap.keySet().contains(oAuthAppContext)) {
            oAuthAppContext = "sp";
        }
        this.tokenCache.invalidate((Object)token);
        this.oAuth2ServiceStubs.getRevokeServiceStub().revokeAccessToken(token, this.oAuthAppInfoMap.get(oAuthAppContext).getClientId(), this.oAuthAppInfoMap.get(oAuthAppContext).getClientSecret());
        HashMap<String, String> returnProperties = new HashMap<String, String>();
        String idToken = properties.getOrDefault("ID_Token", null);
        if (!this.isSSOEnabled || idToken == null) {
            returnProperties.put("returnLogoutProperties", "false");
        } else {
            returnProperties.put("returnLogoutProperties", "true");
            String targetURIForRedirection = this.ssoLogoutURL.concat("?id_token_hint=").concat(idToken);
            returnProperties.put("externalLogoutUrl", targetURIForRedirection);
        }
        return returnProperties;
    }

    @Override
    public String authenticate(String token) throws AuthenticationException, IdPClientException {
        ExternalSession session = (ExternalSession)this.tokenCache.getIfPresent((Object)token);
        if (session != null) {
            return session.getUserName();
        }
        Response response = this.oAuth2ServiceStubs.getIntrospectionServiceStub().introspectAccessToken(token);
        if (response == null) {
            String error = "Error occurred while authenticating token '" + token + "'. Response is null.";
            LOG.error(error);
            throw new IdPClientException(error);
        }
        try {
            if (response.status() == 200) {
                OAuth2IntrospectionResponse introspectResponse = (OAuth2IntrospectionResponse)new GsonDecoder().decode(response, (Type)((Object)OAuth2IntrospectionResponse.class));
                if (introspectResponse.isActive()) {
                    String username = introspectResponse.getUsername();
                    this.tokenCache.put((Object)username, (Object)new ExternalSession(username, token));
                    return username;
                }
                throw new AuthenticationException("The token is not active");
            }
            if (response.status() == 400) {
                try {
                    DCRError error = (DCRError)new GsonDecoder().decode(response, (Type)((Object)DCRError.class));
                    throw new IdPClientException("Error occurred while introspecting the token. Error: " + error.getError() + ". Error Description: " + error.getErrorDescription() + ". Status Code: " + response.status());
                }
                catch (IOException e) {
                    throw new IdPClientException("Error occurred while parsing the Introspection error message.", e);
                }
            }
            throw new IdPClientException("Error occurred while authenticating. Error: '" + response.body().toString() + "'. Status Code: '" + response.status() + "'.");
        }
        catch (IOException e) {
            throw new IdPClientException("Error occurred while parsing the authentication response.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerApplication(String appContext, String clientName, String kmUserName) throws IdPClientException {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("authorization_code");
        grantTypes.add("refresh_token");
        String callBackUrl = clientName.equals("sp") ? "regexp=(" + this.baseUrl + "/login/callback/" + ".*)" : "regexp=(" + this.baseUrl + "/login/callback/" + appContext + ".*)";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating OAuth2 application of name '" + clientName + "'.");
        }
        DCRClientInfo dcrClientInfo = new DCRClientInfo();
        dcrClientInfo.setClientName(clientName);
        dcrClientInfo.setGrantTypes(grantTypes);
        dcrClientInfo.addCallbackUrl(callBackUrl);
        dcrClientInfo.setUserinfoSignedResponseAlg(this.signingAlgo);
        dcrClientInfo.setExtParamOwner(kmUserName);
        Response response = this.dcrmServiceStub.registerApplication(new Gson().toJson((Object)dcrClientInfo));
        if (response == null) {
            String error = "Error occurred while DCR application '" + dcrClientInfo + "' creation. Response is null.";
            LOG.error(error);
            throw new IdPClientException(error);
        }
        if (response.status() == 201) {
            try {
                DCRClientInfo dcrClientInfoResponse = (DCRClientInfo)new GsonDecoder().decode(response, (Type)((Object)DCRClientInfo.class));
                OAuthApplicationInfo oAuthApplicationInfo = new OAuthApplicationInfo(clientName, dcrClientInfoResponse.getClientId(), dcrClientInfoResponse.getClientSecret());
                this.oAuthAppInfoMap.replace(appContext, oAuthApplicationInfo);
                this.oAuthAppDAO.addOAuthApp(oAuthApplicationInfo);
                if (!LOG.isDebugEnabled()) return;
                LOG.debug("OAuth2 application created: " + oAuthApplicationInfo.toString());
                return;
            }
            catch (IOException e) {
                String error = "Error occurred while parsing the DCR application creation response message. Response: '" + response.body().toString() + "'.";
                LOG.error(error, (Throwable)e);
                throw new IdPClientException(error, e);
            }
        } else {
            if (response.status() == 400) {
                try {
                    DCRError error = (DCRError)new GsonDecoder().decode(response, (Type)((Object)DCRError.class));
                    String errorMessage = "Error occurred while DCR application creation. Error: " + error.getError() + ". Error Description: " + error.getErrorDescription() + ". Status Code: " + response.status();
                    LOG.error(errorMessage);
                    throw new IdPClientException(errorMessage);
                }
                catch (IOException e) {
                    String error = "Error occurred while parsing the DCR error message. Error: '" + response.body().toString() + "'.";
                    LOG.error(error, (Throwable)e);
                    throw new IdPClientException(error, e);
                }
            }
            String error = "Error occurred while DCR application creation. Error: '" + response.body().toString() + "'. Status Code: '" + response.status() + "'.";
            LOG.error(error);
            throw new IdPClientException(error);
        }
    }

    private String validateAndGetUserFromJWT(String jwtToken, String jwksUrl) {
        try {
            JsonParser parser = new JsonParser();
            DecodedJWT jwt = JWT.decode(jwtToken);
            UrlJwkProvider provider = new UrlJwkProvider(new URL(jwksUrl));
            Jwk jwk = provider.get(jwt.getKeyId());
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)jwk.getPublicKey(), null);
            algorithm.verify(jwt);
            String[] jwtTokenParts = jwtToken.split("\\.");
            String jwtBody = new String(Base64.getDecoder().decode(jwtTokenParts[1]), StandardCharsets.UTF_8);
            JsonObject jwtBodyJson = parser.parse(jwtBody).getAsJsonObject();
            if (null != jwtBodyJson.get("preferred_username") && !jwtBodyJson.get("preferred_username").getAsString().equals("")) {
                return jwtBodyJson.get("preferred_username").getAsString();
            }
            if (null != jwtBodyJson.get("unique_name") && !jwtBodyJson.get("unique_name").getAsString().equals("")) {
                return jwtBodyJson.get("unique_name").getAsString();
            }
            return jwt.getSubject();
        }
        catch (SignatureVerificationException e) {
            LOG.error("Signature validation failed ", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Error occurred while processing ", (Throwable)e);
        }
        return null;
    }
}

