/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.core.utils;

import org.wso2.carbon.analytics.idp.client.core.utils.config.SSLConfiguration;
import org.wso2.carbon.utils.StringUtils;

public class SSLConfig {
    private boolean sslConfigsExistInConfigProvider = false;
    private final String keyStorePassword;
    private final String trustStorePassword;
    private final String keyStoreLocation;
    private final String trustStoreLocation;

    public SSLConfig(SSLConfiguration sslConfiguration) {
        this.keyStorePassword = sslConfiguration.getKeyStorePassword();
        this.trustStorePassword = sslConfiguration.getTrustStorePassword();
        this.keyStoreLocation = sslConfiguration.getKeyStoreLocation();
        this.trustStoreLocation = sslConfiguration.getTrustStoreLocation();
        if (!(StringUtils.isNullOrEmptyAfterTrim((String)this.keyStorePassword) || StringUtils.isNullOrEmptyAfterTrim((String)this.keyStoreLocation) || StringUtils.isNullOrEmptyAfterTrim((String)this.trustStorePassword) || StringUtils.isNullOrEmptyAfterTrim((String)this.trustStoreLocation))) {
            this.sslConfigsExistInConfigProvider = true;
        }
    }

    public boolean isSSLConfigsExistInConfigProvider() {
        return this.sslConfigsExistInConfigProvider;
    }

    public void exportSSLConfigsExistInConfigProvider() {
        System.setProperty("javax.net.ssl.keyStorePassword", this.keyStorePassword);
        System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
        System.setProperty("javax.net.ssl.keyStore", this.keyStoreLocation);
        System.setProperty("javax.net.ssl.trustStore", this.trustStoreLocation);
    }
}

