/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.core.utils;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.core.spi.IdPClientFactory;
import org.wso2.carbon.analytics.idp.client.core.utils.config.IdPClientConfiguration;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;

public class IdPServiceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IdPServiceUtils.class);

    public static IdPClient getIdPClient(ConfigProvider configProvider, Map<String, IdPClientFactory> idPClientFactoryMap) throws IdPClientException {
        IdPClient idPClient;
        try {
            IdPClientConfiguration idPClientConfiguration;
            if (configProvider.getConfigurationObject("authentication") != null) {
                LOG.debug("Extract IdP Client configs from under 'authentication' namespace.");
                idPClientConfiguration = (IdPClientConfiguration)configProvider.getConfigurationObject("authentication", IdPClientConfiguration.class);
            } else if (configProvider.getConfigurationObject("auth.configs") != null) {
                LOG.debug("Extract IdP Client configs from under 'auth.configs' namespace.");
                idPClientConfiguration = (IdPClientConfiguration)configProvider.getConfigurationObject(IdPClientConfiguration.class);
            } else {
                LOG.info("Enabling default IdPClient Local User Store as configuration is not overridden.");
                idPClientConfiguration = new IdPClientConfiguration();
            }
            IdPClientFactory idPClientFactory = idPClientFactoryMap.get(idPClientConfiguration.getType());
            if (idPClientFactory == null) {
                throw new IdPClientException("No idPClientFactory found for type: " + idPClientConfiguration.getType());
            }
            idPClient = idPClientFactory.getIdPClient(idPClientConfiguration);
            LOG.info("IdP client of type '" + idPClientConfiguration.getType() + "' is started.");
        }
        catch (ConfigurationException e) {
            throw new IdPClientException("Error in reading 'auth.configs' from file.", e);
        }
        return idPClient;
    }
}

