/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.core.spi.IdPClientFactory;
import org.wso2.carbon.analytics.idp.client.core.utils.IdPServiceUtils;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.startupresolver.StartupServiceUtils;

@Component(name="IdPClientServiceComponent", immediate=true, property={"componentName=sp-idp-service"})
public class IdPClientServiceComponent
implements RequiredCapabilityListener {
    public static final String COMPONENT_NAME = "sp-idp-service";
    private static final Logger LOG = LoggerFactory.getLogger(IdPClientServiceComponent.class);
    private BundleContext bundleContext;
    private ServiceRegistration idpClientRegistrationService;
    private ConfigProvider configProvider;
    private Map<String, IdPClientFactory> idPClientFactoryHashMap = new HashMap<String, IdPClientFactory>();

    @Activate
    protected void start(BundleContext bundleContext) {
        LOG.debug("IdPClient service component is activated.");
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void stop() {
        LOG.debug("IdPClient service component is deactivated.");
        if (this.idpClientRegistrationService != null) {
            this.idpClientRegistrationService.unregister();
        }
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
        this.configProvider = null;
    }

    @Reference(name="sp-idp-factory", service=IdPClientFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterReader")
    protected void registerReader(IdPClientFactory idPClientFactory) {
        this.idPClientFactoryHashMap.put(idPClientFactory.getType(), idPClientFactory);
        StartupServiceUtils.updateServiceCache((String)COMPONENT_NAME, IdPClientFactory.class);
    }

    protected void unregisterReader(IdPClientFactory idPClientFactory) {
        this.idPClientFactoryHashMap.remove(idPClientFactory.getType());
    }

    public void onAllRequiredCapabilitiesAvailable() {
        LOG.debug("IdPClient service component is started.");
        try {
            IdPClient idPClient = IdPServiceUtils.getIdPClient(this.configProvider, this.idPClientFactoryHashMap);
            this.idpClientRegistrationService = this.bundleContext.registerService(IdPClient.class.getName(), (Object)idPClient, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("IdPClient of class '" + idPClient.getClass().getName() + "' is registered as a service.");
            }
        }
        catch (IdPClientException e) {
            LOG.error("Error occurred while initializing IdP Client: " + e.getMessage(), (Throwable)e);
        }
    }
}

