/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.idp.client.core.internal;

import feign.Client;
import feign.Feign;
import feign.Request;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.gson.GsonDecoder;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.AnalyticsHttpClientBuilderService;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;

@Component(service={AnalyticsHttpClientBuilderService.class}, immediate=true)
public class AnalyticsHttpClientBuilderServiceImpl
implements AnalyticsHttpClientBuilderService {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsHttpClientBuilderServiceImpl.class);
    private boolean isHostnameVerifierEnabled;

    @Activate
    protected void start(BundleContext bundleContext) throws Exception {
        LOG.debug("AnalyticsHttpClientBuilderServiceImpl Service Component Activated");
    }

    @Deactivate
    protected void stop() {
        LOG.debug("AnalyticsHttpClientBuilderServiceImpl Service Component Deactivated");
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        CarbonConfiguration carbonConfiguration = null;
        try {
            carbonConfiguration = (CarbonConfiguration)configProvider.getConfigurationObject(CarbonConfiguration.class);
            this.isHostnameVerifierEnabled = carbonConfiguration.isHostnameVerificationEnabled();
        }
        catch (ConfigurationException e) {
            LOG.error("Error occurred while initializing AnalyticsHttpClientBuilderService: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
    }

    @Override
    public Client newDefaultClientInstance() {
        if (!this.isHostnameVerifierEnabled) {
            return new Client.Default(null, (hostName, sslSession) -> true);
        }
        return new Client.Default(null, null);
    }

    @Override
    public <T> T build(String username, String password, int connectTimeoutMillis, int readTimeoutMillis, Class<T> target, String url) {
        return Feign.builder().requestInterceptor(new BasicAuthRequestInterceptor(username, password)).encoder(new Encoder.Default()).decoder(new Decoder.Default()).options(new Request.Options(connectTimeoutMillis, readTimeoutMillis)).client(this.newDefaultClientInstance()).target(target, url);
    }

    @Override
    public <T> T buildWithFormEncoder(String username, String password, int connectTimeoutMillis, int readTimeoutMillis, Class<T> target, String url) {
        return Feign.builder().requestInterceptor(new BasicAuthRequestInterceptor(username, password)).encoder(new FormEncoder()).decoder(new Decoder.Default()).options(new Request.Options(connectTimeoutMillis, readTimeoutMillis)).client(this.newDefaultClientInstance()).target(target, url);
    }

    @Override
    public <T> T buildWithoutInterceptor(int connectTimeoutMillis, int readTimeoutMillis, Class<T> target, String url) {
        return Feign.builder().encoder(new Encoder.Default()).decoder(new GsonDecoder()).options(new Request.Options(connectTimeoutMillis, readTimeoutMillis)).client(this.newDefaultClientInstance()).target(target, url);
    }
}

