/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.common.jmx.agent.tasks;

import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.Profile;
import org.wso2.carbon.analytics.common.jmx.agent.tasks.JmxTaskUtils;
import org.wso2.carbon.analytics.common.jmx.agent.tasks.internal.JmxTaskServiceComponent;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;

public class JmxTaskAdmin {
    private static final Log log = LogFactory.getLog(JmxTaskAdmin.class);

    public void scheduleProfile(Profile profile) throws AxisFault {
        try {
            TaskManager tm = JmxTaskServiceComponent.getTaskService().getTaskManager("JMX_SERVICE_TASK");
            TaskInfo taskInfo = JmxTaskUtils.convert(profile);
            tm.registerTask(taskInfo);
            tm.scheduleTask(taskInfo.getName());
            log.info((Object)(profile.getName() + " enabled."));
        }
        catch (TaskException e) {
            log.error((Object)e);
        }
    }

    public void removeProfile(String profileName) throws AxisFault {
        try {
            TaskManager tm = JmxTaskServiceComponent.getTaskService().getTaskManager("JMX_SERVICE_TASK");
            tm.deleteTask(profileName);
            log.info((Object)(profileName + " disabled."));
        }
        catch (TaskException e) {
            log.error((Object)e);
        }
    }

    public boolean isTaskScheduled(String profileName) throws AxisFault {
        try {
            TaskManager tm = JmxTaskServiceComponent.getTaskService().getTaskManager("JMX_SERVICE_TASK");
            return tm.isTaskScheduled(profileName);
        }
        catch (TaskException e) {
            log.error((Object)e);
            return false;
        }
    }

    public boolean profileExists(String profileName) {
        try {
            TaskManager tm = JmxTaskServiceComponent.getTaskService().getTaskManager("JMX_SERVICE_TASK");
            List taskInfoList = tm.getAllTasks();
            for (TaskInfo taskInfo : taskInfoList) {
                if (!taskInfo.getName().equalsIgnoreCase(profileName)) continue;
                return true;
            }
        }
        catch (TaskException e) {
            log.error((Object)e);
        }
        return false;
    }
}

