/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.common.jmx.agent.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.common.jmx.agent.JmxAgent;
import org.wso2.carbon.analytics.common.jmx.agent.JmxConstant;
import org.wso2.carbon.analytics.common.jmx.agent.PublisherUtil;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.JmxConnectionException;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.JmxMBeanException;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.JmxProfileException;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.ProfileDoesNotExistException;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.MBean;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.MBeanAttribute;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.MBeanAttributeProperty;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.Profile;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.ProfileManager;
import org.wso2.carbon.analytics.common.jmx.agent.tasks.internal.JmxTaskServiceComponent;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.ntask.core.AbstractTask;

public class JmxTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(JmxTask.class);
    private static final String EVENT_TYPE = "externalEvent";
    private static final String STR_NULL = "NULL";
    private static final char FORWARD_SLASH = '/';
    static final String STREAM_NAME_PREFIX = "jmx.agent.";

    public void execute() {
        Profile profile;
        if (log.isDebugEnabled()) {
            log.info((Object)("Running the profile : " + (String)this.getProperties().get(JmxConstant.JMX_PROFILE_NAME)));
        }
        Map dataMap = this.getProperties();
        String profileName = (String)dataMap.get(JmxConstant.JMX_PROFILE_NAME);
        try {
            profile = new ProfileManager().getProfile(profileName);
        }
        catch (ProfileDoesNotExistException e) {
            log.error((Object)("Profile does not exist:" + profileName), (Throwable)e);
            return;
        }
        catch (JmxProfileException e) {
            log.error((Object)"Exception occurred: ", (Throwable)e);
            return;
        }
        if (profile != null) {
            try {
                JmxAgent jmxAgent = new JmxAgent(profile);
                String streamName = STREAM_NAME_PREFIX + profile.getName();
                String version = Integer.toString(profile.getVersion()) + ".0.0";
                StreamDefinition streamDefinition = this.createStreamDefinition(streamName, version, jmxAgent);
                this.publishData(streamDefinition, jmxAgent, profileName);
            }
            catch (MalformedStreamDefinitionException e) {
                log.error((Object)e.getErrorMessage(), (Throwable)e);
            }
            catch (JmxConnectionException | JmxMBeanException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void publishData(StreamDefinition streamDef, JmxAgent jmxAgent, String profileName) {
        EventStreamService eventStreamService;
        ArrayList<Object> arrayList = this.getMBeansDetail(jmxAgent);
        if (arrayList == null) {
            return;
        }
        String host = PublisherUtil.getHostAddress();
        if (jmxAgent.getProfile() != null && jmxAgent.getProfile().getUrl() != null) {
            host = jmxAgent.getProfile().getUrl().substring(18, jmxAgent.getProfile().getUrl().indexOf(47, 19));
        }
        if ((eventStreamService = JmxTaskServiceComponent.getEventStreamService()) != null) {
            try {
                if (eventStreamService.getStreamDefinition(streamDef.getStreamId()) == null) {
                    eventStreamService.addEventStreamDefinition(streamDef);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Added stream definition to event publisher service.");
                    }
                }
            }
            catch (EventStreamConfigurationException e) {
                log.error((Object)("Error in adding stream definition to service:" + e.getMessage()), (Throwable)e);
            }
            Event tracingEvent = new Event();
            tracingEvent.setTimeStamp(System.currentTimeMillis());
            tracingEvent.setStreamId(streamDef.getStreamId());
            Object[] metaInfo = new Object[]{EVENT_TYPE, host};
            tracingEvent.setMetaData(metaInfo);
            tracingEvent.setPayloadData(arrayList.toArray());
            eventStreamService.publish(tracingEvent);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully published event");
            }
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("jmx Event published for " + profileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Object> getMBeansDetail(JmxAgent jmxAgent) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        JMXConnector jmxConnector = null;
        try {
            MBean[] mBeans;
            jmxConnector = jmxAgent.openJmxConnection();
            for (MBean mBean : mBeans = jmxAgent.getProfile().getSelectedMBeans()) {
                for (MBeanAttribute mBeanAttribute : mBean.getAttributes()) {
                    Object attrValue;
                    if (mBeanAttribute.getProperties() != null) {
                        CompositeData cd = (CompositeData)jmxAgent.getAttribute(jmxConnector, mBean.getMBeanName(), mBeanAttribute.getAttributeName());
                        for (MBeanAttributeProperty mBeanAttributeProperty : mBeanAttribute.getProperties()) {
                            attrValue = cd.get(mBeanAttributeProperty.getPropertyName());
                            this.addMBeanDetail(arrayList, attrValue);
                        }
                        continue;
                    }
                    attrValue = jmxAgent.getAttribute(jmxConnector, mBean.getMBeanName(), mBeanAttribute.getAttributeName());
                    this.addMBeanDetail(arrayList, attrValue);
                }
            }
        }
        catch (JmxConnectionException e) {
            log.error((Object)"Jmx Connection Exception", (Throwable)e);
            ArrayList<Object> arrayList2 = null;
            return arrayList2;
        }
        catch (JmxMBeanException e) {
            log.error((Object)"Jmx MBean exception", (Throwable)e);
            ArrayList<Object> arrayList3 = null;
            return arrayList3;
        }
        finally {
            if (jmxConnector != null) {
                try {
                    jmxAgent.closeJmxConnection(jmxConnector);
                }
                catch (JmxConnectionException e) {
                    log.error((Object)"Unable to close JMX connection.", (Throwable)e);
                }
            }
        }
        return arrayList;
    }

    private void addMBeanDetail(ArrayList<Object> arrayList, Object attrValue) {
        if (attrValue == null) {
            arrayList.add(STR_NULL);
        } else if (attrValue instanceof String || attrValue instanceof Integer || attrValue instanceof Long || attrValue instanceof Double || attrValue instanceof Boolean || attrValue instanceof Float) {
            arrayList.add(attrValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamDefinition createStreamDefinition(String streamName, String version, JmxAgent jmxAgent) throws MalformedStreamDefinitionException, JmxConnectionException, JmxMBeanException {
        StreamDefinition streamDefinition = new StreamDefinition(streamName, version);
        streamDefinition.setDescription("JMX monitoring data");
        streamDefinition.setNickName("JMX");
        List<Attribute> metaDataList = this.getMetaAttributeList();
        streamDefinition.setMetaData(metaDataList);
        ArrayList<Attribute> payloadDataList = new ArrayList<Attribute>();
        JMXConnector jmxConnector = null;
        try {
            MBean[] mBeans;
            jmxConnector = jmxAgent.openJmxConnection();
            for (MBean mBean : mBeans = jmxAgent.getProfile().getSelectedMBeans()) {
                for (MBeanAttribute mBeanAttribute : mBean.getAttributes()) {
                    Object attrValue;
                    if (mBeanAttribute.getProperties() != null) {
                        CompositeData cd = (CompositeData)jmxAgent.getAttribute(jmxConnector, mBean.getMBeanName(), mBeanAttribute.getAttributeName());
                        for (MBeanAttributeProperty mBeanAttributeProperty : mBeanAttribute.getProperties()) {
                            attrValue = cd.get(mBeanAttributeProperty.getPropertyName());
                            payloadDataList.add(this.getColumnName(attrValue, mBeanAttributeProperty.getAliasName()));
                        }
                        continue;
                    }
                    attrValue = jmxAgent.getAttribute(jmxConnector, mBean.getMBeanName(), mBeanAttribute.getAttributeName());
                    payloadDataList.add(this.getColumnName(attrValue, mBeanAttribute.getAliasName()));
                }
            }
        }
        finally {
            if (jmxConnector != null) {
                try {
                    jmxAgent.closeJmxConnection(jmxConnector);
                }
                catch (JmxConnectionException e) {
                    log.error((Object)"Unable to close Jmx connection.", (Throwable)e);
                }
            }
        }
        streamDefinition.setPayloadData(payloadDataList);
        return streamDefinition;
    }

    private List<Attribute> getMetaAttributeList() {
        ArrayList<Attribute> metaDataList = new ArrayList<Attribute>();
        metaDataList.add(new Attribute("clientType", AttributeType.STRING));
        metaDataList.add(new Attribute("host", AttributeType.STRING));
        return metaDataList;
    }

    private Attribute getColumnName(Object attrValue, String alias) {
        AttributeType attributeType = null;
        if (attrValue instanceof String) {
            attributeType = AttributeType.STRING;
        } else if (attrValue instanceof Integer) {
            attributeType = AttributeType.INT;
        } else if (attrValue instanceof Long) {
            attributeType = AttributeType.LONG;
        } else if (attrValue instanceof Double) {
            attributeType = AttributeType.DOUBLE;
        } else if (attrValue instanceof Boolean) {
            attributeType = AttributeType.BOOL;
        } else if (attrValue instanceof Float) {
            attributeType = AttributeType.FLOAT;
        } else {
            log.error((Object)("Missed attribute in stream def: " + alias));
        }
        return new Attribute(alias, attributeType);
    }
}

