/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.common.jmx.agent.profiles;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.JmxProfileException;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.ProfileAlreadyExistsException;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.ProfileDoesNotExistException;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.MBean;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.MBeanAttribute;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.MBeanAttributeProperty;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.Profile;
import org.wso2.carbon.analytics.common.jmx.agent.tasks.internal.JmxTaskServiceComponent;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.utils.CarbonUtils;

public class ProfileManager {
    private static final Log log = LogFactory.getLog(ProfileManager.class);
    static final String PROFILE_SAVE_REG_LOCATION = "repository/components/org.wso2.carbon.publish.jmx.agent/";
    private Registry registry;

    public ProfileManager() {
        RegistryService registryService = JmxTaskServiceComponent.getRegistryService();
        TenantRegistryLoader tenantRegistryLoader = JmxTaskServiceComponent.getTenantRegistryLoader();
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            tenantRegistryLoader.loadTenantRegistry(tenantId);
            this.registry = registryService.getGovernanceSystemRegistry(tenantId);
        }
        catch (RegistryException e) {
            log.error((Object)("Error obtaining the registry " + e.getMessage()), (Throwable)e);
        }
    }

    private Profile encryptData(Profile profile) throws CryptoException {
        String password = profile.getPass();
        String cipherT = CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(password.getBytes());
        profile.setPass(cipherT);
        return profile;
    }

    private Profile decryptData(Profile profile) throws CryptoException {
        String cipherT = profile.getPass();
        byte[] decodedBArr = Base64.decodeBase64((byte[])cipherT.getBytes());
        byte[] passwordBArr = CryptoUtil.getDefaultCryptoUtil().decrypt(decodedBArr);
        String password = new String(passwordBArr);
        profile.setPass(password);
        return profile;
    }

    public boolean addProfile(Profile profile) throws ProfileAlreadyExistsException, JmxProfileException {
        boolean resourceExist;
        String path = PROFILE_SAVE_REG_LOCATION + profile.getName();
        try {
            resourceExist = this.registry.resourceExists(path);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to access to registry", (Throwable)e);
            throw new JmxProfileException("Unable to access to registry", e);
        }
        if (resourceExist) {
            String error = "The profile " + profile.getName() + " already exists.";
            log.error((Object)error);
            throw new ProfileAlreadyExistsException(error);
        }
        try {
            profile = this.encryptData(profile);
        }
        catch (CryptoException e) {
            log.error((Object)"Unable to encrypt profile", (Throwable)e);
            throw new JmxProfileException("Unable to encrypt profile", e);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Profile.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.marshal((Object)profile, (OutputStream)byteArrayOutputStream);
        }
        catch (JAXBException e) {
            log.error((Object)("JAXB marshalling exception :" + e.getMessage()), (Throwable)e);
            throw new JmxProfileException("JAXB marshalling exception :" + e.getMessage(), e);
        }
        try {
            Resource res = this.registry.newResource();
            res.setContent((Object)byteArrayOutputStream.toString());
            this.registry.put(path, res);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to save in registry", (Throwable)e);
            throw new JmxProfileException("Unable to save in registry", e);
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            log.warn((Object)"Unable to close byte stream ...", (Throwable)e);
        }
        return true;
    }

    public Profile getProfile(String profileName) throws ProfileDoesNotExistException, JmxProfileException {
        Profile profile;
        ByteArrayInputStream byteArrayInputStream;
        String path = PROFILE_SAVE_REG_LOCATION + profileName;
        try {
            if (!this.registry.resourceExists(path)) {
                String error = "The profile " + profileName + " does not exist.";
                log.error((Object)error);
                throw new ProfileDoesNotExistException(error);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to access to registry", (Throwable)e);
            throw new JmxProfileException("Unable to access to registry", e);
        }
        try {
            Resource res = this.registry.get(path);
            byteArrayInputStream = new ByteArrayInputStream((byte[])res.getContent());
        }
        catch (RegistryException e) {
            log.error((Object)("Unable to get profile :" + e.getMessage()), (Throwable)e);
            throw new JmxProfileException("Unable to get profile :" + e.getMessage(), e);
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Profile.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            profile = (Profile)jaxbUnmarshaller.unmarshal((InputStream)byteArrayInputStream);
        }
        catch (JAXBException e) {
            log.error((Object)("JAXB unmarshalling exception :" + e.getMessage()), (Throwable)e);
            throw new JmxProfileException("JAXB unmarshalling exception :" + e.getMessage(), e);
        }
        try {
            profile = this.decryptData(profile);
        }
        catch (CryptoException e) {
            log.error((Object)"Unable to decrypt profile", (Throwable)e);
            throw new JmxProfileException("Unable to decrypt profile", e);
        }
        try {
            byteArrayInputStream.close();
        }
        catch (IOException e) {
            log.warn((Object)"Unable to close byte stream ...", (Throwable)e);
        }
        return profile;
    }

    public boolean updateProfile(Profile profile) throws ProfileDoesNotExistException, JmxProfileException {
        String path = PROFILE_SAVE_REG_LOCATION + profile.getName();
        try {
            if (!this.registry.resourceExists(path)) {
                String error = "Cannot Update: The profile " + profile.getName() + " does not exist.";
                log.error((Object)error);
                throw new ProfileDoesNotExistException(error);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to access to registry", (Throwable)e);
            throw new JmxProfileException("Unable to access to registry", e);
        }
        try {
            profile = this.encryptData(profile);
        }
        catch (CryptoException e) {
            log.error((Object)"Unable to encrypt profile", (Throwable)e);
            throw new JmxProfileException("Unable to encrypt profile", e);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Profile.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.marshal((Object)profile, (OutputStream)byteArrayOutputStream);
        }
        catch (JAXBException e) {
            log.error((Object)("JAXB unmarshalling exception :" + e.getMessage()), (Throwable)e);
            throw new JmxProfileException("JAXB unmarshalling exception :" + e.getMessage(), e);
        }
        try {
            Resource res = this.registry.newResource();
            res.setContent((Object)byteArrayOutputStream.toString());
            this.registry.delete(path);
            this.registry.put(path, res);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to save in registry", (Throwable)e);
            throw new JmxProfileException("Unable to save in registry", e);
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            log.warn((Object)"Unable to close byte stream ...", (Throwable)e);
        }
        return true;
    }

    public boolean deleteProfile(String profileName) throws ProfileDoesNotExistException, JmxProfileException {
        String path = PROFILE_SAVE_REG_LOCATION + profileName;
        try {
            if (!this.registry.resourceExists(path)) {
                String error = "Cannot Delete: The profile " + profileName + " does not exist.";
                log.error((Object)error);
                throw new ProfileDoesNotExistException(error);
            }
            this.registry.delete(path);
            return true;
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to delete profile", (Throwable)e);
            throw new JmxProfileException("Unable to to delete profile", e);
        }
    }

    public Profile[] getAllProfiles() throws JmxProfileException {
        Profile[] profiles;
        block10: {
            profiles = null;
            try {
                if (!this.registry.resourceExists(PROFILE_SAVE_REG_LOCATION)) break block10;
                Resource folder = this.registry.get(PROFILE_SAVE_REG_LOCATION);
                String[] content = (String[])folder.getContent();
                profiles = new Profile[content.length];
                int counter = 0;
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Profile.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                for (String path : content) {
                    Profile profile;
                    ByteArrayInputStream byteArrayInputStream;
                    Resource res = this.registry.get(path);
                    try {
                        byteArrayInputStream = new ByteArrayInputStream((byte[])res.getContent());
                        profile = (Profile)jaxbUnmarshaller.unmarshal((InputStream)byteArrayInputStream);
                    }
                    catch (JAXBException e) {
                        log.error((Object)("JAXB unmarshalling exception :" + e.getMessage()), (Throwable)e);
                        throw new JmxProfileException("JAXB unmarshalling exception :" + e.getMessage(), e);
                    }
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Unable to close byte stream ...", (Throwable)e);
                    }
                    try {
                        profile = this.decryptData(profile);
                    }
                    catch (CryptoException e) {
                        log.error((Object)"Unable to decrypt profile", (Throwable)e);
                        throw new JmxProfileException("Unable to decrypt profile", e);
                    }
                    profiles[counter++] = profile;
                }
            }
            catch (RegistryException e) {
                log.error((Object)"Unable to access to registry", (Throwable)e);
                throw new JmxProfileException("Unable to access to registry", e);
            }
            catch (JAXBException e) {
                log.error((Object)("JAXB unmarshalling exception :" + e.getMessage()), (Throwable)e);
                throw new JmxProfileException("JAXB unmarshalling exception :" + e.getMessage(), e);
            }
        }
        return profiles;
    }

    public Profile createToolboxProfile() throws ProfileAlreadyExistsException, JmxProfileException {
        Profile tbProfile = new Profile();
        tbProfile.setName("toolbox");
        tbProfile.setVersion(1);
        tbProfile.setCronExpression("0/2 * * ? * *");
        int rmiServerPort = 11111 + ProfileManager.getPortOffset();
        int rmiRegistryPort = 9999 + ProfileManager.getPortOffset();
        tbProfile.setUrl("service:jmx:rmi://localhost:" + rmiServerPort + "/jndi/rmi://localhost:" + rmiRegistryPort + "/jmxrmi");
        tbProfile.setUserName("admin");
        tbProfile.setPass("admin");
        MBean[] mBeans = new MBean[4];
        MBean memoryMBean = new MBean();
        memoryMBean.setMBeanName("java.lang:type=Memory");
        MBeanAttribute[] memoryMBeanAttributes = new MBeanAttribute[2];
        MBeanAttribute heapMemoryAttribute = new MBeanAttribute();
        heapMemoryAttribute.setAttributeName("HeapMemoryUsage");
        MBeanAttributeProperty[] heapMemoryMBeanAttributeProperties = new MBeanAttributeProperty[4];
        MBeanAttributeProperty heapInit = new MBeanAttributeProperty();
        heapInit.setPropertyName("init");
        heapInit.setAliasName("heap_mem_init");
        heapMemoryMBeanAttributeProperties[0] = heapInit;
        MBeanAttributeProperty heapMax = new MBeanAttributeProperty();
        heapMax.setPropertyName("max");
        heapMax.setAliasName("heap_mem_max");
        heapMemoryMBeanAttributeProperties[1] = heapMax;
        MBeanAttributeProperty heapUsed = new MBeanAttributeProperty();
        heapUsed.setPropertyName("used");
        heapUsed.setAliasName("heap_mem_used");
        heapMemoryMBeanAttributeProperties[2] = heapUsed;
        MBeanAttributeProperty heapCommitted = new MBeanAttributeProperty();
        heapCommitted.setPropertyName("committed");
        heapCommitted.setAliasName("heap_mem_committed");
        heapMemoryMBeanAttributeProperties[3] = heapCommitted;
        heapMemoryAttribute.setProperties(heapMemoryMBeanAttributeProperties);
        memoryMBeanAttributes[0] = heapMemoryAttribute;
        MBeanAttribute nonHeapMemoryAttribute = new MBeanAttribute();
        nonHeapMemoryAttribute.setAttributeName("NonHeapMemoryUsage");
        MBeanAttributeProperty[] nonHeapMBeanAttributeProperties = new MBeanAttributeProperty[4];
        MBeanAttributeProperty nonHeapInit = new MBeanAttributeProperty();
        nonHeapInit.setPropertyName("init");
        nonHeapInit.setAliasName("non_heap_mem_init");
        nonHeapMBeanAttributeProperties[0] = nonHeapInit;
        MBeanAttributeProperty nonHeapMax = new MBeanAttributeProperty();
        nonHeapMax.setPropertyName("max");
        nonHeapMax.setAliasName("non_heap_mem_max");
        nonHeapMBeanAttributeProperties[1] = nonHeapMax;
        MBeanAttributeProperty nonHeapUsed = new MBeanAttributeProperty();
        nonHeapUsed.setPropertyName("used");
        nonHeapUsed.setAliasName("non_heap_mem_used");
        nonHeapMBeanAttributeProperties[2] = nonHeapUsed;
        MBeanAttributeProperty nonHeapCommitted = new MBeanAttributeProperty();
        nonHeapCommitted.setPropertyName("committed");
        nonHeapCommitted.setAliasName("non_heap_mem_committed");
        nonHeapMBeanAttributeProperties[3] = nonHeapCommitted;
        nonHeapMemoryAttribute.setProperties(nonHeapMBeanAttributeProperties);
        memoryMBeanAttributes[1] = nonHeapMemoryAttribute;
        memoryMBean.setAttributes(memoryMBeanAttributes);
        mBeans[0] = memoryMBean;
        MBean opsMBean = new MBean();
        opsMBean.setMBeanName("java.lang:type=OperatingSystem");
        MBeanAttribute cpuTimeAttribute = new MBeanAttribute();
        cpuTimeAttribute.setAttributeName("ProcessCpuTime");
        cpuTimeAttribute.setAliasName("processCpuTime");
        MBeanAttribute[] opsMBeanAttributes = new MBeanAttribute[]{cpuTimeAttribute};
        opsMBean.setAttributes(opsMBeanAttributes);
        mBeans[1] = opsMBean;
        MBean classLoadingMBean = new MBean();
        classLoadingMBean.setMBeanName("java.lang:type=ClassLoading");
        MBeanAttribute classCountAttribute = new MBeanAttribute();
        classCountAttribute.setAttributeName("LoadedClassCount");
        classCountAttribute.setAliasName("loadedClassCount");
        MBeanAttribute[] classLoadingAttributes = new MBeanAttribute[]{classCountAttribute};
        classLoadingMBean.setAttributes(classLoadingAttributes);
        mBeans[2] = classLoadingMBean;
        MBean threadingMBean = new MBean();
        threadingMBean.setMBeanName("java.lang:type=Threading");
        MBeanAttribute threadCountAttribute = new MBeanAttribute();
        threadCountAttribute.setAttributeName("ThreadCount");
        threadCountAttribute.setAliasName("threadCount");
        MBeanAttribute peakCountAttribute = new MBeanAttribute();
        peakCountAttribute.setAttributeName("PeakThreadCount");
        peakCountAttribute.setAliasName("peakThreadCount");
        MBeanAttribute[] threadingAttributes = new MBeanAttribute[]{threadCountAttribute, peakCountAttribute};
        threadingMBean.setAttributes(threadingAttributes);
        mBeans[3] = threadingMBean;
        tbProfile.setSelectedMBeans(mBeans);
        tbProfile.setActive(false);
        this.addProfile(tbProfile);
        return tbProfile;
    }

    public static int getPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }
}

