/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.common.jmx.agent;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.CarbonUtils;

public class PublisherUtil {
    private static Log log = LogFactory.getLog(PublisherUtil.class);
    private static final String PORTS_OFFSET = "Ports.Offset";
    private static final int CARBON_SERVER_DEFAULT_PORT = 9763;
    private static String hostAddressAndPort = null;
    private static final String HOST_NAME = "HostName";

    public static String getHostAddress() {
        if (hostAddressAndPort != null) {
            return hostAddressAndPort;
        }
        String hostAddress = ServerConfiguration.getInstance().getFirstProperty(HOST_NAME);
        if (null == hostAddress) {
            InetAddress localAddress = PublisherUtil.getLocalAddress();
            if (localAddress != null) {
                hostAddress = localAddress.getHostAddress();
            } else {
                hostAddress = "localhost";
                log.warn((Object)"Unable to get the ip address, hence using hostname as localhost");
            }
            int portsOffset = Integer.parseInt(CarbonUtils.getServerConfiguration().getFirstProperty(PORTS_OFFSET));
            int portValue = 9763 + portsOffset;
            hostAddressAndPort = hostAddress + ":" + portValue;
            return hostAddressAndPort;
        }
        return hostAddress.trim();
    }

    private static InetAddress getLocalAddress() {
        Enumeration<NetworkInterface> ifaces = null;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error((Object)"Failed to get host address", (Throwable)e);
        }
        if (ifaces != null) {
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                    return addr;
                }
            }
        }
        return null;
    }

    public static int getTenantId(MessageContext msgContext) {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }
}

