/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.common.jmx.agent;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.JmxProfileException;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.ProfileAlreadyExistsException;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.ProfileDoesNotExistException;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.Profile;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.ProfileManager;
import org.wso2.carbon.analytics.common.jmx.agent.tasks.JmxTaskAdmin;
import org.wso2.carbon.core.AbstractAdmin;

public class JmxAgentWebInterface
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(JmxAgentWebInterface.class);
    private ProfileManager profMan = new ProfileManager();
    private JmxTaskAdmin admin = new JmxTaskAdmin();

    public boolean addProfile(Profile profile) throws ProfileAlreadyExistsException, JmxProfileException {
        this.profMan.addProfile(profile);
        if (profile.isActive()) {
            try {
                this.admin.scheduleProfile(profile);
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault);
            }
        }
        return true;
    }

    public Profile getProfile(String profileName) throws ProfileDoesNotExistException, JmxProfileException {
        return this.profMan.getProfile(profileName);
    }

    public boolean updateProfile(Profile profile) throws ProfileDoesNotExistException, JmxProfileException {
        if (profile.isActive()) {
            try {
                this.admin.removeProfile(profile.getName());
                this.admin.scheduleProfile(profile);
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault);
            }
        }
        return this.profMan.updateProfile(profile);
    }

    public boolean deleteProfile(String profileName) throws ProfileDoesNotExistException, JmxProfileException {
        JmxTaskAdmin admin = new JmxTaskAdmin();
        try {
            if (admin.profileExists(profileName)) {
                admin.removeProfile(profileName);
            }
        }
        catch (AxisFault e) {
            log.error((Object)e);
        }
        return this.profMan.deleteProfile(profileName);
    }

    public void startMonitoringProfile(String profileName) throws ProfileDoesNotExistException, AxisFault {
        try {
            Profile profile = this.profMan.getProfile(profileName);
            if (!this.admin.isTaskScheduled(profileName)) {
                this.admin.scheduleProfile(profile);
                profile.setActive(true);
                this.profMan.updateProfile(profile);
            }
        }
        catch (ProfileDoesNotExistException e) {
            log.error((Object)e);
            throw e;
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault);
            throw new AxisFault("Error Scheduling " + profileName);
        }
        catch (JmxProfileException e) {
            log.error((Object)e);
        }
    }

    public void stopMonitoringProfile(String profileName) throws ProfileDoesNotExistException {
        try {
            Profile profile = this.profMan.getProfile(profileName);
            if (this.admin.isTaskScheduled(profileName)) {
                this.admin.removeProfile(profileName);
                profile.setActive(false);
                this.profMan.updateProfile(profile);
            }
        }
        catch (ProfileDoesNotExistException e) {
            log.error((Object)e);
            throw e;
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault);
        }
        catch (JmxProfileException e) {
            log.error((Object)e);
        }
    }

    public Profile[] getAllProfiles() throws JmxProfileException {
        return this.profMan.getAllProfiles();
    }

    public String[][] getMBeans(String url, String userName, String password) throws IOException {
        try (JMXConnector jmxc = null;){
            jmxc = this.getJmxConnector(url, userName, password);
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            int count = 0;
            TreeSet<ObjectName> names = new TreeSet<ObjectName>(mbsc.queryNames(null, null));
            String[][] nameArr = new String[names.size()][2];
            for (ObjectName name : names) {
                nameArr[count][0] = name.getDomain();
                nameArr[count][1] = name.getCanonicalName();
                ++count;
            }
            String[][] stringArray = nameArr;
            return stringArray;
        }
    }

    public String[][] getMBeanAttributeInfo(String mBean, String url, String userName, String password) throws MalformedObjectNameException, IntrospectionException, InstanceNotFoundException, IOException, ReflectionException {
        JMXConnector jmxc = this.getJmxConnector(url, userName, password);
        MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
        ObjectName mBeanName = new ObjectName(mBean);
        MBeanAttributeInfo[] attrs = mbsc.getMBeanInfo(mBeanName).getAttributes();
        ArrayList<String[]> strAttrs = new ArrayList<String[]>();
        for (MBeanAttributeInfo info : attrs) {
            try {
                Object result = mbsc.getAttribute(mBeanName, info.getName());
                if (result instanceof String || result instanceof Integer || result instanceof Double || result instanceof Long || result instanceof Boolean || result instanceof Float) {
                    strAttrs.add(new String[]{info.getName()});
                }
                if (!(result instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)result;
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(info.getName());
                for (String key : cd.getCompositeType().keySet()) {
                    Object attrValue = cd.get(key);
                    if (!(attrValue instanceof String) && !(attrValue instanceof Integer) && !(attrValue instanceof Double) && !(attrValue instanceof Long) && !(attrValue instanceof Boolean) && !(attrValue instanceof Float)) continue;
                    keys.add(key);
                }
                if (keys.size() <= 1) continue;
                strAttrs.add(keys.toArray(new String[keys.size()]));
            }
            catch (MBeanException e) {
                log.error((Object)("Removed the attribute " + info.getName() + " of " + mBean + " from the UI list due to: " + e.getMessage()));
            }
            catch (AttributeNotFoundException e) {
                log.error((Object)("Removed the attribute " + info.getName() + " of " + mBean + " from the UI list due to: " + e.getMessage()));
            }
            catch (UnmarshalException e) {
                log.error((Object)("Removed the attribute " + info.getName() + " of " + mBean + " from the UI list due to: " + e.getMessage()));
            }
            catch (RuntimeOperationsException e) {
                log.error((Object)("Removed the attribute " + info.getName() + " of " + mBean + " from the UI list due to: " + e.getMessage()));
            }
            catch (RuntimeMBeanException e) {
                log.error((Object)("Removed the attribute " + info.getName() + " of " + mBean + " from the UI list due to: " + e.getMessage()));
            }
            catch (ReflectionException e) {
                log.error((Object)("Removed the attribute " + info.getName() + " of " + mBean + " from the UI list due to: " + e.getMessage()));
            }
            catch (Exception e) {
                log.error((Object)("Removed the attribute " + info.getName() + " of " + mBean + " from the UI list due to: " + e.getMessage()));
            }
        }
        jmxc.close();
        return (String[][])strAttrs.toArray((T[])new String[strAttrs.size()][]);
    }

    private JMXConnector getJmxConnector(String url, String userName, String password) throws IOException {
        JMXServiceURL jmxServiceURL = new JMXServiceURL(url);
        HashMap<String, String[]> map = new HashMap<String, String[]>(1);
        map.put("jmx.remote.credentials", new String[]{userName, password});
        return JMXConnectorFactory.connect(jmxServiceURL, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testDataPublisherAvailability(String connectionType, String url, int port) {
        if (connectionType.equalsIgnoreCase("tcp://") || connectionType.equalsIgnoreCase("ssl://")) {
            try (DatagramSocket ds = null;){
                ds = new DatagramSocket(port);
                ds.setReuseAddress(true);
                boolean bl = true;
                return bl;
            }
        }
        if (connectionType.equalsIgnoreCase("http://") || connectionType.equalsIgnoreCase("https://")) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.setReuseAddress(true);
                InetSocketAddress sa = new InetSocketAddress(url, port);
                socket.connect(sa);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    public boolean addToolboxProfile() {
        boolean success = false;
        try {
            this.profMan.createToolboxProfile();
            success = true;
        }
        catch (ProfileAlreadyExistsException e) {
            log.error((Object)e);
        }
        catch (JmxProfileException e) {
            log.error((Object)e);
        }
        return success;
    }
}

