/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.common.jmx.agent;

import java.io.IOException;
import java.util.HashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.JmxConnectionException;
import org.wso2.carbon.analytics.common.jmx.agent.exceptions.JmxMBeanException;
import org.wso2.carbon.analytics.common.jmx.agent.profiles.Profile;

public class JmxAgent {
    private static Log log = LogFactory.getLog(JmxAgent.class);
    private Profile profile;

    public Profile getProfile() {
        return this.profile;
    }

    public JmxAgent(Profile profile) {
        this.profile = profile;
    }

    public JMXConnector openJmxConnection() throws JmxConnectionException {
        if (this.profile == null) {
            log.error((Object)"Profile is null.");
            throw new JmxConnectionException("Profile is null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Prepare open new jmx connection to " + this.profile.getUrl()));
        }
        JMXConnector jmxConnector = null;
        try {
            JMXServiceURL jmxServiceURL = new JMXServiceURL(this.profile.getUrl());
            HashMap<String, String[]> map = new HashMap<String, String[]>(1);
            map.put("jmx.remote.credentials", new String[]{this.profile.getUserName(), this.profile.getPass()});
            jmxConnector = JMXConnectorFactory.connect(jmxServiceURL, map);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully created for Jmx connection to " + this.profile.getUrl()));
            }
        }
        catch (IOException ex) {
            log.error((Object)"Unable to create JMX connection.", (Throwable)ex);
            throw new JmxConnectionException("Unable to create JMX connection.", ex);
        }
        return jmxConnector;
    }

    public void closeJmxConnection(JMXConnector jmxConnector) throws JmxConnectionException {
        if (jmxConnector != null) {
            try {
                jmxConnector.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully close the jmx connection to" + (this.profile != null ? this.profile.getUrl() : "")));
                }
            }
            catch (IOException e) {
                log.error((Object)"Unable to close JMX connection.", (Throwable)e);
                throw new JmxConnectionException("Unable to close JMX connection", e);
            }
        }
    }

    public Object getAttribute(JMXConnector jmxConnector, String mBean, String attr) throws JmxMBeanException {
        if (jmxConnector != null) {
            try {
                MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
                ObjectName mBeanName = new ObjectName(mBean);
                if (mBeanServerConnection.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found MBean:" + mBean));
                    }
                    return mBeanServerConnection.getAttribute(mBeanName, attr);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MBean is not registered " + mBean));
                }
            }
            catch (IOException e) {
                log.error((Object)"Unable to open MBean server connection", (Throwable)e);
                throw new JmxMBeanException("Unable to open MBean server connection", e);
            }
            catch (MalformedObjectNameException e) {
                log.error((Object)"Object name issue", (Throwable)e);
                throw new JmxMBeanException("Object name issue", e);
            }
            catch (AttributeNotFoundException e) {
                log.error((Object)"Cannot find the mbean", (Throwable)e);
                throw new JmxMBeanException("Cannot find the mbean", e);
            }
            catch (MBeanException e) {
                log.error((Object)"MBean exception", (Throwable)e);
                throw new JmxMBeanException("MBean exception", e);
            }
            catch (ReflectionException e) {
                log.error((Object)"Reflection exception", (Throwable)e);
                throw new JmxMBeanException("Reflection exception", e);
            }
            catch (InstanceNotFoundException e) {
                log.error((Object)"Instance not found exception", (Throwable)e);
                throw new JmxMBeanException("Instance not found exception", e);
            }
        }
        return null;
    }
}

