/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.gateway.api.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.gateway.api.ApiCallback;
import org.wso2.am.integration.clients.gateway.api.ApiClient;
import org.wso2.am.integration.clients.gateway.api.ApiException;
import org.wso2.am.integration.clients.gateway.api.ApiResponse;
import org.wso2.am.integration.clients.gateway.api.Configuration;
import org.wso2.am.integration.clients.gateway.api.Pair;
import org.wso2.am.integration.clients.gateway.api.ProgressRequestBody;
import org.wso2.am.integration.clients.gateway.api.ProgressResponseBody;
import org.wso2.am.integration.clients.gateway.api.v2.dto.SubscriptionDTO;

public class GetSubscriptionInfoApi {
    private ApiClient apiClient;

    public GetSubscriptionInfoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GetSubscriptionInfoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call subscriptionsGetCall(String apiUUID, String appUUID, String tenantDomain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiUUID != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiUUID", apiUUID));
        }
        if (appUUID != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("appUUID", appUUID));
        }
        if (tenantDomain != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantDomain", tenantDomain));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call subscriptionsGetValidateBeforeCall(String apiUUID, String appUUID, String tenantDomain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.subscriptionsGetCall(apiUUID, appUUID, tenantDomain, progressListener, progressRequestListener);
        return call;
    }

    public SubscriptionDTO subscriptionsGet(String apiUUID, String appUUID, String tenantDomain) throws ApiException {
        ApiResponse<SubscriptionDTO> resp = this.subscriptionsGetWithHttpInfo(apiUUID, appUUID, tenantDomain);
        return resp.getData();
    }

    public ApiResponse<SubscriptionDTO> subscriptionsGetWithHttpInfo(String apiUUID, String appUUID, String tenantDomain) throws ApiException {
        Call call = this.subscriptionsGetValidateBeforeCall(apiUUID, appUUID, tenantDomain, null, null);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call subscriptionsGetAsync(String apiUUID, String appUUID, String tenantDomain, final ApiCallback<SubscriptionDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.subscriptionsGetValidateBeforeCall(apiUUID, appUUID, tenantDomain, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

