/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.gateway.api.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.gateway.api.ApiCallback;
import org.wso2.am.integration.clients.gateway.api.ApiClient;
import org.wso2.am.integration.clients.gateway.api.ApiException;
import org.wso2.am.integration.clients.gateway.api.ApiResponse;
import org.wso2.am.integration.clients.gateway.api.Configuration;
import org.wso2.am.integration.clients.gateway.api.Pair;
import org.wso2.am.integration.clients.gateway.api.ProgressRequestBody;
import org.wso2.am.integration.clients.gateway.api.ProgressResponseBody;
import org.wso2.am.integration.clients.gateway.api.v2.dto.APIArtifactDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.EndpointsDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.LocalEntryDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.SequencesDTO;

public class GetApiArtifactsApi {
    private ApiClient apiClient;

    public GetApiArtifactsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GetApiArtifactsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getAPIArtifactsCall(String apiName, String version, String tenantDomain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-artifact";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiName", apiName));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        if (tenantDomain != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantDomain", tenantDomain));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAPIArtifactsValidateBeforeCall(String apiName, String version, String tenantDomain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiName == null) {
            throw new ApiException("Missing the required parameter 'apiName' when calling getAPIArtifacts(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getAPIArtifacts(Async)");
        }
        Call call = this.getAPIArtifactsCall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        return call;
    }

    public APIArtifactDTO getAPIArtifacts(String apiName, String version, String tenantDomain) throws ApiException {
        ApiResponse<APIArtifactDTO> resp = this.getAPIArtifactsWithHttpInfo(apiName, version, tenantDomain);
        return resp.getData();
    }

    public ApiResponse<APIArtifactDTO> getAPIArtifactsWithHttpInfo(String apiName, String version, String tenantDomain) throws ApiException {
        Call call = this.getAPIArtifactsValidateBeforeCall(apiName, version, tenantDomain, null, null);
        Type localVarReturnType = new TypeToken<APIArtifactDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAPIArtifactsAsync(String apiName, String version, String tenantDomain, final ApiCallback<APIArtifactDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAPIArtifactsValidateBeforeCall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIArtifactDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getEndpointsCall(String apiName, String version, String tenantDomain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/end-points";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiName", apiName));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        if (tenantDomain != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantDomain", tenantDomain));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEndpointsValidateBeforeCall(String apiName, String version, String tenantDomain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiName == null) {
            throw new ApiException("Missing the required parameter 'apiName' when calling getEndpoints(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getEndpoints(Async)");
        }
        Call call = this.getEndpointsCall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        return call;
    }

    public EndpointsDTO getEndpoints(String apiName, String version, String tenantDomain) throws ApiException {
        ApiResponse<EndpointsDTO> resp = this.getEndpointsWithHttpInfo(apiName, version, tenantDomain);
        return resp.getData();
    }

    public ApiResponse<EndpointsDTO> getEndpointsWithHttpInfo(String apiName, String version, String tenantDomain) throws ApiException {
        Call call = this.getEndpointsValidateBeforeCall(apiName, version, tenantDomain, null, null);
        Type localVarReturnType = new TypeToken<EndpointsDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEndpointsAsync(String apiName, String version, String tenantDomain, final ApiCallback<EndpointsDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEndpointsValidateBeforeCall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EndpointsDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getLocalEntriesCall(String apiName, String version, String tenantDomain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/local-entry";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiName", apiName));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        if (tenantDomain != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantDomain", tenantDomain));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLocalEntriesValidateBeforeCall(String apiName, String version, String tenantDomain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiName == null) {
            throw new ApiException("Missing the required parameter 'apiName' when calling getLocalEntries(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getLocalEntries(Async)");
        }
        Call call = this.getLocalEntriesCall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        return call;
    }

    public LocalEntryDTO getLocalEntries(String apiName, String version, String tenantDomain) throws ApiException {
        ApiResponse<LocalEntryDTO> resp = this.getLocalEntriesWithHttpInfo(apiName, version, tenantDomain);
        return resp.getData();
    }

    public ApiResponse<LocalEntryDTO> getLocalEntriesWithHttpInfo(String apiName, String version, String tenantDomain) throws ApiException {
        Call call = this.getLocalEntriesValidateBeforeCall(apiName, version, tenantDomain, null, null);
        Type localVarReturnType = new TypeToken<LocalEntryDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLocalEntriesAsync(String apiName, String version, String tenantDomain, final ApiCallback<LocalEntryDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLocalEntriesValidateBeforeCall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LocalEntryDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSequencesCall(String apiName, String version, String tenantDomain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sequence";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiName", apiName));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        if (tenantDomain != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantDomain", tenantDomain));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSequencesValidateBeforeCall(String apiName, String version, String tenantDomain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiName == null) {
            throw new ApiException("Missing the required parameter 'apiName' when calling getSequences(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getSequences(Async)");
        }
        Call call = this.getSequencesCall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        return call;
    }

    public SequencesDTO getSequences(String apiName, String version, String tenantDomain) throws ApiException {
        ApiResponse<SequencesDTO> resp = this.getSequencesWithHttpInfo(apiName, version, tenantDomain);
        return resp.getData();
    }

    public ApiResponse<SequencesDTO> getSequencesWithHttpInfo(String apiName, String version, String tenantDomain) throws ApiException {
        Call call = this.getSequencesValidateBeforeCall(apiName, version, tenantDomain, null, null);
        Type localVarReturnType = new TypeToken<SequencesDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSequencesAsync(String apiName, String version, String tenantDomain, final ApiCallback<SequencesDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSequencesValidateBeforeCall(apiName, version, tenantDomain, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SequencesDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

