/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.util;

import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.util.ArrayUtil;

public class UrlUtil {
    private static final EncodeInfo FRAGMENT_SPLIT = new EncodeInfo("#", "%23");
    private static final EncodeInfo SPACE_SPLIT = new EncodeInfo("+", "%20");
    private static final EncodeInfo[] SPECIAL_CHARACTER_ENCODER_MAP = new EncodeInfo[]{SPACE_SPLIT, FRAGMENT_SPLIT, new EncodeInfo("/", "%2F"), new EncodeInfo("?", "%3F"), new EncodeInfo("%", "%25"), new EncodeInfo("&", "%26"), new EncodeInfo("=", "%3D")};

    private static String getEncodedHost(String host, String userInfo, String charset, EncodeInfo[] specials) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            return null;
        }
        StringBuffer bufferEncodedHost = new StringBuffer();
        try {
            Object[] splitHost = host.split(".");
            if (!ArrayUtil.isEmpty(splitHost)) {
                for (int i = 0; i < splitHost.length; ++i) {
                    Object hostSegment = splitHost[i];
                    if (i != 0) {
                        bufferEncodedHost.append(".");
                    }
                    if (TextUtils.isEmpty((CharSequence)hostSegment)) continue;
                    if (!UrlUtil.isEncoded((String)hostSegment, charset)) {
                        String encodedHostSegment = URLEncoder.encode((String)hostSegment, charset);
                        if (TextUtils.isEmpty((CharSequence)encodedHostSegment)) continue;
                        if (!ArrayUtil.isEmpty(specials)) {
                            for (EncodeInfo encodeInfo : specials) {
                                if (encodeInfo == null || TextUtils.isEmpty((CharSequence)encodeInfo.needEncode) || TextUtils.isEmpty((CharSequence)encodeInfo.encoded) || TextUtils.isEmpty((CharSequence)encodedHostSegment) || !encodedHostSegment.contains(encodeInfo.encoded)) continue;
                                encodedHostSegment = encodedHostSegment.replace(encodeInfo.encoded, encodeInfo.needEncode);
                            }
                        }
                        bufferEncodedHost.append(encodedHostSegment);
                        continue;
                    }
                    bufferEncodedHost.append((String)hostSegment);
                }
            } else if (!UrlUtil.isEncoded(host, charset)) {
                String encodedHost = URLEncoder.encode(host, charset);
                if (!TextUtils.isEmpty((CharSequence)encodedHost)) {
                    if (!ArrayUtil.isEmpty(specials)) {
                        for (EncodeInfo encodeInfo : specials) {
                            if (encodeInfo == null || TextUtils.isEmpty((CharSequence)encodeInfo.needEncode) || TextUtils.isEmpty((CharSequence)encodeInfo.encoded) || TextUtils.isEmpty((CharSequence)encodedHost) || !encodedHost.contains(encodeInfo.encoded)) continue;
                            encodedHost = encodedHost.replace(encodeInfo.encoded, encodeInfo.needEncode);
                        }
                    }
                    bufferEncodedHost.append(encodedHost);
                }
            } else {
                bufferEncodedHost.append(host);
            }
            if (!TextUtils.isEmpty((CharSequence)userInfo)) {
                bufferEncodedHost.append("@");
                bufferEncodedHost.append(userInfo);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return bufferEncodedHost.toString();
    }

    private static String getEncodedFile(String path, String query, String ref, String charset, EncodeInfo[] specials) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        StringBuffer bufferEncodedFile = new StringBuffer();
        try {
            Object[] splitPath = path.split("/");
            if (!ArrayUtil.isEmpty(splitPath)) {
                for (int i = 0; i < splitPath.length; ++i) {
                    Object pathSegment = splitPath[i];
                    if (i != 0) {
                        bufferEncodedFile.append("/");
                    }
                    if (TextUtils.isEmpty((CharSequence)pathSegment)) continue;
                    if (!UrlUtil.isEncoded((String)pathSegment, charset)) {
                        String encodedPathSegment = URLEncoder.encode((String)pathSegment, charset);
                        if (TextUtils.isEmpty((CharSequence)encodedPathSegment)) continue;
                        if (!ArrayUtil.isEmpty(specials)) {
                            for (EncodeInfo encodeInfo : specials) {
                                if (encodeInfo == null || TextUtils.isEmpty((CharSequence)encodeInfo.needEncode) || TextUtils.isEmpty((CharSequence)encodeInfo.encoded) || TextUtils.isEmpty((CharSequence)encodedPathSegment) || !encodedPathSegment.contains(encodeInfo.encoded)) continue;
                                encodedPathSegment = encodedPathSegment.replace(encodeInfo.encoded, encodeInfo.needEncode);
                            }
                        }
                        bufferEncodedFile.append(encodedPathSegment);
                        continue;
                    }
                    bufferEncodedFile.append((String)pathSegment);
                }
            } else if (!UrlUtil.isEncoded(path, charset)) {
                String encodedPath = URLEncoder.encode(path, charset);
                if (!TextUtils.isEmpty((CharSequence)encodedPath)) {
                    if (!ArrayUtil.isEmpty(specials)) {
                        for (EncodeInfo encodeInfo : specials) {
                            if (encodeInfo == null || TextUtils.isEmpty((CharSequence)encodeInfo.needEncode) || TextUtils.isEmpty((CharSequence)encodeInfo.encoded) || TextUtils.isEmpty((CharSequence)encodedPath) || !encodedPath.contains(encodeInfo.encoded)) continue;
                            encodedPath = encodedPath.replace(encodeInfo.encoded, encodeInfo.needEncode);
                        }
                    }
                    bufferEncodedFile.append(encodedPath);
                }
            } else {
                bufferEncodedFile.append(path);
            }
            if (!TextUtils.isEmpty((CharSequence)query)) {
                Object[] splitQuery;
                if (query.contains("\\?") || query.contains("&")) {
                    bufferEncodedFile.append("?");
                }
                if (!ArrayUtil.isEmpty(splitQuery = query.split("&"))) {
                    for (int i = 0; i < splitQuery.length; ++i) {
                        Object querySegment = splitQuery[i];
                        if (i != 0) {
                            bufferEncodedFile.append("&");
                        }
                        if (TextUtils.isEmpty((CharSequence)querySegment)) continue;
                        Object[] keyValue = ((String)querySegment).split("=");
                        if (!ArrayUtil.isEmpty(keyValue) && keyValue.length >= 2) {
                            Object key = keyValue[0];
                            Object value = keyValue[1];
                            if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) continue;
                            if (!UrlUtil.isEncoded((String)key, charset)) {
                                key = URLEncoder.encode((String)key, charset);
                                if (!ArrayUtil.isEmpty(specials)) {
                                    for (EncodeInfo encodeInfo : specials) {
                                        if (encodeInfo == null || TextUtils.isEmpty((CharSequence)encodeInfo.needEncode) || TextUtils.isEmpty((CharSequence)encodeInfo.encoded) || TextUtils.isEmpty((CharSequence)key) || !((String)key).contains(encodeInfo.encoded)) continue;
                                        key = ((String)key).replace(encodeInfo.encoded, encodeInfo.needEncode);
                                    }
                                }
                            }
                            if (!UrlUtil.isEncoded((String)value, charset)) {
                                value = URLEncoder.encode((String)value, charset);
                                if (!ArrayUtil.isEmpty(specials)) {
                                    for (EncodeInfo encodeInfo : specials) {
                                        if (encodeInfo == null || TextUtils.isEmpty((CharSequence)encodeInfo.needEncode) || TextUtils.isEmpty((CharSequence)encodeInfo.encoded) || TextUtils.isEmpty((CharSequence)value) || !((String)value).contains(encodeInfo.encoded)) continue;
                                        value = ((String)value).replace(encodeInfo.encoded, encodeInfo.needEncode);
                                    }
                                }
                            }
                            bufferEncodedFile.append((String)key);
                            bufferEncodedFile.append("=");
                            bufferEncodedFile.append((String)value);
                            continue;
                        }
                        if (!UrlUtil.isEncoded((String)querySegment, charset)) {
                            String encodedQuerySegment = URLEncoder.encode((String)querySegment, charset);
                            if (TextUtils.isEmpty((CharSequence)encodedQuerySegment)) continue;
                            if (!ArrayUtil.isEmpty(specials)) {
                                for (EncodeInfo encodeInfo : specials) {
                                    if (encodeInfo == null || TextUtils.isEmpty((CharSequence)encodeInfo.needEncode) || TextUtils.isEmpty((CharSequence)encodeInfo.encoded) || TextUtils.isEmpty((CharSequence)encodedQuerySegment) || !encodedQuerySegment.contains(encodeInfo.encoded)) continue;
                                    encodedQuerySegment = encodedQuerySegment.replace(encodeInfo.encoded, encodeInfo.needEncode);
                                }
                            }
                            bufferEncodedFile.append(encodedQuerySegment);
                            continue;
                        }
                        bufferEncodedFile.append((String)querySegment);
                    }
                } else if (!UrlUtil.isEncoded(query, charset)) {
                    String encodedQuery = URLEncoder.encode(query, charset);
                    if (!TextUtils.isEmpty((CharSequence)encodedQuery)) {
                        if (!ArrayUtil.isEmpty(specials)) {
                            for (EncodeInfo encodeInfo : specials) {
                                if (encodeInfo == null || TextUtils.isEmpty((CharSequence)encodeInfo.needEncode) || TextUtils.isEmpty((CharSequence)encodeInfo.encoded) || TextUtils.isEmpty((CharSequence)encodedQuery) || !encodedQuery.contains(encodeInfo.encoded)) continue;
                                encodedQuery = encodedQuery.replace(encodeInfo.encoded, encodeInfo.needEncode);
                            }
                        }
                        bufferEncodedFile.append(encodedQuery);
                    }
                } else {
                    bufferEncodedFile.append(query);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)ref)) {
                if (!UrlUtil.isEncoded(query, charset)) {
                    String encodedRef = URLEncoder.encode(ref, charset);
                    if (!TextUtils.isEmpty((CharSequence)encodedRef)) {
                        bufferEncodedFile.append("#");
                        bufferEncodedFile.append(encodedRef);
                    }
                } else {
                    bufferEncodedFile.append("#");
                    bufferEncodedFile.append(ref);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return bufferEncodedFile.toString();
    }

    public static boolean isEncoded(String content, String charset) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        Log.d("wlf", "isEncoded\uff0ccheck content\uff1a" + content);
        for (EncodeInfo info : SPECIAL_CHARACTER_ENCODER_MAP) {
            if (info == null || !content.contains(info.needEncode)) continue;
            return false;
        }
        String decodedContent = null;
        try {
            decodedContent = URLDecoder.decode(content, charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return decodedContent == null || !decodedContent.equalsIgnoreCase(content);
    }

    public static String decode(String content, String charset) {
        try {
            String decodedContent = URLDecoder.decode(content, charset);
            return decodedContent;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getEncodedUrl(String url, String charset, boolean useFragment, boolean blankAsPlus) {
        Log.d("wlf", "getEncodedUrl\uff0c--------------------");
        Log.d("wlf", "getEncodedUrl\uff0c\u51c6\u5907\u7f16\u7801URL\uff0curl\uff1a" + url);
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (url != null) {
            url = url.trim();
        }
        String encodedUrl = null;
        try {
            URL unEncodeUrl = new URL(url);
            Log.d("wlf", "getEncodedUrl\uff0c\u5f00\u59cb\u7f16\u7801URL\uff0cunEncodeUrl\uff1a" + unEncodeUrl);
            Log.d("wlf", "getEncodedUrl\uff0c\u5f00\u59cb\u7f16\u7801URL\uff0cgetProtocol\uff1a" + unEncodeUrl.getProtocol());
            Log.d("wlf", "getEncodedUrl\uff0c\u5f00\u59cb\u7f16\u7801URL\uff0cgetHost\uff1a" + unEncodeUrl.getHost());
            Log.d("wlf", "getEncodedUrl\uff0c\u5f00\u59cb\u7f16\u7801URL\uff0cgetUserInfo\uff1a" + unEncodeUrl.getUserInfo());
            Log.d("wlf", "getEncodedUrl\uff0c\u5f00\u59cb\u7f16\u7801URL\uff0cgetPort\uff1a" + unEncodeUrl.getPort());
            Log.d("wlf", "getEncodedUrl\uff0c\u5f00\u59cb\u7f16\u7801URL\uff0cgetFile\uff1a" + unEncodeUrl.getFile());
            Log.d("wlf", "getEncodedUrl\uff0c\u5f00\u59cb\u7f16\u7801URL\uff0cgetPath\uff1a" + unEncodeUrl.getPath());
            Log.d("wlf", "getEncodedUrl\uff0c\u5f00\u59cb\u7f16\u7801URL\uff0cgetQuery\uff1a" + unEncodeUrl.getQuery());
            Log.d("wlf", "getEncodedUrl\uff0c\u5f00\u59cb\u7f16\u7801URL\uff0cgetRef\uff1a" + unEncodeUrl.getRef());
            String protocol = unEncodeUrl.getProtocol();
            String host = unEncodeUrl.getHost();
            String userInfo = unEncodeUrl.getUserInfo();
            host = UrlUtil.getEncodedHost(host, userInfo, charset, SPECIAL_CHARACTER_ENCODER_MAP);
            int port = unEncodeUrl.getPort();
            String file = unEncodeUrl.getFile();
            String path = unEncodeUrl.getPath();
            String query = unEncodeUrl.getQuery();
            String ref = unEncodeUrl.getRef();
            file = UrlUtil.getEncodedFile(path, query, ref, charset, SPECIAL_CHARACTER_ENCODER_MAP);
            URL tempEncodedUrl = new URL(protocol, host, port, file);
            encodedUrl = tempEncodedUrl.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (encodedUrl != null && encodedUrl.contains(UrlUtil.SPACE_SPLIT.needEncode) && !blankAsPlus) {
            encodedUrl = encodedUrl.replaceAll("\\" + UrlUtil.SPACE_SPLIT.needEncode, UrlUtil.SPACE_SPLIT.encoded);
        }
        if (encodedUrl != null && encodedUrl.contains(UrlUtil.FRAGMENT_SPLIT.needEncode) && !useFragment) {
            encodedUrl = encodedUrl.replaceAll(UrlUtil.FRAGMENT_SPLIT.needEncode, UrlUtil.FRAGMENT_SPLIT.encoded);
        }
        Log.e("wlf", "getEncodedUrl\uff0c\u7f16\u7801\u540eURL\uff0cencodedUrl\uff1a" + encodedUrl);
        return encodedUrl;
    }

    public static boolean isUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        String encodedUrl = UrlUtil.getASCIIEncodedUrl(url, "UTF-8");
        return !TextUtils.isEmpty((CharSequence)encodedUrl);
    }

    public static String getASCIIEncodedUrl(String url, String charset) {
        return UrlUtil.getEncodedUrl(url, charset, false, false);
    }

    public static String getFileNameByUrl(String url, String charset) {
        String decodedContent;
        String fileName = null;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (url != null) {
            url = url.trim();
        }
        try {
            if (url.contains("/") && (fileName = url.substring(url.lastIndexOf(47) + 1)) != null && fileName.contains("?")) {
                fileName = fileName.substring(0, fileName.indexOf(63));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!TextUtils.isEmpty(fileName) && UrlUtil.isEncoded(fileName, charset) && !TextUtils.isEmpty((CharSequence)(decodedContent = UrlUtil.decode(fileName, charset)))) {
            fileName = decodedContent;
        }
        if (!TextUtils.isEmpty(fileName)) {
            return fileName;
        }
        return url;
    }

    private static class EncodeInfo {
        public final String needEncode;
        public final String encoded;

        public EncodeInfo(String needEncode, String encoded) {
            this.needEncode = needEncode;
            this.encoded = encoded;
        }
    }
}

