/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_move;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.base.Stoppable;
import org.wlf.filedownloader.file_download.base.OnStopFileDownloadTaskListener;
import org.wlf.filedownloader.file_download.base.Pauseable;
import org.wlf.filedownloader.file_move.DownloadFileMover;
import org.wlf.filedownloader.file_move.MoveDownloadFileTask;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFilesListener;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.FileUtil;
import org.wlf.filedownloader.util.UrlUtil;

class MoveDownloadFilesTask
implements Runnable,
Stoppable {
    private static final String TAG = MoveDownloadFilesTask.class.getSimpleName();
    private List<String> mUrls;
    private String mNewDirPath;
    private ExecutorService mTaskEngine;
    private DownloadFileMover mDownloadFileMover;
    private Pauseable mDownloadTaskPauseable;
    private Map<String, String> mOldFileDir = new HashMap<String, String>();
    private OnMoveDownloadFilesListener mOnMoveDownloadFilesListener;
    private boolean mIsStop = false;
    private AtomicBoolean mIsNotifyFinish = new AtomicBoolean(false);
    private Object mLock = new Object();
    private final List<DownloadFileInfo> mDownloadFilesNeedMove = new ArrayList<DownloadFileInfo>();
    private final List<DownloadFileInfo> mDownloadFilesMoved = new ArrayList<DownloadFileInfo>();
    private final List<DownloadFileInfo> mDownloadFilesSkip = new ArrayList<DownloadFileInfo>();

    public MoveDownloadFilesTask(List<String> urls, String newDirPath, ExecutorService taskEngine, DownloadFileMover downloadFileMover, Pauseable downloadTaskPauseable) {
        this.mUrls = urls;
        this.mNewDirPath = newDirPath;
        this.mTaskEngine = taskEngine;
        this.mDownloadFileMover = downloadFileMover;
        this.mDownloadTaskPauseable = downloadTaskPauseable;
    }

    public void setOnMoveDownloadFilesListener(OnMoveDownloadFilesListener onMoveDownloadFilesListener) {
        this.mOnMoveDownloadFilesListener = onMoveDownloadFilesListener;
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileMover.getDownloadFile(url);
    }

    @Override
    public void stop() {
        this.mIsStop = true;
    }

    @Override
    public boolean isStopped() {
        return this.mIsStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DownloadFileInfo downloadFileInfo;
            this.mDownloadFilesNeedMove.clear();
            this.mDownloadFilesMoved.clear();
            this.mDownloadFilesSkip.clear();
            for (String url : this.mUrls) {
                if (!UrlUtil.isUrl(url) || (downloadFileInfo = this.getDownloadFile(url)) == null) continue;
                this.mDownloadFilesNeedMove.add(downloadFileInfo);
                this.mOldFileDir.put(downloadFileInfo.getUrl(), downloadFileInfo.getFileDir());
            }
            this.notifyMoveDownloadFilesPrepared();
            final OnMoveSingleDownloadFileListener onMoveEverySingleDownloadFileListener = new OnMoveSingleDownloadFileListener();
            for (int i = 0; i < this.mDownloadFilesNeedMove.size(); ++i) {
                downloadFileInfo = this.mDownloadFilesNeedMove.get(i);
                if (downloadFileInfo == null) {
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mDownloadFilesSkip.add(downloadFileInfo);
                        continue;
                    }
                }
                final String finalUrl = downloadFileInfo.getUrl();
                if (this.isStopped()) {
                    Log.d(TAG, TAG + ".run \u6279\u91cf\u79fb\u52a8\u4efb\u52a1\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u79fb\u52a8\uff0c\u4efb\u52a1\u5373\u5c06\u7ed3\u675f");
                    return;
                }
                if (this.mDownloadTaskPauseable.isDownloading(finalUrl)) {
                    Log.d(TAG, TAG + ".run \u9700\u8981\u5148\u6682\u505c\u5355\u4e2a\u4e0b\u8f7d\u4efb\u52a1\u540e\u79fb\u52a8\uff0curl:" + finalUrl);
                    this.mDownloadTaskPauseable.pause(finalUrl, new OnStopFileDownloadTaskListener(){

                        @Override
                        public void onStopFileDownloadTaskSucceed(String url) {
                            Log.d(TAG, TAG + ".run \u6682\u505c\u5355\u4e2a\u4e0b\u8f7d\u4efb\u52a1\u6210\u529f\uff0c\u5f00\u59cb\u79fb\u52a8\uff0curl:" + finalUrl);
                            if (MoveDownloadFilesTask.this.isStopped()) {
                                Log.d(TAG, TAG + ".run \u6279\u91cf\u79fb\u52a8\u4efb\u52a1\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u79fb\u52a8\uff0c\u4efb\u52a1\u5373\u5c06\u7ed3\u675f");
                                MoveDownloadFilesTask.this.notifyMoveDownloadFilesCompleted();
                                return;
                            }
                            MoveDownloadFilesTask.this.runSingleMoveTask(url, onMoveEverySingleDownloadFileListener, false);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onStopFileDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
                            if (MoveDownloadFilesTask.this.isStopped()) {
                                Log.d(TAG, TAG + ".run \u6279\u91cf\u79fb\u52a8\u4efb\u52a1\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u79fb\u52a8\uff0c\u4efb\u52a1\u5373\u5c06\u7ed3\u675f");
                                MoveDownloadFilesTask.this.notifyMoveDownloadFilesCompleted();
                                return;
                            }
                            if (failReason != null && OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason.TYPE_TASK_HAS_BEEN_STOPPED.equals(failReason.getType())) {
                                MoveDownloadFilesTask.this.runSingleMoveTask(url, onMoveEverySingleDownloadFileListener, false);
                                return;
                            }
                            Log.d(TAG, TAG + ".run \u6682\u505c\u5355\u4e2a\u4e0b\u8f7d\u4efb\u52a1\u5931\u8d25\uff0c\u65e0\u6cd5\u79fb\u52a8\uff0curl:" + finalUrl);
                            Object object = MoveDownloadFilesTask.this.mLock;
                            synchronized (object) {
                                MoveDownloadFilesTask.this.mDownloadFilesSkip.add(MoveDownloadFilesTask.this.getDownloadFile(finalUrl));
                            }
                        }
                    });
                    continue;
                }
                this.runSingleMoveTask(finalUrl, onMoveEverySingleDownloadFileListener, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.isStopped()) {
                this.notifyMoveDownloadFilesCompleted();
            }
            Log.d(TAG, TAG + ".run \u6279\u91cf\u79fb\u52a8\u6587\u4ef6\u4e3b\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u4f46\u662f\u901a\u8fc7\u6682\u505c\u4e0b\u8f7d\u4e2d\u7684\u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u53ef\u80fd\u8fd8\u6ca1\u6709\u7ed3\u675f");
        }
    }

    private void runSingleMoveTask(String url, OnMoveDownloadFileListener onMoveEverySingleDownloadFileListener, boolean sync) {
        MoveDownloadFileTask moveSingleDownloadFileTask = new MoveDownloadFileTask(url, this.mNewDirPath, this.mDownloadFileMover);
        moveSingleDownloadFileTask.enableSyncCallback();
        moveSingleDownloadFileTask.setOnMoveDownloadFileListener(onMoveEverySingleDownloadFileListener);
        if (sync) {
            moveSingleDownloadFileTask.run();
        } else {
            this.mTaskEngine.execute(moveSingleDownloadFileTask);
        }
    }

    private void notifyMoveDownloadFilesPrepared() {
        Log.d(TAG, TAG + ".run \u51c6\u5907\u6279\u91cf\u79fb\u52a8\uff0c\u5927\u5c0f\uff1a" + this.mDownloadFilesNeedMove.size());
        OnMoveDownloadFilesListener.MainThreadHelper.onMoveDownloadFilesPrepared(this.mDownloadFilesNeedMove, this.mOnMoveDownloadFilesListener);
    }

    private void notifyMovingDownloadFiles(DownloadFileInfo downloadFileInfo) {
        String url = null;
        if (downloadFileInfo != null) {
            url = downloadFileInfo.getUrl();
        }
        Log.d(TAG, TAG + ".run \u51c6\u5907\u79fb\u52a8\u5355\u4e2a\uff0curl\uff1a" + url);
        OnMoveDownloadFilesListener.MainThreadHelper.onMovingDownloadFiles(this.mDownloadFilesNeedMove, this.mDownloadFilesMoved, this.mDownloadFilesSkip, downloadFileInfo, this.mOnMoveDownloadFilesListener);
    }

    private void notifyMoveDownloadFilesCompleted() {
        if (this.mIsNotifyFinish.get()) {
            return;
        }
        if (this.mIsNotifyFinish.compareAndSet(false, true)) {
            this.checkRollback();
            OnMoveDownloadFilesListener.MainThreadHelper.onMoveDownloadFilesCompleted(this.mDownloadFilesNeedMove, this.mDownloadFilesMoved, this.mOnMoveDownloadFilesListener);
            this.mIsStop = true;
            int failedSize = this.mDownloadFilesNeedMove.size() - this.mDownloadFilesMoved.size();
            Log.d(TAG, TAG + ".run\uff0c\u6279\u91cf\u79fb\u52a8\u6587\u4ef6\u4e3b\u4efb\u52a1\u548c\u5176\u5b83\u76f8\u5173\u4efb\u52a1\u5168\u90e8\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u603b\u5171\u9700\u8981\u79fb\u52a8\uff1a" + this.mDownloadFilesNeedMove.size() + "\uff0c\u5df2\u79fb\u52a8\uff1a" + this.mDownloadFilesMoved.size() + "\uff0c\u5931\u8d25\uff1a" + failedSize + "\uff0c\u8df3\u8fc7\uff1a" + this.mDownloadFilesSkip.size() + "\uff0c\u8df3\u8fc7\u6570\u91cf\u662f\u5426\u7b49\u4e8e\u5931\u8d25\u6570\u91cf\uff1a" + (failedSize == this.mDownloadFilesSkip.size()));
        }
    }

    private void checkRollback() {
        if (CollectionUtil.isEmpty(this.mDownloadFilesSkip)) {
            return;
        }
        for (DownloadFileInfo downloadFileInfo : this.mDownloadFilesSkip) {
            String oldDirPath;
            if (downloadFileInfo == null || !FileUtil.isFilePath(oldDirPath = this.mOldFileDir.get(downloadFileInfo.getUrl())) || oldDirPath.equals(downloadFileInfo.getFileDir())) continue;
            try {
                this.mDownloadFileMover.moveDownloadFile(downloadFileInfo.getUrl(), oldDirPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.mDownloadFileMover.moveDownloadFile(downloadFileInfo.getUrl(), oldDirPath);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private class OnMoveSingleDownloadFileListener
    implements OnMoveDownloadFileListener {
        private OnMoveSingleDownloadFileListener() {
        }

        @Override
        public void onMoveDownloadFilePrepared(DownloadFileInfo downloadFileNeedToMove) {
            MoveDownloadFilesTask.this.notifyMovingDownloadFiles(downloadFileNeedToMove);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMoveDownloadFileSuccess(DownloadFileInfo downloadFileMoved) {
            String url = null;
            if (downloadFileMoved != null) {
                url = downloadFileMoved.getUrl();
            }
            Object object = MoveDownloadFilesTask.this.mLock;
            synchronized (object) {
                MoveDownloadFilesTask.this.mDownloadFilesMoved.add(downloadFileMoved);
            }
            Log.d(TAG, TAG + ".run \u79fb\u52a8\u5355\u4e2a\u6210\u529f\uff0c\u5df2\u79fb\u52a8\u6570\u91cf\uff1a" + MoveDownloadFilesTask.this.mDownloadFilesMoved.size() + "\uff0c\u603b\u5171\u9700\u8981\u79fb\u52a8\u6570\u91cf" + MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() + "\uff0curl\uff1a" + url);
            if (MoveDownloadFilesTask.this.mDownloadFilesMoved.size() + MoveDownloadFilesTask.this.mDownloadFilesSkip.size() == MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size()) {
                MoveDownloadFilesTask.this.notifyMoveDownloadFilesCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMoveDownloadFileFailed(DownloadFileInfo downloadFileInfo, OnMoveDownloadFileListener.MoveDownloadFileFailReason failReason) {
            String url = null;
            if (downloadFileInfo != null) {
                url = downloadFileInfo.getUrl();
            }
            String msg = null;
            if (failReason != null) {
                msg = failReason.getMessage();
            }
            Log.d(TAG, TAG + ".run \u79fb\u52a8\u5355\u4e2a\u6210\u529f\uff0c\u5df2\u79fb\u52a8\u6570\u91cf\uff1a" + MoveDownloadFilesTask.this.mDownloadFilesMoved.size() + "\uff0c\u603b\u5171\u9700\u8981\u79fb\u52a8\u6570\u91cf" + MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + msg + "\uff0curl\uff1a" + url);
            Object object = MoveDownloadFilesTask.this.mLock;
            synchronized (object) {
                MoveDownloadFilesTask.this.mDownloadFilesSkip.add(downloadFileInfo);
            }
            if (MoveDownloadFilesTask.this.mDownloadFilesMoved.size() + MoveDownloadFilesTask.this.mDownloadFilesSkip.size() == MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size()) {
                MoveDownloadFilesTask.this.notifyMoveDownloadFilesCompleted();
            }
        }
    }
}

