/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_download.DownloadTaskImpl;
import org.wlf.filedownloader.file_download.FileDownloadTaskParam;
import org.wlf.filedownloader.file_download.base.DownloadRecorder;
import org.wlf.filedownloader.file_download.base.OnStopFileDownloadTaskListener;
import org.wlf.filedownloader.file_download.base.OnTaskRunFinishListener;
import org.wlf.filedownloader.file_download.base.RetryableDownloadTask;
import org.wlf.filedownloader.file_download.http_downloader.Range;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.listener.OnRetryableFileDownloadStatusListener;
import org.wlf.filedownloader.util.DownloadFileUtil;

class RetryableDownloadTaskImpl
implements RetryableDownloadTask,
OnFileDownloadStatusListener {
    private static final String TAG = RetryableDownloadTaskImpl.class.getSimpleName();
    private final FileDownloadTaskParam mOriginalTaskParamInfo;
    private DownloadRecorder mDownloadRecorder;
    private DownloadTaskImpl mFileDownloadTaskImpl;
    private int mRetryDownloadTimes = 0;
    private Range mRecordedRange;
    private int mHasRetriedTimes = 0;
    private boolean mIsTaskStop = false;
    private boolean mIsRunning = false;
    private AtomicBoolean mIsNotifyTaskFinish = new AtomicBoolean(false);
    private OnFileDownloadStatusListener mOnFileDownloadStatusListener;
    private OnStopFileDownloadTaskListener mOnStopFileDownloadTaskListener;
    private OnTaskRunFinishListener mOnTaskRunFinishListener;
    private DownloadTaskImpl.FinishState mFinishState;
    private Thread mCurrentTaskThread;
    private ExecutorService mCloseConnectionEngine;
    private int mConnectTimeout = 15000;

    public RetryableDownloadTaskImpl(FileDownloadTaskParam taskParamInfo, DownloadRecorder downloadRecorder, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.mOriginalTaskParamInfo = taskParamInfo;
        this.mDownloadRecorder = downloadRecorder;
        this.mOnFileDownloadStatusListener = onFileDownloadStatusListener;
        this.mIsTaskStop = false;
        this.init();
        if (this.mFileDownloadTaskImpl == null || this.mFileDownloadTaskImpl.isStopped()) {
            this.stop();
            DownloadTaskImpl.FinishState finishStateInternal = this.mFileDownloadTaskImpl.getFinishState();
            if (finishStateInternal != null) {
                this.mFinishState = new DownloadTaskImpl.FinishState(finishStateInternal.getStatus(), finishStateInternal.getFailReason());
            }
            this.notifyTaskFinish();
            return;
        }
    }

    private void init() {
        if (this.mRecordedRange == null) {
            this.mRecordedRange = new Range(this.mOriginalTaskParamInfo.getStartPosInTotal(), this.mOriginalTaskParamInfo.getStartPosInTotal());
        }
        FileDownloadTaskParam taskParamInfo = new FileDownloadTaskParam(this.getUrl(), this.mOriginalTaskParamInfo.getStartPosInTotal() + this.mRecordedRange.getLength(), this.mOriginalTaskParamInfo.getFileTotalSize(), this.mOriginalTaskParamInfo.getETag(), this.mOriginalTaskParamInfo.getLastModified(), this.mOriginalTaskParamInfo.getAcceptRangeType(), this.mOriginalTaskParamInfo.getTempFilePath(), this.mOriginalTaskParamInfo.getFilePath());
        taskParamInfo.setRequestMethod(this.mOriginalTaskParamInfo.getRequestMethod());
        taskParamInfo.setHeaders(this.mOriginalTaskParamInfo.getHeaders());
        this.mFileDownloadTaskImpl = new DownloadTaskImpl(taskParamInfo, this.mDownloadRecorder, this);
        this.mFileDownloadTaskImpl.setCloseConnectionEngine(this.mCloseConnectionEngine);
        this.mFileDownloadTaskImpl.setConnectTimeout(this.mConnectTimeout);
    }

    @Override
    public void setOnStopFileDownloadTaskListener(OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        this.mOnStopFileDownloadTaskListener = onStopFileDownloadTaskListener;
    }

    @Override
    public void setOnTaskRunFinishListener(OnTaskRunFinishListener onTaskRunFinishListener) {
        this.mOnTaskRunFinishListener = onTaskRunFinishListener;
    }

    public void setCloseConnectionEngine(ExecutorService closeConnectionEngine) {
        this.mCloseConnectionEngine = closeConnectionEngine;
        if (this.mFileDownloadTaskImpl != null) {
            this.mFileDownloadTaskImpl.setCloseConnectionEngine(this.mCloseConnectionEngine);
        }
    }

    public void setConnectTimeout(int connectTimeout) {
        this.mConnectTimeout = connectTimeout;
        if (this.mFileDownloadTaskImpl != null) {
            this.mFileDownloadTaskImpl.setConnectTimeout(this.mConnectTimeout);
        }
    }

    @Override
    public void setRetryDownloadTimes(int retryDownloadTimes) {
        this.mRetryDownloadTimes = retryDownloadTimes;
    }

    private DownloadFileInfo getDownloadFile() {
        if (this.mDownloadRecorder == null) {
            return null;
        }
        return this.mDownloadRecorder.getDownloadFile(this.getUrl());
    }

    @Override
    public String getUrl() {
        if (this.mOriginalTaskParamInfo == null) {
            return null;
        }
        return this.mOriginalTaskParamInfo.getUrl();
    }

    private boolean notifyStatusRetrying() {
        try {
            if (this.mOnFileDownloadStatusListener instanceof OnRetryableFileDownloadStatusListener) {
                OnRetryableFileDownloadStatusListener onRetryableFileDownloadStatusListener = (OnRetryableFileDownloadStatusListener)this.mOnFileDownloadStatusListener;
                this.mDownloadRecorder.recordStatus(this.getUrl(), 9, 0);
                if (onRetryableFileDownloadStatusListener != null) {
                    onRetryableFileDownloadStatusListener.onFileDownloadStatusRetrying(this.getDownloadFile(), this.mHasRetriedTimes);
                }
                Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u91cd\u8bd5\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
                return true;
            }
            return this.notifyStatusWaiting();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mFinishState = new DownloadTaskImpl.FinishState(7, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.getUrl(), e));
            return false;
        }
    }

    private boolean notifyStatusWaiting() {
        try {
            this.mDownloadRecorder.recordStatus(this.getUrl(), 1, 0);
            if (this.mOnFileDownloadStatusListener != null) {
                this.mOnFileDownloadStatusListener.onFileDownloadStatusWaiting(this.getDownloadFile());
            }
            Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u7b49\u5f85\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mFinishState = new DownloadTaskImpl.FinishState(7, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.getUrl(), e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void notifyTaskFinish() {
        if (this.mFinishState == null) {
            this.mFinishState = new DownloadTaskImpl.FinishState(6);
        }
        int status = this.mFinishState.status;
        int increaseSize = this.mFinishState.increaseSize;
        OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason = this.mFinishState.failReason;
        switch (status) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.mIsNotifyTaskFinish.get()) {
                    return;
                }
                this.mDownloadRecorder.recordStatus(this.getUrl(), status, increaseSize);
                switch (status) {
                    case 6: {
                        if (this.mOnFileDownloadStatusListener == null || !this.mIsNotifyTaskFinish.compareAndSet(false, true)) break;
                        this.mOnFileDownloadStatusListener.onFileDownloadStatusPaused(this.getDownloadFile());
                        Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
                        break;
                    }
                    case 5: {
                        if (this.mOnFileDownloadStatusListener == null || !this.mIsNotifyTaskFinish.compareAndSet(false, true)) break;
                        this.mOnFileDownloadStatusListener.onFileDownloadStatusCompleted(this.getDownloadFile());
                        Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u5b8c\u6210\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
                        break;
                    }
                    case 7: {
                        if (this.mOnFileDownloadStatusListener == null || !this.mIsNotifyTaskFinish.compareAndSet(false, true)) break;
                        this.mOnFileDownloadStatusListener.onFileDownloadStatusFailed(this.getUrl(), this.getDownloadFile(), failReason);
                        Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u9519\u8bef\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
                        break;
                    }
                    case 8: {
                        if (this.mOnFileDownloadStatusListener == null || !this.mIsNotifyTaskFinish.compareAndSet(false, true)) break;
                        this.mOnFileDownloadStatusListener.onFileDownloadStatusFailed(this.getUrl(), this.getDownloadFile(), failReason);
                        Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6587\u4ef6\u4e0d\u5b58\u5728\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
                    }
                }
                if (!this.mIsNotifyTaskFinish.compareAndSet(false, true)) break;
                try {
                    this.mDownloadRecorder.recordStatus(this.getUrl(), 6, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.mOnFileDownloadStatusListener != null) {
                    this.mOnFileDownloadStatusListener.onFileDownloadStatusPaused(this.getDownloadFile());
                }
                Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
                break;
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        if (this.mIsNotifyTaskFinish.compareAndSet(false, true)) {
                            try {
                                this.mDownloadRecorder.recordStatus(this.getUrl(), 7, 0);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                            if (this.mOnFileDownloadStatusListener != null) {
                                this.mOnFileDownloadStatusListener.onFileDownloadStatusFailed(this.getUrl(), this.getDownloadFile(), new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(this.getUrl(), e));
                                Log.e(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c/\u5b8c\u6210/\u51fa\u9519\u72b6\u6001\u3011\u5931\u8d25\uff0curl\uff1a" + this.getUrl());
                            }
                        }
                        if (!this.mIsNotifyTaskFinish.compareAndSet(false, true)) break;
                    }
                    catch (Throwable throwable) {
                        if (this.mIsNotifyTaskFinish.compareAndSet(false, true)) {
                            try {
                                this.mDownloadRecorder.recordStatus(this.getUrl(), 6, 0);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                            if (this.mOnFileDownloadStatusListener != null) {
                                this.mOnFileDownloadStatusListener.onFileDownloadStatusPaused(this.getDownloadFile());
                            }
                            Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
                        }
                        throw throwable;
                    }
                    try {
                        this.mDownloadRecorder.recordStatus(this.getUrl(), 6, 0);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                    if (this.mOnFileDownloadStatusListener != null) {
                        this.mOnFileDownloadStatusListener.onFileDownloadStatusPaused(this.getDownloadFile());
                    }
                    Log.i(TAG, "file-downloader-status \u8bb0\u5f55\u3010\u6682\u505c\u72b6\u6001\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
                    break;
                }
            }
        }
    }

    private void notifyStopTaskSucceedIfNecessary() {
        if (this.mOnStopFileDownloadTaskListener != null) {
            this.mOnStopFileDownloadTaskListener.onStopFileDownloadTaskSucceed(this.getUrl());
            this.mOnStopFileDownloadTaskListener = null;
            Log.i(TAG, "file-downloader-status \u901a\u77e5\u3010\u6682\u505c\u4efb\u52a1\u3011\u6210\u529f\uff0curl\uff1a" + this.getUrl());
        }
    }

    private void notifyStopTaskFailedIfNecessary(OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
        if (this.mOnStopFileDownloadTaskListener != null) {
            this.mOnStopFileDownloadTaskListener.onStopFileDownloadTaskFailed(this.getUrl(), failReason);
            this.mOnStopFileDownloadTaskListener = null;
            Log.e(TAG, "file-downloader-status \u901a\u77e5\u3010\u6682\u505c\u4efb\u52a1\u3011\u5931\u8d25\uff0curl\uff1a" + this.getUrl());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isStopped() {
        if (this.mIsTaskStop && !this.mFileDownloadTaskImpl.isStopped()) {
            this.stopInternalImpl();
        }
        return this.mIsTaskStop;
    }

    @Override
    public void stop() {
        Log.d(TAG, TAG + ".stop \u7ed3\u675f\u4efb\u52a1\u6267\u884c\uff0curl\uff1a" + this.getUrl() + ",\u662f\u5426\u5df2\u7ecf\u6682\u505c\uff1a" + this.mIsTaskStop);
        if (this.isStopped()) {
            this.notifyStopTaskFailedIfNecessary(new OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason(this.getUrl(), "the task has been stopped!", OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason.TYPE_TASK_HAS_BEEN_STOPPED));
            return;
        }
        if (Thread.currentThread() == this.mCurrentTaskThread) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    RetryableDownloadTaskImpl.this.mIsTaskStop = true;
                    Log.d(TAG, TAG + ".stop \u7ed3\u675f\u4efb\u52a1\u6267\u884c(\u4e3b\u7ebf\u7a0b\u53d1\u8d77)\uff0curl\uff1a" + RetryableDownloadTaskImpl.this.getUrl() + ",\u662f\u5426\u5df2\u7ecf\u6682\u505c\uff1a" + RetryableDownloadTaskImpl.this.mIsTaskStop);
                    RetryableDownloadTaskImpl.this.stopInternalImpl();
                }
            });
        } else {
            this.mIsTaskStop = true;
            Log.d(TAG, TAG + ".stop \u7ed3\u675f\u4efb\u52a1\u6267\u884c(\u5176\u5b83\u7ebf\u7a0b\u53d1\u8d77)\uff0curl\uff1a" + this.getUrl() + ",\u662f\u5426\u5df2\u7ecf\u6682\u505c\uff1a" + this.mIsTaskStop);
            this.stopInternalImpl();
        }
    }

    private void stopInternalImpl() {
        if (Thread.currentThread() == this.mCurrentTaskThread) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (!RetryableDownloadTaskImpl.this.mFileDownloadTaskImpl.isStopped()) {
                        RetryableDownloadTaskImpl.this.mFileDownloadTaskImpl.stop();
                    }
                    if (!RetryableDownloadTaskImpl.this.mIsRunning) {
                        RetryableDownloadTaskImpl.this.notifyTaskFinish();
                        RetryableDownloadTaskImpl.this.notifyStopTaskSucceedIfNecessary();
                    }
                }
            });
        } else {
            if (!this.mFileDownloadTaskImpl.isStopped()) {
                this.mFileDownloadTaskImpl.stop();
            }
            if (!this.mIsRunning) {
                this.notifyTaskFinish();
                this.notifyStopTaskSucceedIfNecessary();
            }
        }
    }

    @Override
    public void onFileDownloadStatusWaiting(DownloadFileInfo downloadFileInfo) {
        if (this.mIsTaskStop) {
            this.stopInternalImpl();
            return;
        }
        if (this.mOnFileDownloadStatusListener != null) {
            this.mOnFileDownloadStatusListener.onFileDownloadStatusWaiting(downloadFileInfo);
        }
    }

    @Override
    public void onFileDownloadStatusPreparing(DownloadFileInfo downloadFileInfo) {
        if (this.mIsTaskStop) {
            this.stopInternalImpl();
            return;
        }
        if (this.mOnFileDownloadStatusListener != null) {
            this.mOnFileDownloadStatusListener.onFileDownloadStatusPreparing(downloadFileInfo);
        }
    }

    @Override
    public void onFileDownloadStatusPrepared(DownloadFileInfo downloadFileInfo) {
        if (this.mIsTaskStop) {
            this.stopInternalImpl();
            return;
        }
        if (this.mOnFileDownloadStatusListener != null) {
            this.mOnFileDownloadStatusListener.onFileDownloadStatusPrepared(downloadFileInfo);
        }
        if (DownloadFileUtil.isLegal(downloadFileInfo)) {
            this.mRecordedRange = new Range(downloadFileInfo.getDownloadedSizeLong(), this.mRecordedRange.endPos);
        }
    }

    @Override
    public void onFileDownloadStatusDownloading(DownloadFileInfo downloadFileInfo, float downloadSpeed, long remainingTime) {
        if (this.mIsTaskStop) {
            this.stopInternalImpl();
            return;
        }
        if (this.mOnFileDownloadStatusListener != null) {
            this.mOnFileDownloadStatusListener.onFileDownloadStatusDownloading(downloadFileInfo, downloadSpeed, remainingTime);
        }
    }

    @Override
    public void onFileDownloadStatusPaused(DownloadFileInfo downloadFileInfo) {
        this.mFinishState = new DownloadTaskImpl.FinishState(6);
        if (DownloadFileUtil.isLegal(downloadFileInfo)) {
            this.mRecordedRange = new Range(this.mRecordedRange.startPos, downloadFileInfo.getDownloadedSizeLong());
        }
    }

    @Override
    public void onFileDownloadStatusCompleted(DownloadFileInfo downloadFileInfo) {
        this.mFinishState = new DownloadTaskImpl.FinishState(5);
        if (DownloadFileUtil.isLegal(downloadFileInfo)) {
            this.mRecordedRange = new Range(this.mRecordedRange.startPos, downloadFileInfo.getDownloadedSizeLong());
        }
    }

    @Override
    public void onFileDownloadStatusFailed(String url, DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason) {
        if (DownloadFileUtil.isLegal(downloadFileInfo)) {
            this.mFinishState = downloadFileInfo.getStatus() == 8 ? new DownloadTaskImpl.FinishState(8, failReason) : new DownloadTaskImpl.FinishState(7, failReason);
            this.mRecordedRange = new Range(this.mRecordedRange.startPos, downloadFileInfo.getDownloadedSizeLong());
        }
    }
}

