/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.content.Context;
import java.util.List;
import org.wlf.filedownloader.DownloadCacher;
import org.wlf.filedownloader.DownloadConfiguration;
import org.wlf.filedownloader.DownloadFileChangeConfiguration;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.DownloadStatusConfiguration;
import org.wlf.filedownloader.FileDownloadConfiguration;
import org.wlf.filedownloader.FileDownloader;
import org.wlf.filedownloader.base.Control;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_delete.DownloadDeleteManager;
import org.wlf.filedownloader.file_download.DownloadTaskManager;
import org.wlf.filedownloader.file_move.DownloadMoveManager;
import org.wlf.filedownloader.file_rename.DownloadRenameManager;
import org.wlf.filedownloader.listener.OnDeleteDownloadFileListener;
import org.wlf.filedownloader.listener.OnDeleteDownloadFilesListener;
import org.wlf.filedownloader.listener.OnDetectBigUrlFileListener;
import org.wlf.filedownloader.listener.OnDetectUrlFileListener;
import org.wlf.filedownloader.listener.OnDownloadFileChangeListener;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFilesListener;
import org.wlf.filedownloader.listener.OnRenameDownloadFileListener;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.DownloadFileUtil;

@Deprecated
public final class FileDownloadManager {
    private static final String TAG = FileDownloadManager.class.getSimpleName();
    private static FileDownloadManager sInstance;
    private Object mInitLock = new Object();
    private FileDownloadConfiguration mConfiguration;
    private DownloadCacher mDownloadFileCacher;
    private DownloadTaskManager mDownloadTaskManager;
    private DownloadMoveManager mDownloadMoveManager;
    private DownloadDeleteManager mDownloadDeleteManager;
    private DownloadRenameManager mDownloadRenameManager;

    private FileDownloadManager(Context context) {
        Context appContext = context.getApplicationContext();
        this.mDownloadFileCacher = new DownloadCacher(appContext);
        this.checkAndRecoveryExceptionStatus(this.getDownloadFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileDownloadManager getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<FileDownloadManager> clazz = FileDownloadManager.class;
        synchronized (FileDownloadManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new FileDownloadManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private void checkAndRecoveryExceptionStatus(List<DownloadFileInfo> downloadFileInfos) {
        Log.i(TAG, "checkAndRecoveryExceptionStatus \u5f02\u5e38\u6062\u590d\u68c0\u67e5\uff01");
        if (CollectionUtil.isEmpty(downloadFileInfos)) {
            return;
        }
        for (DownloadFileInfo downloadFileInfo : downloadFileInfos) {
            if (!DownloadFileUtil.isLegal(downloadFileInfo)) continue;
            String url = downloadFileInfo.getUrl();
            if (this.isInit() && this.getDownloadTaskManager().isDownloading(url)) continue;
            DownloadFileUtil.recoveryExceptionStatus(this.mDownloadFileCacher, downloadFileInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FileDownloadConfiguration configuration) {
        Object object = this.mInitLock;
        synchronized (object) {
            this.mConfiguration = configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInit() {
        Object object = this.mInitLock;
        synchronized (object) {
            return this.mConfiguration != null;
        }
    }

    private void checkInit() {
        if (!this.isInit()) {
            throw new IllegalStateException("Please init the file-downloader by using " + FileDownloader.class.getSimpleName() + ".init(FileDownloadConfiguration) or " + FileDownloadManager.class.getSimpleName() + ".init(FileDownloadConfiguration) if the version is below 0.2.0 !");
        }
    }

    public void release() {
        this.getDownloadTaskManager().release(new DownloadTaskManager.OnReleaseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReleased() {
                Object object = FileDownloadManager.this.mInitLock;
                synchronized (object) {
                    if (FileDownloadManager.this.mConfiguration != null) {
                        FileDownloadManager.this.mConfiguration.getFileDetectEngine().shutdown();
                        FileDownloadManager.this.mConfiguration.getFileDownloadEngine().shutdown();
                        FileDownloadManager.this.mConfiguration.getFileOperationEngine().shutdown();
                    }
                    FileDownloadManager.this.mDownloadFileCacher.release();
                    sInstance = null;
                }
            }
        });
    }

    private DownloadTaskManager getDownloadTaskManager() {
        this.checkInit();
        if (this.mDownloadTaskManager == null) {
            this.mDownloadTaskManager = new DownloadTaskManager(this.mConfiguration, this.mDownloadFileCacher);
        }
        return this.mDownloadTaskManager;
    }

    private DownloadMoveManager getDownloadMoveManager() {
        this.checkInit();
        if (this.mDownloadMoveManager == null) {
            this.mDownloadMoveManager = new DownloadMoveManager(this.mConfiguration.getFileOperationEngine(), this.mDownloadFileCacher, this.getDownloadTaskManager());
        }
        return this.mDownloadMoveManager;
    }

    private DownloadDeleteManager getDownloadDeleteManager() {
        this.checkInit();
        if (this.mDownloadDeleteManager == null) {
            this.mDownloadDeleteManager = new DownloadDeleteManager(this.mConfiguration.getFileOperationEngine(), this.mDownloadFileCacher, this.getDownloadTaskManager());
        }
        return this.mDownloadDeleteManager;
    }

    private DownloadRenameManager getDownloadRenameManager() {
        this.checkInit();
        if (this.mDownloadRenameManager == null) {
            this.mDownloadRenameManager = new DownloadRenameManager(this.mConfiguration.getFileOperationEngine(), this.mDownloadFileCacher, this.getDownloadTaskManager());
        }
        return this.mDownloadRenameManager;
    }

    public DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileCacher.getDownloadFile(url);
    }

    @Deprecated
    public DownloadFileInfo getDownloadFileByUrl(String url) {
        return this.mDownloadFileCacher.getDownloadFile(url);
    }

    public DownloadFileInfo getDownloadFileBySavePath(String savePath) {
        return this.mDownloadFileCacher.getDownloadFileBySavePath(savePath, false);
    }

    public DownloadFileInfo getDownloadFileByTempPath(String tempPath) {
        return this.mDownloadFileCacher.getDownloadFileBySavePath(tempPath, true);
    }

    @Deprecated
    public DownloadFileInfo getDownloadFileBySavePath(String savePath, boolean includeTempFilePath) {
        return this.mDownloadFileCacher.getDownloadFileBySavePath(savePath, includeTempFilePath);
    }

    public List<DownloadFileInfo> getDownloadFiles() {
        return this.mDownloadFileCacher.getDownloadFiles();
    }

    public String getDownloadDir() {
        this.checkInit();
        return this.mConfiguration.getFileDownloadDir();
    }

    public void registerDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.registerDownloadStatusListener(onFileDownloadStatusListener, null);
    }

    public void unregisterDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.getDownloadTaskManager().unregisterDownloadStatusListener(onFileDownloadStatusListener);
    }

    @Deprecated
    public void detect(String url, OnDetectUrlFileListener onDetectUrlFileListener) {
        this.getDownloadTaskManager().detect(url, onDetectUrlFileListener, null);
    }

    public void detect(String url, OnDetectBigUrlFileListener onDetectBigUrlFileListener) {
        this.detect(url, onDetectBigUrlFileListener, null);
    }

    public void createAndStart(String url, String saveDir, String fileName) {
        this.getDownloadTaskManager().createAndStart(url, saveDir, fileName, null);
    }

    @Deprecated
    public void createAndStart(String url, String saveDir, String fileName, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        DownloadStatusConfiguration.Builder builder = new DownloadStatusConfiguration.Builder();
        builder.addListenUrl(url);
        builder.configAutoRelease(true);
        this.registerDownloadStatusListener(onFileDownloadStatusListener, builder.build());
        this.createAndStart(url, saveDir, fileName);
    }

    public void start(String url) {
        this.getDownloadTaskManager().start(url, null);
    }

    @Deprecated
    public void start(String url, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        DownloadStatusConfiguration.Builder builder = new DownloadStatusConfiguration.Builder();
        builder.addListenUrl(url);
        builder.configAutoRelease(true);
        this.registerDownloadStatusListener(onFileDownloadStatusListener, builder.build());
        this.start(url);
    }

    public void start(List<String> urls) {
        this.getDownloadTaskManager().start(urls, null);
    }

    @Deprecated
    public void start(List<String> urls, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        DownloadStatusConfiguration.Builder builder = new DownloadStatusConfiguration.Builder();
        builder.addListenUrls(urls);
        builder.configAutoRelease(true);
        this.registerDownloadStatusListener(onFileDownloadStatusListener, builder.build());
        this.start(urls);
    }

    public void pause(String url) {
        this.getDownloadTaskManager().pause(url, null);
    }

    public void pause(List<String> urls) {
        this.getDownloadTaskManager().pause(urls, null);
    }

    public void pauseAll() {
        this.getDownloadTaskManager().pauseAll(null);
    }

    public void reStart(String url) {
        this.getDownloadTaskManager().reStart(url, null);
    }

    @Deprecated
    public void reStart(String url, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        DownloadStatusConfiguration.Builder builder = new DownloadStatusConfiguration.Builder();
        builder.addListenUrl(url);
        builder.configAutoRelease(true);
        this.registerDownloadStatusListener(onFileDownloadStatusListener, builder.build());
        this.reStart(url);
    }

    public void reStart(List<String> urls) {
        this.getDownloadTaskManager().reStart(urls, null);
    }

    @Deprecated
    public void reStart(List<String> urls, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        DownloadStatusConfiguration.Builder builder = new DownloadStatusConfiguration.Builder();
        builder.addListenUrls(urls);
        builder.configAutoRelease(true);
        this.registerDownloadStatusListener(onFileDownloadStatusListener, builder.build());
        this.reStart(urls);
    }

    public void move(String url, String newDirPath, OnMoveDownloadFileListener onMoveDownloadFileListener) {
        this.getDownloadMoveManager().move(url, newDirPath, onMoveDownloadFileListener);
    }

    public Control move(List<String> urls, String newDirPath, OnMoveDownloadFilesListener onMoveDownloadFilesListener) {
        return this.getDownloadMoveManager().move(urls, newDirPath, onMoveDownloadFilesListener);
    }

    public void delete(String url, boolean deleteDownloadedFileInPath, OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        this.getDownloadDeleteManager().delete(url, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
    }

    public Control delete(List<String> urls, boolean deleteDownloadedFile, OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
        return this.getDownloadDeleteManager().delete(urls, deleteDownloadedFile, onDeleteDownloadFilesListener);
    }

    public void rename(String url, String newFileName, boolean includedSuffix, OnRenameDownloadFileListener onRenameDownloadFileListener) {
        this.getDownloadRenameManager().rename(url, newFileName, includedSuffix, onRenameDownloadFileListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileDownloadConfiguration getFileDownloadConfiguration() {
        if (sInstance != null) {
            Object object = FileDownloadManager.sInstance.mInitLock;
            synchronized (object) {
                if (sInstance != null) {
                    return FileDownloadManager.sInstance.mConfiguration;
                }
            }
        }
        return null;
    }

    void registerDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener, DownloadStatusConfiguration downloadStatusConfiguration) {
        this.getDownloadTaskManager().registerDownloadStatusListener(onFileDownloadStatusListener, downloadStatusConfiguration);
    }

    void registerDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener, DownloadFileChangeConfiguration downloadFileChangeConfiguration) {
        this.mDownloadFileCacher.registerDownloadFileChangeListener(onDownloadFileChangeListener, downloadFileChangeConfiguration);
    }

    void unregisterDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        this.mDownloadFileCacher.unregisterDownloadFileChangeListener(onDownloadFileChangeListener);
    }

    void detect(String url, OnDetectBigUrlFileListener onDetectBigUrlFileListener, DownloadConfiguration downloadConfiguration) {
        this.getDownloadTaskManager().detect(url, onDetectBigUrlFileListener, downloadConfiguration);
    }

    void createAndStart(String url, String saveDir, String fileName, DownloadConfiguration downloadConfiguration) {
        this.getDownloadTaskManager().createAndStart(url, saveDir, fileName, downloadConfiguration);
    }

    void start(String url, DownloadConfiguration downloadConfiguration) {
        this.getDownloadTaskManager().start(url, downloadConfiguration);
    }

    void start(List<String> urls, DownloadConfiguration downloadConfiguration) {
        this.getDownloadTaskManager().start(urls, downloadConfiguration);
    }

    void reStart(String url, DownloadConfiguration downloadConfiguration) {
        this.getDownloadTaskManager().reStart(url, downloadConfiguration);
    }

    void reStart(List<String> urls, DownloadConfiguration downloadConfiguration) {
        this.getDownloadTaskManager().reStart(urls, downloadConfiguration);
    }
}

