/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.wlf.filedownloader.DownloadFileChangeConfiguration;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.listener.OnDownloadFileChangeListener;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.DownloadFileUtil;
import org.wlf.filedownloader.util.UrlUtil;

class DownloadFileChangeObserver
implements OnDownloadFileChangeListener {
    private static final String TAG = DownloadFileChangeObserver.class.getSimpleName();
    private Set<DownloadFileChangeListenerInfo> mOnDownloadFileChangeListeners = new CopyOnWriteArraySet<DownloadFileChangeListenerInfo>();

    DownloadFileChangeObserver() {
    }

    public void addOnDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener, DownloadFileChangeConfiguration downloadFileChangeConfiguration) {
        if (onDownloadFileChangeListener == null) {
            return;
        }
        for (DownloadFileChangeListenerInfo listenerInfo : this.mOnDownloadFileChangeListeners) {
            if (listenerInfo == null) {
                return;
            }
            if (listenerInfo.mListener != onDownloadFileChangeListener) continue;
            return;
        }
        DownloadFileChangeListenerInfo listenerInfo = new DownloadFileChangeListenerInfo(downloadFileChangeConfiguration, onDownloadFileChangeListener);
        this.mOnDownloadFileChangeListeners.add(listenerInfo);
        String urls = downloadFileChangeConfiguration != null && !CollectionUtil.isEmpty(downloadFileChangeConfiguration.getListenUrls()) ? downloadFileChangeConfiguration.getListenUrls().toString() : "all";
        Log.i(TAG, "file-downloader-listener \u6dfb\u52a0\u3010\u4e0b\u8f7d\u6587\u4ef6\u6539\u53d8\u76d1\u542c\u5668\u3011\u6210\u529f\uff0c\u8be5listener\u76d1\u542c\u7684urls\uff1a" + urls);
    }

    public void removeOnDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        if (onDownloadFileChangeListener == null) {
            return;
        }
        for (DownloadFileChangeListenerInfo listenerInfo : this.mOnDownloadFileChangeListeners) {
            if (listenerInfo == null || listenerInfo.mListener != onDownloadFileChangeListener) continue;
            this.mOnDownloadFileChangeListeners.remove(listenerInfo);
            String urls = listenerInfo.mDownloadFileChangeConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadFileChangeConfiguration.getListenUrls()) ? listenerInfo.mDownloadFileChangeConfiguration.getListenUrls().toString() : "all";
            Log.i(TAG, "file-downloader-listener \u79fb\u9664\u3010\u4e0b\u8f7d\u6587\u4ef6\u6539\u53d8\u76d1\u542c\u5668\u3011\u6210\u529f\uff0c\u8be5listener\u76d1\u542c\u7684urls\uff1a" + urls);
            break;
        }
    }

    private void notifyDownloadFileCreated(DownloadFileInfo downloadFileInfo, OnDownloadFileChangeListener listener, boolean sync) {
        if (sync) {
            try {
                if (listener != null) {
                    listener.onDownloadFileCreated(downloadFileInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            OnDownloadFileChangeListener.MainThreadHelper.onDownloadFileCreated(downloadFileInfo, listener);
        }
        String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u4e0b\u8f7d\u6587\u4ef6\u88ab\u521b\u5efa\u3011\uff0c\u88ab\u521b\u5efa\u6587\u4ef6\u7684url\uff1a" + url);
    }

    private void notifyDownloadFileUpdated(DownloadFileInfo downloadFileInfo, OnDownloadFileChangeListener.Type type, OnDownloadFileChangeListener listener, boolean sync) {
        if (sync) {
            try {
                if (listener != null) {
                    listener.onDownloadFileUpdated(downloadFileInfo, type);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            OnDownloadFileChangeListener.MainThreadHelper.onDownloadFileUpdated(downloadFileInfo, type, listener);
        }
        String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        String typeName = type != null ? type.name() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u4e0b\u8f7d\u6587\u4ef6\u88ab\u66f4\u65b0\u3011\uff0c\u66f4\u65b0\u7c7b\u578b\uff1a" + typeName + "\uff0c\u88ab\u66f4\u65b0\u6587\u4ef6\u7684url\uff1a" + url);
    }

    private void notifyDownloadFileDeleted(DownloadFileInfo downloadFileInfo, OnDownloadFileChangeListener listener, boolean sync) {
        if (sync) {
            try {
                if (listener != null) {
                    listener.onDownloadFileDeleted(downloadFileInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            OnDownloadFileChangeListener.MainThreadHelper.onDownloadFileDeleted(downloadFileInfo, listener);
        }
        String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u4e0b\u8f7d\u6587\u4ef6\u88ab\u5220\u9664\u3011\uff0c\u88ab\u5220\u9664\u6587\u4ef6\u7684url\uff1a" + url);
    }

    @Override
    public void onDownloadFileCreated(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadFileChangeListenerInfo listenerInfo : this.mOnDownloadFileChangeListeners) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadFileChangeConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadFileChangeConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadFileChangeConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyDownloadFileCreated(downloadFileInfo, listenerInfo.mListener, listenerInfo.mDownloadFileChangeConfiguration.isTreadCallback());
                }
                continue;
            }
            boolean isSyncCallback = false;
            if (listenerInfo.mDownloadFileChangeConfiguration != null) {
                isSyncCallback = listenerInfo.mDownloadFileChangeConfiguration.isTreadCallback();
            }
            this.notifyDownloadFileCreated(downloadFileInfo, listenerInfo.mListener, isSyncCallback);
        }
    }

    @Override
    public void onDownloadFileUpdated(DownloadFileInfo downloadFileInfo, OnDownloadFileChangeListener.Type type) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadFileChangeListenerInfo listenerInfo : this.mOnDownloadFileChangeListeners) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadFileChangeConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadFileChangeConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadFileChangeConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyDownloadFileUpdated(downloadFileInfo, type, listenerInfo.mListener, listenerInfo.mDownloadFileChangeConfiguration.isTreadCallback());
                }
                continue;
            }
            boolean isSyncCallback = false;
            if (listenerInfo.mDownloadFileChangeConfiguration != null) {
                isSyncCallback = listenerInfo.mDownloadFileChangeConfiguration.isTreadCallback();
            }
            this.notifyDownloadFileUpdated(downloadFileInfo, type, listenerInfo.mListener, isSyncCallback);
        }
    }

    @Override
    public void onDownloadFileDeleted(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadFileChangeListenerInfo listenerInfo : this.mOnDownloadFileChangeListeners) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadFileChangeConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadFileChangeConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadFileChangeConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyDownloadFileDeleted(downloadFileInfo, listenerInfo.mListener, listenerInfo.mDownloadFileChangeConfiguration.isTreadCallback());
                }
                continue;
            }
            boolean isSyncCallback = false;
            if (listenerInfo.mDownloadFileChangeConfiguration != null) {
                isSyncCallback = listenerInfo.mDownloadFileChangeConfiguration.isTreadCallback();
            }
            this.notifyDownloadFileDeleted(downloadFileInfo, listenerInfo.mListener, isSyncCallback);
        }
    }

    public void release() {
        this.mOnDownloadFileChangeListeners.clear();
    }

    private class DownloadFileChangeListenerInfo {
        private DownloadFileChangeConfiguration mDownloadFileChangeConfiguration;
        private OnDownloadFileChangeListener mListener;

        public DownloadFileChangeListenerInfo(DownloadFileChangeConfiguration downloadFileChangeConfiguration, OnDownloadFileChangeListener listener) {
            this.mDownloadFileChangeConfiguration = downloadFileChangeConfiguration;
            this.mListener = listener;
        }
    }
}

