/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.util;

import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    public static final boolean createFileParentDir(String filePath) {
        File file = new File(filePath);
        if (file != null) {
            if (file.exists()) {
                return true;
            }
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                if (parentFile.exists()) {
                    return true;
                }
                return parentFile.mkdirs();
            }
        }
        return false;
    }

    public static String getFileSuffix(String filePath) {
        int start;
        if (!TextUtils.isEmpty((CharSequence)filePath) && (start = filePath.lastIndexOf(".")) != -1) {
            return filePath.substring(start + 1);
        }
        return null;
    }

    public static boolean isFilePath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return path.startsWith(File.separator);
    }

    public static final boolean canWrite(String path) {
        if (FileUtil.isSDCardPath(path)) {
            return "mounted".equals(Environment.getExternalStorageState());
        }
        return true;
    }

    public static final boolean isSDCardPath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        String sdRootPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        return path.startsWith(sdRootPath);
    }

    public static long getAvailableSpace(String fileDirPath) {
        try {
            File file = new File(fileDirPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            StatFs stats = new StatFs(fileDirPath);
            long result = (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static boolean copyFile(File fromFile, File toFile, boolean forceOverwrite) {
        if (fromFile == null || !fromFile.exists() || toFile == null) {
            return false;
        }
        if (toFile.exists() && !forceOverwrite) {
            return false;
        }
        try {
            FileInputStream fosFrom = new FileInputStream(fromFile);
            FileOutputStream fosTo = new FileOutputStream(toFile);
            byte[] bytes = new byte[1024];
            int writeSize = 0;
            int startIndex = 0;
            int readCount = 0;
            while ((readCount = ((InputStream)fosFrom).read(bytes)) != -1) {
                ((OutputStream)fosTo).write(bytes, startIndex, readCount);
                writeSize += readCount - startIndex;
            }
            ((InputStream)fosFrom).close();
            ((OutputStream)fosTo).close();
            return writeSize > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isFileExist(String filePath) {
        if (!FileUtil.isFilePath(filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file != null && file.exists() && file.isFile();
    }
}

