/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.util;

import java.io.File;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.BaseUrlFileInfo;
import org.wlf.filedownloader.file_download.db_recorder.Record;
import org.wlf.filedownloader.util.FileUtil;
import org.wlf.filedownloader.util.UrlUtil;

public class DownloadFileUtil {
    public static boolean isDownloadingStatus(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        switch (downloadFileInfo.getStatus()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean canDelete(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        return !DownloadFileUtil.isDownloadingStatus(downloadFileInfo);
    }

    public static boolean canMove(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        return !DownloadFileUtil.isDownloadingStatus(downloadFileInfo);
    }

    public static boolean canRename(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        return !DownloadFileUtil.isDownloadingStatus(downloadFileInfo);
    }

    public static boolean isCompleted(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        switch (downloadFileInfo.getStatus()) {
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLegal(BaseUrlFileInfo baseUrlFileInfo) {
        return baseUrlFileInfo != null && UrlUtil.isUrl(baseUrlFileInfo.getUrl());
    }

    public static boolean hasException(int status) {
        switch (status) {
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTempFileExist(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        if (downloadFileInfo.getDownloadedSizeLong() >= 0L) {
            return FileUtil.isFileExist(downloadFileInfo.getTempFilePath());
        }
        return false;
    }

    public static boolean tryToRenameTempFileToSaveFile(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return false;
        }
        if (DownloadFileUtil.isCompleted(downloadFileInfo)) {
            File saveFile = new File(downloadFileInfo.getFilePath());
            if (saveFile.exists() && saveFile.length() == downloadFileInfo.getDownloadedSizeLong() && saveFile.length() == downloadFileInfo.getFileSizeLong()) {
                return true;
            }
        } else if (downloadFileInfo.getDownloadedSizeLong() == downloadFileInfo.getFileSizeLong()) {
            File tempFile = new File(downloadFileInfo.getTempFilePath());
            File saveFile = new File(downloadFileInfo.getFilePath());
            if (tempFile.exists() && tempFile.length() == downloadFileInfo.getDownloadedSizeLong() && !saveFile.exists()) {
                boolean isSucceed = tempFile.renameTo(saveFile);
                return isSucceed;
            }
        }
        return false;
    }

    public static void recoveryExceptionStatus(Record record, DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        switch (downloadFileInfo.getStatus()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                try {
                    record.recordStatus(url, 6, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                try {
                    record.recordStatus(url, 7, 0);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

