/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.util;

import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateUtil {
    private static final Map<String, ThreadLocal<SimpleDateFormat>> DATE_FORMAT_MAP = new ConcurrentHashMap<String, ThreadLocal<SimpleDateFormat>>();

    private static SimpleDateFormat getSimpleDateFormat(String format) {
        SimpleDateFormat sdf;
        ThreadLocal<SimpleDateFormat> threadLocal = DATE_FORMAT_MAP.get(format);
        if (threadLocal == null) {
            threadLocal = new ThreadLocal();
            DATE_FORMAT_MAP.put(format, threadLocal);
        }
        if ((sdf = threadLocal.get()) == null) {
            sdf = new SimpleDateFormat(format, Locale.getDefault());
            threadLocal.set(sdf);
        }
        return sdf;
    }

    public static Date string2Date_yyyy_MM_dd_HH_mm_ss(String strDate) {
        if (TextUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat sdf = DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String date2String_yyyy_MM_dd_HH_mm_ss(Date date) {
        return DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }
}

